#version 120

#define M_PI 3.1415926535897932384626433832795
#define BG_CIRCLES 1
#define BG_SPOT 2
#define BG_SPIRAL 3

uniform sampler2D texture;
uniform float time = 1.0;
uniform float fade = 0.2;
uniform vec4 backgroundColor = vec4(0,0,0,0);
uniform float perspective = 1.67;
uniform float scale = 1.0;
uniform vec2 position = vec2(-0.5,-0.5);
uniform vec2 ufoPosition = vec2(-0.2,0.1);

//BG_SPIRAL uniforms
uniform float curveThickness = 0.2;
uniform float curveBendDegrees = 0;
uniform float curvesDegrees = 360;


float smoothStep(float x, float edge0, float edge1)
{
	float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
	float d = t * t * (3.0 - 2.0 * t);
	return d;
}

vec4 lineCircle(vec2 coord, float outerRadius) {
	coord.x *= perspective;

	float innerRadius = outerRadius-0.005;
	vec2 circlePosition = vec2(0.0,0.0);

	vec2 dposition = vec2(circlePosition.x*perspective,circlePosition.y);
	float d = length(dposition - coord) - outerRadius;

	vec4 color = vec4(0);
	if (d > outerRadius || d <= innerRadius)
	{
		//d = 0.0;
	}
	else if (d <= outerRadius)
	{
		color = vec4(1,1,1,0.6);
	}

	return color;
}

vec4 radarDot(vec2 coord, vec2 circlePosition)
{
	float outerRadius = 0.025;
	coord.x *= perspective;

	vec2 dposition = vec2(circlePosition.x*perspective,circlePosition.y);
	float d = length(dposition - coord) - outerRadius;

	vec4 color = vec4(0);
	if (d <= outerRadius)
	{
		float c = (1-d/outerRadius)*0.7;
		color = vec4(c,c,c,0.8);
	}

	return color;
}

void main()
{
	vec2 coord=gl_TexCoord[0].xy;

	float x = coord.x;
	float y = coord.y;

	vec4 color = backgroundColor;

	coord += position;

	//draw radar line
	float curvesRad = radians(curvesDegrees);
	float d = mod(-time*2.5+atan(coord.x,coord.y), curvesRad);
	if (d < curvesRad*curveThickness)
	{
		color = vec4(d,d,d,d*0.85);
	}

	//draw grid
	vec4 gridColor = vec4(1,1,1,0.4);
	if (mod(coord.x,0.2) <= 0.002)
	{
		color += gridColor;
	}
	if (mod(coord.y,0.2) <= 0.002)
	{
		color += gridColor;
	}

	//draw circles
	for(int i = 1; i <= 5; i++)
	{
		color += lineCircle(coord, 0.08*i);
	}

	color += radarDot(coord, ufoPosition);

	gl_FragColor = color * gl_Color;
}
