#version 120

//beers and greetings to iq and mercury for giving better comprehension about the subject

#define M_PI 3.1415926535897932384626433832795

uniform vec3 cameraEye = vec3(-2.3,3,-5.5);
uniform vec3 cameraUp = vec3(0,1,0);
uniform vec3 cameraRight = vec3(1,0,0);
uniform vec4 backgroundColor = vec4(0,0,0,0);
uniform int rayMaxSteps = 100;
uniform float rayHitThreshold = 0.001f;
uniform float zFar = 10.0f;
uniform float time = 1.0f;
uniform float normalAccuracy = 0.001f;

uniform vec3 displacementMagnitude = vec3(20,20,20);
uniform vec3 displacementMultiplier = vec3(0.01, 0.01, 0.01);
uniform float sphereSize = 0.8f;
uniform float miniSphereSize = 0.4f;
uniform float masterScale = 1.0f;

uniform vec3 spherePos1 = vec3(-0.5,-0.5,1);
uniform vec3 spherePos2 = vec3(0.5,0.5,1);
uniform vec3 spherePos3 = vec3(0.5,-0.5,1);
uniform vec3 spherePos4 = vec3(-0.5,0.5,1);
uniform vec3 spherePos5 = vec3(-0.5,0.5,1);

#define SCENE_METABALLS 1
uniform int scene = SCENE_METABALLS;

vec3 rotateY(vec3 v, float degrees)
{
    float radians = degrees*(M_PI/180.0);
    return vec3(v.x*cos(radians)+v.z*sin(radians), v.y, -v.x*sin(radians)+v.z*cos(radians));
}

vec3 rotateX(vec3 v, float degrees)
{
    float radians = degrees*(M_PI/180.0);
    return vec3(v.x, v.y*cos(radians)-v.z*sin(radians), v.y*sin(radians)+v.z*cos(radians));
}

float smin(float d1, float d2)
{
    float k = 0.6;
    float h = clamp(0.5+0.5*(d2-d1)/k, 0.0, 1.0);
    return mix(d2, d1, h) - k*h*(1.0-h);
}

float sdSphere(vec3 p, float r)
{
    return length(p)-r;
}

float opDisplace(vec3 p, float d1)
{
    float displacement = (
          (sin(displacementMagnitude.x*p.x)*displacementMultiplier.x)
        + (sin(displacementMagnitude.y*p.y)*displacementMultiplier.y)
        + (sin(displacementMagnitude.z*p.z)*displacementMultiplier.z)
    );

    return d1+displacement;
}

float calculateDistanceMap(vec3 p)
{
    float result = 0.0f;

    if (scene == SCENE_METABALLS)
    {
        p = rotateX(rotateY(p, time*100+p.y),time*100+p.x);


        float sphere = sdSphere(p, sphereSize*masterScale);

        float sphere1 = sdSphere(p+spherePos1, miniSphereSize*masterScale);
        float sphere2 = sdSphere(p+spherePos2, miniSphereSize*masterScale);
        float sphere3 = sdSphere(p+spherePos3, miniSphereSize*masterScale);
        float sphere4 = sdSphere(p+spherePos4, miniSphereSize*masterScale);
        float sphere5 = sdSphere(p+spherePos5, miniSphereSize*masterScale);

        result = 
            smin(
                smin(
                    smin(
                        smin(
                        smin(sphere, sphere1),
                        sphere2),
                    sphere3),
                sphere4),
            sphere5);

        result = opDisplace(p,result);
    }

    return result;
}

vec3 calculateNormal(vec3 p)
{
    vec3 vecX = vec3(normalAccuracy,0,0);
    vec3 vecY = vec3(0,normalAccuracy,0);
    vec3 vecZ = vec3(0,0,normalAccuracy);

    return normalize(vec3(
        calculateDistanceMap(p+vecX) - calculateDistanceMap(p-vecX),
        calculateDistanceMap(p+vecY) - calculateDistanceMap(p-vecY),
        calculateDistanceMap(p+vecZ) - calculateDistanceMap(p-vecZ))
    );
}

vec4 raymarch(vec2 uv)
{
    vec3 cameraTarget = normalize(cross(cameraRight, cameraUp) + cameraRight*uv.s + cameraUp*uv.t);

    vec4 color = backgroundColor;

    float rayDistance = 0.0;
    for(int i = 0; i < rayMaxSteps; i++)
    {
        vec3 rayPosition = cameraEye+cameraTarget*rayDistance;
        float distanceToSolid = calculateDistanceMap(rayPosition);
        if (rayDistance > zFar)
        {
            break;
        }
        else if (distanceToSolid < rayHitThreshold)
        {
            vec3 normal = calculateNormal(rayPosition);
            color = vec4(abs(vec3((normal.r+normal.g+normal.b)/3.0)), 1.0);
            break;
        }

        rayDistance += distanceToSolid;
    }

    return color;
}

void main()
{
    vec2 coord = gl_TexCoord[0].st;
    vec2 uv = vec2(coord.x*2-1,coord.y*2-1);

    gl_FragColor = raymarch(uv)*gl_Color;
}
