#version 120

uniform sampler2D texture;
uniform float time = 1.0;
uniform float perspective = 1.67;
uniform float scale = 1.0;
uniform vec2 position = vec2(0.5,0.5);

float rand(vec2 coord)
{
	return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

float smoothStep(float x, float edge0, float edge1)
{
	float t = clamp((x - edge0) / (edge1 - edge0), 0.0, 1.0);
	float d = t * t * (3.0 - 2.0 * t);
	return d;
}

vec4 signal(vec2 coord, float innerRadius, float outerRadius) {
	innerRadius *= scale;
	outerRadius *= scale;

	coord.x *= perspective;
	coord += rand(coord)*0.02;
	coord.s += sin(coord.t*20 + time*10)*0.01;
	coord.t += sin(coord.s*30 + time*8)*0.01;

	vec2 dposition = vec2(position.x*perspective,position.y);
	float d = length(dposition - coord) - outerRadius;

	vec4 color = vec4(0);
	if (d > outerRadius || d <= innerRadius)
	{
		//d = 0.0;
	}
	else if (d <= outerRadius)
	{
		d = smoothStep(d, innerRadius, outerRadius);
		color = vec4(1,1,1,d);
	}

	return color;
}

void main()
{
	vec2 coord=gl_TexCoord[0].xy;
    vec4 color = signal(coord, 0.05, 0.2);

    gl_FragColor = color * gl_Color;
}
