/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PVector;

public class demo_idaen_hitain
extends PApplet {
    Moonlander moonlander;
    Icosahedron ico1;
    float rotY;
    int scene;
    float f = 0.0f;
    float detail = 30.0f;
    int maxSize = 250;
    float scene3Rot;

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"musa_127.wav", (int)127, (int)4);
        this.moonlander.start();
        this.hint(6);
        this.background(0);
        this.ico1 = new Icosahedron(150.0f);
        this.scene3Rot = 0.0f;
    }

    public void draw() {
        this.moonlander.update();
        this.rectMode(0);
        float drawBG = (float)this.moonlander.getValue("draw_bg");
        if ((int)(drawBG * 255.0f) == 0) {
            this.background(0);
        }
        this.pushMatrix();
        this.translate(this.width / 2, this.height / 2, 0.0f);
        this.rotY = (float)Math.PI * 2 * (float)this.moonlander.getValue("rotY");
        this.scene = this.moonlander.getIntValue("scene");
        float fov = (float)this.moonlander.getValue("fov") / 1.0471976f;
        this.perspective(fov, PApplet.parseFloat((int)this.width) / PApplet.parseFloat((int)this.height), 1.0f, 5000.0f);
        this.scale(fov * 2.0f - 1.0f);
        switch (this.scene) {
            case 1: {
                this.drawScene1();
                break;
            }
            case 2: {
                this.drawScene2();
                break;
            }
            case 3: {
                this.drawScene3();
                break;
            }
            case 4: {
                this.drawScene4();
                break;
            }
            case 5: {
                this.drawScene5();
                break;
            }
            case 6: {
                this.drawScene6();
                break;
            }
            case 7: {
                this.drawScene7();
                break;
            }
            case 8: {
                this.drawScene8();
                break;
            }
            case 9: {
                this.drawScene9();
                break;
            }
        }
        this.popMatrix();
        if ((int)(drawBG * 255.0f) != 0) {
            this.noStroke();
            this.fill(0.0f, 0.0f, 0.0f, drawBG * 255.0f);
            this.rectMode(3);
            this.translate(0.0f, 0.0f, -1000.0f);
            this.rect(0.0f, 0.0f, this.width * 10, this.height * 10);
        }
    }

    public void drawScene1() {
        float c = (float)this.moonlander.getValue("clock");
        float kick = (float)this.moonlander.getValue("kick");
        boolean wireframe = this.getWireframe();
        this.fill(255);
        int nCubes = 32;
        int ringRadius = 70;
        int boxSize = 20;
        this.rotateY(this.rotY);
        this.rotateZ((float)Math.PI * 2 * c / 4.0f / 4.0f / 4.0f);
        this.colorMode(3);
        this.pushMatrix();
        int nRings = 10;
        this.translate(0.0f, 0.0f, 2 * boxSize * nRings / 2);
        int j = -nRings / 2;
        while (j < nRings / 2) {
            this.translate(0.0f, 0.0f, -2 * boxSize);
            this.pushMatrix();
            this.rotateZ((float)(-j) * ((float)Math.PI * 2) * 0.002f * c);
            float i = 0.0f;
            while (i < (float)Math.PI * 2) {
                this.pushMatrix();
                float r = (float)ringRadius * (3.0f + 0.2f * kick) * (2.0f + demo_idaen_hitain.sin((float)(c + (float)j)) * 0.05f) / 2.0f;
                SphericalCoords ptr = new SphericalCoords(0.0f, i, r);
                CartesianCoords xyz = ptr.toCartesian();
                this.translate(xyz.x, xyz.z, xyz.y);
                int h = (256 + (int)(-i / ((float)Math.PI * 2) * 255.0f + (float)demo_idaen_hitain.floor((float)(10.0f * c)))) % 256;
                if (!wireframe) {
                    this.noStroke();
                    this.fill(h, 255.0f, 255.0f);
                } else {
                    this.noFill();
                    this.stroke(h, 255.0f, 255.0f);
                }
                this.rotateZ(-i);
                this.box(boxSize, boxSize, (float)boxSize * (4.0f + kick) * 0.4f);
                this.popMatrix();
                i += (float)Math.PI * 2 / (float)nCubes;
            }
            this.popMatrix();
            ++j;
        }
        this.popMatrix();
        this.colorMode(1);
    }

    public void drawScene2() {
        float kick = (float)this.moonlander.getValue("kick");
        float pluck = (float)this.moonlander.getValue("pluck");
        float outroScale = (float)this.moonlander.getValue("sawOffset");
        this.scale(1.7f + 0.05f * kick + 0.1f * pluck);
        this.scale(outroScale);
        this.rotateY(this.rotY);
        this.rotateX(1.5707964f);
        this.noFill();
        this.stroke(255);
        this.strokeWeight(1.2f + pluck * 5.0f);
        this.ico1.create();
    }

    public void spaceShip(float clock) {
        this.stroke(255);
        this.noFill();
        this.rectMode(2);
        this.translate(this.width / 2 - 200, this.height / 2 - 200);
        this.rotateX(0.03926991f * clock);
        this.rotateY(0.06283186f * clock);
        float i = this.f;
        while (i < (float)Math.PI * 2 + this.f) {
            this.pushMatrix();
            this.translate(0.0f, 0.0f, demo_idaen_hitain.cos((float)i) * 50.0f);
            this.stroke(demo_idaen_hitain.max((float)(20.0f + demo_idaen_hitain.cos((float)i) * 150.0f), (float)0.0f) + 80.0f);
            this.ellipse(0.0f, 0.0f, (float)this.maxSize * 2.0f + demo_idaen_hitain.sin((float)i) * (float)this.maxSize, (float)this.maxSize * 2.0f + demo_idaen_hitain.sin((float)i) * (float)this.maxSize);
            this.rect(0.0f, 0.0f, (float)this.maxSize * 2.0f + demo_idaen_hitain.sin((float)i) * (float)this.maxSize, (float)this.maxSize * 2.0f + demo_idaen_hitain.sin((float)i) * (float)this.maxSize);
            this.popMatrix();
            i += (float)Math.PI * 2 / this.detail;
        }
        this.f = clock / 20.0f;
    }

    public boolean getWireframe() {
        return this.moonlander.getIntValue("wireframe") % 2 != 0;
    }

    public void drawScene3() {
        float zRot = (float)this.moonlander.getValue("rotZ") * ((float)Math.PI * 2);
        float yRot = (float)this.moonlander.getValue("rotY") * ((float)Math.PI * 2);
        float sawOffset = (float)this.moonlander.getValue("sawOffset");
        this.moonlander.getValue("pluck");
        float kick = (float)this.moonlander.getValue("kick");
        float c = (float)this.moonlander.getValue("clock");
        float spacing = (float)this.moonlander.getValue("lineSpacing");
        float vSpacing = (float)this.moonlander.getValue("lineSpacingV");
        int saw = (int)((c / 16.0f - (float)demo_idaen_hitain.floor((float)((c + sawOffset) / 16.0f))) * 256.0f) + 128;
        if (this.moonlander.getIntValue("draw_bg") == 0) {
            this.background(0.0f, 255 - saw / 2, saw);
        }
        int lines = 15;
        this.scene3Rot = c * kick / 5.0f;
        this.rotateY(yRot);
        this.rotateZ(zRot);
        this.stroke(0);
        this.strokeWeight(1.0f);
        float lineLength = 10000.0f;
        float i = 0.0f;
        while (i < (float)Math.PI * 2) {
            this.pushMatrix();
            this.rotateZ(spacing * i);
            this.translate(0.0f, vSpacing, 0.0f);
            this.scale(2.0f + 0.05f * kick);
            this.line(-lineLength / 2.0f, 0.0f, 0.0f, lineLength, 0.0f, 0.0f);
            this.popMatrix();
            i += (float)Math.PI * 2 / (float)lines;
        }
    }

    public void drawScene4() {
        this.randomSeed(1L);
        float kick = (float)this.moonlander.getValue("kick");
        float rotZ = (float)this.moonlander.getValue("rotZ") * ((float)Math.PI * 2);
        float pluck = (float)this.moonlander.getValue("pluck");
        float hue = (float)this.moonlander.getValue("lineSpacing") * 255.0f;
        boolean wireframe = this.getWireframe();
        this.stroke(0);
        this.translate(-800.0f, 0.0f, -100.0f);
        int triangleCount = 200;
        float size = (float)this.moonlander.getValue("spacing");
        this.colorMode(3);
        int i = 0;
        while (i < triangleCount) {
            this.pushMatrix();
            CartesianCoords xyz = new SphericalCoords(this.random((float)Math.PI * 2), this.random((float)Math.PI), this.random(size * 20.0f, size * 100.0f)).toCartesian();
            this.translate(xyz.x + size * 50.0f, xyz.y, xyz.z - 20.0f * size);
            float s = 2.0f + 0.1f * kick + this.random(0.5f);
            this.scale(s);
            this.rotateZ(rotZ + this.random((float)Math.PI * 2));
            this.rotateX(this.random((float)Math.PI * 2));
            this.scale(3.0f);
            int yellow = demo_idaen_hitain.floor((float)this.random(100.0f, 255.0f));
            if (!wireframe) {
                this.stroke(0);
                this.fill(hue, 255.0f - pluck * 40.0f, (float)yellow + pluck * 50.0f);
            } else {
                this.noFill();
                this.stroke(hue, 255.0f - pluck * 40.0f, (float)yellow + pluck * 50.0f);
            }
            float h = demo_idaen_hitain.sqrt((float)3.0f) * 5.0f;
            this.strokeWeight(1.0f / s);
            this.triangle(-5.0f, -h * 0.5f, 5.0f, -h * 0.5f, 0.0f, h * 0.5f);
            this.popMatrix();
            ++i;
        }
        this.colorMode(1);
    }

    public void drawScene5() {
        this.randomSeed(0L);
        float spacingctrl = (float)this.moonlander.getValue("lineSpacingV");
        float rotZ = (float)this.moonlander.getValue("rotZ");
        float kick = (float)this.moonlander.getValue("kick");
        int gridSize = 15;
        int cubeSize = 30;
        int spacing = 35;
        this.rotateX(1.5707964f);
        this.translate(0.0f, -200.0f, -300.0f);
        this.rotateZ(rotZ);
        this.scale(1.0f + 0.02f * kick);
        this.translate(-gridSize / 2 * spacing, -gridSize / 2 * spacing);
        this.stroke(0);
        this.strokeWeight(1.0f);
        boolean wireframe = this.getWireframe();
        this.colorMode(3);
        int x = 0;
        while (x < gridSize) {
            int y = 0;
            while (y < gridSize) {
                this.pushMatrix();
                int x_ = x - gridSize / 2;
                int y_ = y - gridSize / 2;
                float h = 200.0f * demo_idaen_hitain.exp((float)(-0.05f * (float)(x_ * x_ + y_ * y_))) * this.random(0.9f, 1.5f) * spacingctrl;
                this.translate(x * spacing, y * spacing, h);
                if (!wireframe) {
                    this.fill(160.0f + h, 255.0f, h * 0.8f + 100.0f);
                    this.stroke(0);
                } else {
                    this.noFill();
                    this.stroke(160.0f + h, 255.0f, h * 0.8f + 100.0f);
                }
                this.box(cubeSize);
                this.popMatrix();
                ++y;
            }
            ++x;
        }
        this.colorMode(1);
    }

    public void drawScene6() {
        this.randomSeed(0L);
        float spacingctrl = (float)this.moonlander.getValue("lineSpacingV");
        float rotZ = (float)this.moonlander.getValue("rotZ");
        this.moonlander.getValue("clock");
        int hueOffset = this.moonlander.getIntValue("linespacing");
        boolean wireframe = this.getWireframe();
        int gridSize = 15;
        int cubeSize = 30;
        int spacing = 35;
        this.rotateX(1.5707964f);
        this.translate(0.0f, -200.0f, -300.0f);
        this.rotateZ(rotZ);
        this.translate(-gridSize / 2 * spacing, -gridSize / 2 * spacing);
        this.stroke(0);
        this.strokeWeight(1.0f);
        this.colorMode(3);
        int x = 0;
        while (x < gridSize) {
            int y = 0;
            while (y < gridSize) {
                this.pushMatrix();
                int cfr_ignored_0 = gridSize / 2;
                int cfr_ignored_1 = gridSize / 2;
                float h = this.random(600.0f) * spacingctrl * (4.0f + 0.5f * demo_idaen_hitain.sin((float)((float)x + spacingctrl * 4.0f))) / 5.0f;
                this.translate(x * spacing, y * spacing, h);
                if (!wireframe) {
                    this.fill(60.0f + h * 0.5f + (float)hueOffset * 0.8f, 255.0f, h * 0.8f + 100.0f);
                    this.stroke(0);
                } else {
                    this.noFill();
                    this.stroke(60.0f + h * 0.5f + (float)hueOffset * 0.8f, 255.0f, h * 0.8f + 100.0f);
                }
                this.box(cubeSize);
                this.popMatrix();
                ++y;
            }
            ++x;
        }
        this.colorMode(1);
    }

    public void drawScene7() {
        this.randomSeed(1L);
        float kick = (float)this.moonlander.getValue("kick");
        float rotZ = (float)this.moonlander.getValue("rotZ") * ((float)Math.PI * 2);
        float pluck = (float)this.moonlander.getValue("pluck");
        int hueOffset = this.moonlander.getIntValue("lineSpacing");
        this.stroke(0);
        this.rotateZ(2.1991148f);
        this.translate(-800.0f, 0.0f, -100.0f);
        int triangleCount = 200;
        float size = (float)this.moonlander.getValue("spacing");
        boolean wireframe = this.getWireframe();
        this.colorMode(3);
        int i = 0;
        while (i < triangleCount) {
            this.pushMatrix();
            CartesianCoords xyz = new SphericalCoords(this.random((float)Math.PI * 2), this.random((float)Math.PI), this.random(size * 20.0f, size * 100.0f)).toCartesian();
            this.translate(xyz.x + size * 50.0f, xyz.y, xyz.z - 20.0f * size);
            float s = 1.0f + 0.1f * kick + this.random(0.5f);
            this.scale(s);
            this.rotateX(1.5707964f + this.random((float)Math.PI * 2));
            this.rotateY(rotZ + this.random((float)Math.PI * 2));
            this.scale(3.0f);
            if (!wireframe) {
                this.fill(this.random(50.0f) + (float)hueOffset, 255.0f, 220.0f + 30.0f * pluck);
                this.stroke(0);
            } else {
                this.noFill();
                this.stroke(this.random(50.0f) + (float)hueOffset, 255.0f, 220.0f + 30.0f * pluck);
            }
            float h = demo_idaen_hitain.sqrt((float)3.0f) * 5.0f;
            this.strokeWeight(1.0f / s);
            this.beginShape();
            this.vertex(-5.0f, -h / 2.0f, 0.0f);
            this.vertex(0.0f, 0.0f, 0.0f);
            this.vertex(5.0f, -h / 2.0f, 0.0f);
            this.vertex(0.0f, h / 2.0f, 0.0f);
            this.vertex(-5.0f, -h / 2.0f, 0.0f);
            this.endShape();
            this.popMatrix();
            ++i;
        }
        this.colorMode(1);
    }

    public void drawScene8() {
        float c = (float)this.moonlander.getValue("clock");
        float kick = (float)this.moonlander.getValue("kick");
        float pluck = (float)this.moonlander.getValue("pluck");
        boolean wireframe = this.moonlander.getIntValue("wireframe") % 2 == 0;
        this.fill(255);
        this.noStroke();
        int nCubes = 32;
        int ringRadius = 70;
        int boxSize = 20;
        this.rotateY(this.rotY);
        this.rotateZ((float)Math.PI * 2 * c / 4.0f / 4.0f / 4.0f);
        this.colorMode(3);
        float w = 0.1f;
        demo_idaen_hitain.sin((float)(c * w));
        this.pushMatrix();
        int nRings = 10;
        int j = -nRings / 2;
        while (j < nRings / 2) {
            this.pushMatrix();
            this.rotateZ((float)(-j) * ((float)Math.PI * 2) * 0.002f * c);
            float i = 0.0f;
            while (i < (float)Math.PI * 2) {
                this.pushMatrix();
                float r = (float)ringRadius * (3.0f + 0.2f * kick) * (2.0f + demo_idaen_hitain.sin((float)(c + (float)j)) * 0.05f) / 2.0f;
                SphericalCoords ptr = new SphericalCoords(j / 2, i, r);
                CartesianCoords xyz = ptr.toCartesian();
                this.translate(xyz.x, xyz.z, xyz.y);
                int h = (256 + (int)(-i / ((float)Math.PI * 2) * 255.0f + (float)demo_idaen_hitain.floor((float)(10.0f * (c + 1.0f) * (1.0f + pluck * 0.2f))))) % 256;
                if (wireframe) {
                    this.noStroke();
                    this.fill(h, 255.0f, 255.0f);
                } else {
                    this.noFill();
                    this.stroke(h, 255.0f, 255.0f);
                }
                this.rotateZ(-i);
                this.box(boxSize, boxSize, (float)boxSize * (4.0f + kick) * 0.4f);
                this.popMatrix();
                i += (float)Math.PI * 2 / (float)nCubes;
            }
            this.popMatrix();
            ++j;
        }
        this.popMatrix();
        this.colorMode(1);
    }

    public void drawScene9() {
        float kick = (float)this.moonlander.getValue("kick");
        float pluck = (float)this.moonlander.getValue("pluck");
        float c = (float)this.moonlander.getValue("clock");
        boolean wireframe = this.moonlander.getIntValue("wireframe") % 2 == 0;
        this.scale(1.7f + 0.05f * kick + 0.1f * pluck);
        this.pushMatrix();
        this.rotateY(this.rotY);
        this.rotateX(1.5707964f);
        this.noFill();
        this.stroke(255);
        this.strokeWeight(1.2f + pluck * 5.0f);
        this.ico1.create();
        this.popMatrix();
        this.rotateY(-this.rotY + (float)Math.PI);
        this.rotateX(1.5707964f * this.rotY);
        this.noFill();
        this.colorMode(3);
        int c_scale = 255 * (int)(c * 4.0f) % 256;
        if (wireframe) {
            this.stroke(c_scale, 2555.0f, 255.0f);
            this.noFill();
        } else {
            this.noStroke();
            this.fill(c_scale, 2555.0f, 255.0f);
        }
        this.colorMode(1);
        this.strokeWeight(1.2f + pluck * 5.0f);
        this.ico1.create();
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
        this.smooth(8);
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--present", "--window-color=#666666", "--stop-color=#cccccc", "demo_idaen_hitain"};
        if (passedArgs != null) {
            PApplet.main((String[])demo_idaen_hitain.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class CartesianCoords {
        float x;
        float y;
        float z;

        CartesianCoords(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public SphericalCoords toSpherical() {
            float r = demo_idaen_hitain.sqrt((float)(this.x * this.x + this.y * this.y + this.z * this.z));
            return new SphericalCoords(demo_idaen_hitain.atan((float)(this.y / this.x)), demo_idaen_hitain.acos((float)(this.z / r)), r);
        }
    }

    class Dimension3D {
        float w;
        float h;
        float d;

        Dimension3D(float w, float h, float d) {
            this.w = w;
            this.h = h;
            this.d = d;
        }
    }

    class Icosahedron
    extends Shape3D {
        PVector topPoint;
        PVector[] topPent;
        PVector bottomPoint;
        PVector[] bottomPent;
        float angle;
        float radius;
        float triDist;
        float triHt;
        float a;
        float b;
        float c;

        Icosahedron(float radius) {
            this.topPent = new PVector[5];
            this.bottomPent = new PVector[5];
            this.angle = 0.0f;
            this.radius = 150.0f;
            this.radius = radius;
            this.init();
        }

        Icosahedron(PVector v, float radius) {
            super(v);
            this.topPent = new PVector[5];
            this.bottomPent = new PVector[5];
            this.angle = 0.0f;
            this.radius = 150.0f;
            this.radius = radius;
            this.init();
        }

        @Override
        public void init() {
            this.c = demo_idaen_hitain.dist((float)(demo_idaen_hitain.cos((float)0.0f) * this.radius), (float)(demo_idaen_hitain.sin((float)0.0f) * this.radius), (float)(demo_idaen_hitain.cos((float)demo_idaen_hitain.radians((float)72.0f)) * this.radius), (float)(demo_idaen_hitain.sin((float)demo_idaen_hitain.radians((float)72.0f)) * this.radius));
            this.b = this.radius;
            this.a = (float)Math.sqrt(this.c * this.c - this.b * this.b);
            this.triHt = (float)Math.sqrt(this.c * this.c - this.c / 2.0f * (this.c / 2.0f));
            int i = 0;
            while (i < this.topPent.length) {
                this.topPent[i] = new PVector(demo_idaen_hitain.cos((float)this.angle) * this.radius, demo_idaen_hitain.sin((float)this.angle) * this.radius, this.triHt / 2.0f);
                this.angle += demo_idaen_hitain.radians((float)72.0f);
                ++i;
            }
            this.topPoint = new PVector(0.0f, 0.0f, this.triHt / 2.0f + this.a);
            this.angle = 36.0f;
            i = 0;
            while (i < this.topPent.length) {
                this.bottomPent[i] = new PVector(demo_idaen_hitain.cos((float)this.angle) * this.radius, demo_idaen_hitain.sin((float)this.angle) * this.radius, -this.triHt / 2.0f);
                this.angle += demo_idaen_hitain.radians((float)72.0f);
                ++i;
            }
            this.bottomPoint = new PVector(0.0f, 0.0f, -(this.triHt / 2.0f + this.a));
        }

        @Override
        public void create() {
            int i = 0;
            while (i < this.topPent.length) {
                demo_idaen_hitain.this.beginShape();
                if (i < this.topPent.length - 1) {
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPoint.x, this.y + this.topPoint.y, this.z + this.topPoint.z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i + 1].x, this.y + this.topPent[i + 1].y, this.z + this.topPent[i + 1].z);
                } else {
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPoint.x, this.y + this.topPoint.y, this.z + this.topPoint.z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[0].x, this.y + this.topPent[0].y, this.z + this.topPent[0].z);
                }
                demo_idaen_hitain.this.endShape(2);
                demo_idaen_hitain.this.beginShape();
                if (i < this.bottomPent.length - 1) {
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i].x, this.y + this.bottomPent[i].y, this.z + this.bottomPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPoint.x, this.y + this.bottomPoint.y, this.z + this.bottomPoint.z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i + 1].x, this.y + this.bottomPent[i + 1].y, this.z + this.bottomPent[i + 1].z);
                } else {
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i].x, this.y + this.bottomPent[i].y, this.z + this.bottomPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPoint.x, this.y + this.bottomPoint.y, this.z + this.bottomPoint.z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[0].x, this.y + this.bottomPent[0].y, this.z + this.bottomPent[0].z);
                }
                demo_idaen_hitain.this.endShape(2);
                ++i;
            }
            i = 0;
            while (i < this.topPent.length) {
                if (i < this.topPent.length - 2) {
                    demo_idaen_hitain.this.beginShape();
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i + 1].x, this.y + this.bottomPent[i + 1].y, this.z + this.bottomPent[i + 1].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i + 2].x, this.y + this.bottomPent[i + 2].y, this.z + this.bottomPent[i + 2].z);
                    demo_idaen_hitain.this.endShape(2);
                    demo_idaen_hitain.this.beginShape();
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i + 2].x, this.y + this.bottomPent[i + 2].y, this.z + this.bottomPent[i + 2].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i + 1].x, this.y + this.topPent[i + 1].y, this.z + this.topPent[i + 1].z);
                    demo_idaen_hitain.this.endShape(2);
                } else if (i == this.topPent.length - 2) {
                    demo_idaen_hitain.this.beginShape();
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[i + 1].x, this.y + this.bottomPent[i + 1].y, this.z + this.bottomPent[i + 1].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[0].x, this.y + this.bottomPent[0].y, this.z + this.bottomPent[0].z);
                    demo_idaen_hitain.this.endShape(2);
                    demo_idaen_hitain.this.beginShape();
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[0].x, this.y + this.bottomPent[0].y, this.z + this.bottomPent[0].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i + 1].x, this.y + this.topPent[i + 1].y, this.z + this.topPent[i + 1].z);
                    demo_idaen_hitain.this.endShape(2);
                } else if (i == this.topPent.length - 1) {
                    demo_idaen_hitain.this.beginShape();
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[0].x, this.y + this.bottomPent[0].y, this.z + this.bottomPent[0].z);
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[1].x, this.y + this.bottomPent[1].y, this.z + this.bottomPent[1].z);
                    demo_idaen_hitain.this.endShape(2);
                    demo_idaen_hitain.this.beginShape();
                    demo_idaen_hitain.this.vertex(this.x + this.bottomPent[1].x, this.y + this.bottomPent[1].y, this.z + this.bottomPent[1].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[i].x, this.y + this.topPent[i].y, this.z + this.topPent[i].z);
                    demo_idaen_hitain.this.vertex(this.x + this.topPent[0].x, this.y + this.topPent[0].y, this.z + this.topPent[0].z);
                    demo_idaen_hitain.this.endShape(2);
                }
                ++i;
            }
        }

        @Override
        public void rotZ(float theta) {
            float tx = 0.0f;
            float ty = 0.0f;
            tx = demo_idaen_hitain.cos((float)theta) * this.topPoint.x + demo_idaen_hitain.sin((float)theta) * this.topPoint.y;
            ty = demo_idaen_hitain.sin((float)theta) * this.topPoint.x - demo_idaen_hitain.cos((float)theta) * this.topPoint.y;
            this.topPoint.x = tx;
            this.topPoint.y = ty;
            tx = demo_idaen_hitain.cos((float)theta) * this.bottomPoint.x + demo_idaen_hitain.sin((float)theta) * this.bottomPoint.y;
            ty = demo_idaen_hitain.sin((float)theta) * this.bottomPoint.x - demo_idaen_hitain.cos((float)theta) * this.bottomPoint.y;
            this.bottomPoint.x = tx;
            this.bottomPoint.y = ty;
            int i = 0;
            while (i < this.topPent.length) {
                tx = demo_idaen_hitain.cos((float)theta) * this.topPent[i].x + demo_idaen_hitain.sin((float)theta) * this.topPent[i].y;
                ty = demo_idaen_hitain.sin((float)theta) * this.topPent[i].x - demo_idaen_hitain.cos((float)theta) * this.topPent[i].y;
                this.topPent[i].x = tx;
                this.topPent[i].y = ty;
                tx = demo_idaen_hitain.cos((float)theta) * this.bottomPent[i].x + demo_idaen_hitain.sin((float)theta) * this.bottomPent[i].y;
                ty = demo_idaen_hitain.sin((float)theta) * this.bottomPent[i].x - demo_idaen_hitain.cos((float)theta) * this.bottomPent[i].y;
                this.bottomPent[i].x = tx;
                this.bottomPent[i].y = ty;
                ++i;
            }
        }

        @Override
        public void rotX(float theta) {
        }

        @Override
        public void rotY(float theta) {
        }
    }

    abstract class Shape3D {
        float x;
        float y;
        float z;
        float w;
        float h;
        float d;

        Shape3D() {
        }

        Shape3D(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        Shape3D(PVector p) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }

        Shape3D(Dimension3D dim) {
            this.w = dim.w;
            this.h = dim.h;
            this.d = dim.d;
        }

        Shape3D(float x, float y, float z, float w, float h, float d) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = w;
            this.h = h;
            this.d = d;
        }

        Shape3D(float x, float y, float z, Dimension3D dim) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.w = dim.w;
            this.h = dim.h;
            this.d = dim.d;
        }

        Shape3D(PVector p, Dimension3D dim) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
            this.w = dim.w;
            this.h = dim.h;
            this.d = dim.d;
        }

        public void setLoc(PVector p) {
            this.x = p.x;
            this.y = p.y;
            this.z = p.z;
        }

        public void setLoc(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void rotX(float theta) {
        }

        public void rotY(float theta) {
        }

        public void rotZ(float theta) {
        }

        public abstract void init();

        public abstract void create();
    }

    class SphericalCoords {
        float p;
        float t;
        float r;

        SphericalCoords(float p, float t, float r) {
            this.p = p;
            this.t = t;
            this.r = r;
        }

        public CartesianCoords toCartesian() {
            return new CartesianCoords(this.r * demo_idaen_hitain.sin((float)this.t) * demo_idaen_hitain.cos((float)this.p), this.r * demo_idaen_hitain.sin((float)this.t) * demo_idaen_hitain.sin((float)this.p), this.r * demo_idaen_hitain.cos((float)this.t));
        }
    }
}

