import moonlander.library.*;
//PShader shader;

import ddf.minim.*;

Moonlander moonlander;
int frame;
int row;
float aspectRatio;

ArrayList<KochLine> lines; 


void setup()
{
  size(1920, 1080, P3D);
  aspectRatio = width/height*1.0;
 // shader = loadShader("shaderi.glsl");
  moonlander = Moonlander.initWithSoundtrack(this, "Furious Freak.mp3", 120, 4);
  moonlander.start();
  //shader.set("resolution", float(width), float(height));
  frame = 0; 
  row = 0;
}

void draw()
{
  moonlander.update();
  row = (int)moonlander.getCurrentRow();
  int bgColor = moonlander.getIntValue("bgColor");
  int iters = moonlander.getIntValue("iters");
  float rotateX = (float)moonlander.getIntValue("rotX");
  float rotateY = (float)moonlander.getIntValue("rotY");
  float rotateZ = (float)moonlander.getIntValue("rotZ");
  float transX = (float)moonlander.getValue("transX");
  float transY = (float)moonlander.getValue("transY");
  float transZ = (float)moonlander.getValue("transZ");
  float scale = (float)moonlander.getValue("scale");
  
  if (row <= 0x166)
  {
    background(bgColor);
    

    lights();
    camera(0.0, 0.0, 300.0, 0.0, 0.0, 0.0,
       0.0, 1.0, 0.0);
    pushMatrix();
 
 // shader.set("frame", float(frame));
  //shader.set("time", millis()/1000.0);
 // shader(shader);
    translate((transX), (transY), (transZ));
    rotateX(radians(rotateX));
    rotateY(radians(rotateY));
    rotateZ(radians(rotateZ));
    drawSphere(0.0, 0.0, 0.0, 15.0, 1000);
    frame++;
    popMatrix();
  }
  else if(row == 0x3c0)
  {
    exit();
  }
  else
  {
    background(bgColor);
    camera(0.0, 0.0, 300.0, 0.0, 0.0, 0.0,
       0.0, 1.0, 0.0);
    //frustum(-10, 0, 0, 10, 5, 500);
    pushMatrix();
    translate(transX, transY, transZ);
    rotateX(radians(rotateX));
    rotateY(radians(rotateY));
    rotateZ(radians(rotateZ));
    scale(scale);
    //fill(255);
    drawFlake(200, iters, 255, 255, 255);
    popMatrix();
  }
  
 
}

void drawSphere(float x, float y, float z, float radius, int frame)
{
  fill(100, 30, 10);
  noStroke();
  pushMatrix();
  translate(x, y, z);
  sphere(radius);
  if (radius > 2.0 && frame > 0)
  {
    drawSphere(radius, 0, 0, radius/2, frame - 1);
    drawSphere(-radius, 0, 0, radius/2, frame - 1);
    drawSphere(0, radius, 0, radius/2, frame - 1);
    drawSphere(0, -radius, 0, radius/2, frame - 1);
    drawSphere(0, 0, radius, radius/2, frame - 1);
    drawSphere(0, 0, -radius, radius/2, frame - 1);
  }
  popMatrix();
}


void generate(int red, int green, int blue) 
{
//Create the next ArrayList...
    ArrayList next = new ArrayList<KochLine>();
 
//...for every current line.
    for (KochLine l : lines) 
    {
      PVector a = l.kochA(); 
      PVector b = l.kochB();
      PVector c = l.kochC();
      PVector d = l.kochD();
      PVector e = l.kochE();
      
//Add four new lines. (We need to figure out how to compute the locations of these lines!)
      next.add(new KochLine(a, b, red, green, blue));
      next.add(new KochLine(b, c, red, green, blue));
      next.add(new KochLine(c, d, red, green, blue));
      next.add(new KochLine(d, e, red, green, blue));
    }
//The new ArrayList is now the one we care about!
    lines = next;
}
   
 void drawFlake(int size, int iters, int red, int green, int blue)
 {
    pushMatrix();
    lines = new ArrayList<KochLine>();
    translate(-size/2, -size/2);
    PVector start1 = new PVector(0, 0);
    PVector end1   = new PVector(size-1, 0);
 
    lines.add(new KochLine(start1, end1,  red,  green,  blue));
  
    PVector start2 = new PVector(size-1, 0);
    PVector end2   = new PVector((size-1) / 2, size/2 / tan(radians(30)));
 
    lines.add(new KochLine(start2, end2,  red,  green,  blue));
  
    PVector start3 = new PVector((size-1) / 2, size/2 / tan(radians(30)));
    PVector end3   = new PVector(0, 0);
   
    lines.add(new KochLine(start3, end3,  red,  green,  blue));
  
    for(int i = 0; i<iters; i++)
    {
      generate(red, green, blue);
    }
    
    for(KochLine l: lines)
    {
      l.display();
    }
    popMatrix();
 }