import moonlander.library.*;

// Minim must be imported when using Moonlander with soundtrack.
import ddf.minim.*;

Animation animation1;
Moonlander moonlander;

float xpos;
float ypos;
float drag = 30.0;

float bannerX;
float bannerY;

String s = "RUN OF A LIFETIME.";
PImage grass;
PImage village;

PImage citySmall;
PImage citySz1;
PImage citySz2;
PImage citySz3;
PImage citySz4;
int citySmallWidth;
int citySmallHeight;

PImage cloud1;
PImage cloud2;
PImage cloud3;
Animation heroFalls;

ArrayList<PImage> buildings;
int numBDGS = 20;
ArrayList<Building> showBdgs = new ArrayList<Building>();

PImage heroFalling;

float base;

float a=5;
float b=10;
float c=9;
int dim = 60;
boolean showFalling = true;
boolean sc6gb0 = false;

void setup() {
  size(640, 360,P2D);
  // rectMode(CENTER);
  background(255);
  frameRate(24);
  animation1 = new Animation("hero/hero-", 8);
  ypos = 23 + height * 0.5;
  moonlander = Moonlander.initWithSoundtrack(this, "./sounds/1.mp3", 127, 4);
  // moonlander = new Moonlander(this, new TimeController(4));
  moonlander.start();
  strokeWeight(4);
  stroke(255);
  line(-10,200,600,200);
  strokeWeight(1);
  // font needs to load before animation can proceed. 
  // Otherwise animation pauses while font loads
  textFont(createFont("Mustachio", 20));
  
  bannerX = -150+width/2;
  bannerY = -40+height/2;
  
  grass = loadImage("blackgrass-hi.png");
  grass.resize(width+50, 20);
  village = loadImage("village.png");
  village.resize(width, height);
  // animbirdgroupSc1 = new Animation("bird/birdgroup-",9);
  heroFalls = new Animation("heroFalls/heroFalls-",18);
  
  
  cloud1 = loadImage("cloud_1.png");
  cloud2 = loadImage("cloud_2.png");
  cloud3 = loadImage("cloud_3.png");
  
  citySmall = loadImage("citySc2.png");
  citySmallWidth = citySmall.width;
  citySmallHeight = citySmall.height;
  
  buildings = new ArrayList<PImage>();
  buildings.add(loadImage("buildings/b1.png"));
  buildings.add(loadImage("buildings/b2.png"));
  buildings.add(loadImage("buildings/b3.png"));
  buildings.add(loadImage("buildings/b4.png"));
  buildings.add(loadImage("buildings/b5.png"));
  buildings.add(loadImage("buildings/b6.png"));
  
  for(int i=0; i<numBDGS; i++){
    showBdgs.add(new Building());
  }
  
  heroFalling = loadImage("heroFalling.png");
}


void draw() { 
  int baseOffset = (int) moonlander.getValue("baseOffset");
  base = ypos+baseOffset;
  moonlander.update();
  // float dx = mouseX - xpos;
  // xpos = xpos + dx/drag;
  
  // -----------------------------
  // INTRO
  // -----------------------------
  double hero_x = moonlander.getValue("hero_x");
  // Display the sprite at the position xpos, ypos
  
  background(255);
  
  // animation1.display(xpos-animation1.getWidth()/2, ypos);
  // print(animation1.getWidth()/2); 125
  
  if(moonlander.getValue("sc") == 3){
     strokeWeight(1);
     fill(0,255);
    if(moonlander.getValue("clouds") == 1){
       for(int x=0; x < width; x+=5){
         for(int y=0; y < 400; y+=5){
          // distance from sun 20, base 
         float maxDist = 100;
         float d = dist(x, 0, x, y);
         float gray = map(d, 0, maxDist, 0, 255);
         fill(random(0,2) < 0.1 ? gray : 255);
         ellipse(x,y,10,10);
        }
      }
    }
  }
  
  animation1.display((float) hero_x, ypos);
  
  strokeWeight(4);
  stroke(0);
  line(0,base,700,base);
  //strokeWeight(1);
  double BannerfadeIn = moonlander.getValue("fadeIn");
  double villFade = moonlander.getValue("sc1-villageFade");
  double villPos = moonlander.getValue("sc1-villagePosition");
  if(moonlander.getValue("sc") == 0)
  {
    textSize(32);
    fill((int) BannerfadeIn);
    text(s, bannerX, bannerY);
    stroke((int) BannerfadeIn);
    line(bannerX,bannerY-textAscent(),bannerX+textWidth(s),bannerY-textAscent());
    line(bannerX,bannerY+10,bannerX+textWidth(s),bannerY+10);
    stroke(0);
    double grassPos = moonlander.getValue("grassPosition");
    image(grass, (float) grassPos,base-grass.height+1);
    // -----------------------------
    // SCENE 1 - Village
    // -----------------------------
    
    
    // ---------- BIRD ----------
    // double birdGroupPos = moonlander.getValue("sc1-birdGrpPos");
    // animbirdgroupSc1.display((float) birdGroupPos, 100);
    if(moonlander.getValue("sc1") > 0){
      tint(255, (float) villFade);
      image(village, (float)villPos, base-village.height);
      tint(255, (float) 255);
    }
  }
  // -----------------------------
  // SCENE 2 - Towards City
  // -----------------------------
  // double cloud1Pos = moonlander.getValue("sc2-cloud1Position");
  // double cloud2Pos = moonlander.getValue("sc2-cloud2Position");
  // double cloud3Pos = moonlander.getValue("sc2-cloud3Position");
  
  // DRAW ROAD
  if(moonlander.getValue("sc2") > 0){
    quad(-10 + width/2, base, 10 + width/2, base, 100 + width/2, base+height/2, -100 + width/2, base+height/2);
    double sc2roadMove = moonlander.getValue("sc2-roadMove");
    int dividerSize = 50;
    
    // print(eyeZ);
    // citySmall.resize((int)(citySmallWidth * eyeZ), (int)(citySmallHeight * eyeZ)); //<>//
    if( sc2roadMove > 0){
      line(width/2, base, width/2, dividerSize + base);
      line(width/2, 10+dividerSize + base, width/2, dividerSize*2 + base);
      line(width/2, 10+dividerSize*2 + base, width/2, dividerSize*3 + base);
    } else {
      line(width/2, dividerSize + base, width/2,  2*dividerSize + base);
      line(width/2, 10 + 2*dividerSize + dividerSize + base, width/2, 3*dividerSize + base);
    }
    float eyeZ = (float) moonlander.getValue("sc2-eyeZ");
    float sunSize = (float) moonlander.getValue("sc2-sunSize");
    float sunSetVals = (float) moonlander.getValue("sc2-sunSetVals");
    // SUN RAYS
    strokeWeight(1);
    for(int x=0; x < width; x+=5){
      for(int y=0; y < base-5; y+=5){
        // distance from sun 20, base 
       float maxDist = dist(20, base, width, 0);
       float d = dist(20-sunSetVals, base+sunSetVals, x, y);
       float gray = map(d, 0, maxDist, 255, 0);
       fill(random(0,2) < 0.05+(sunSetVals*0.00008) ? 255 : gray);
       ellipse(x,y,10,10);
      }
    }
    // SUN
    fill(255);
    arc(20,base, 200*eyeZ,sunSize,PI,2*PI);
    fill(0);

    // SMALL CITY
    // println(eyeZ);
    // pushMatrix();
   
    int xOffset = width/2;
    int yOffset = (int) base;
    image(citySmall,70+xOffset-(citySmallWidth)*eyeZ,2+yOffset-citySmallHeight*eyeZ,citySmallWidth*eyeZ,citySmallHeight*eyeZ);
    if(moonlander.getValue("sc2") == 2){
      // println(villFade);
      fill(255,(float) villFade);
      rect(-10,-10,width+10,height+10);
    }
  }
  // -----------------------------
  // SCENE 3 - City
  // -----------------------------
  if(moonlander.getValue("sc") == 3){
    // strokeWeight(1);
    // fill(0,255);
    //if(moonlander.getValue("clouds") == 1){
    //   for(int x=0; x < width; x+=5){
    //     for(int y=0; y < 400; y+=5){
    //      // distance from sun 20, base 
    //     float maxDist = 100;
    //     float d = dist(x, 0, x, y);
    //     float gray = map(d, 0, maxDist, 0, 255);
    //     fill(random(0,2) < 0.1 ? gray : 255);
    //     ellipse(x,y,10,10);
    //    }
    //  }
    //}
    // image(buildings.get(3),200.0,0);
    float startx = (float) moonlander.getValue("sc3-bgds-x");
    for(int i = 0; i < numBDGS ; i ++){
      showBdgs.get(i).draw(startx, 0);//base);
      startx += showBdgs.get(i).bwidth; 
    }
    
  }
  // -----------------------------
  // SCENE 4 - Fall
  // -----------------------------
  if(moonlander.getValue("sc") == 4){
    strokeWeight(1);
    fill(0,255);
    if(moonlander.getValue("clouds") == 1){
       for(int x=0; x < width; x+=5){
         for(int y=0; y < 400; y+=5){
          // distance from sun 20, base 
         float maxDist = 100;
         float d = dist(x, 0, x, y);
         float gray = map(d, 0, maxDist, 0, 255);
         fill(random(0,2) < 0.1 ? gray : 255);
         ellipse(x,y,10,10);
        }
      }
    }
    // image(buildings.get(3),200.0,0);
    
    
    heroFalls.display(0,base-300);
  }
  // -----------------------------
  // SCENE 4 - Hero Falling
  // -----------------------------
  if(moonlander.getValue("sc") == 5){
    strokeWeight(1);
    fill(0,(float)moonlander.getValue("heroFallingHt")+60.0);
    image(heroFalling, width/2, (float) moonlander.getValue("heroFallingHt"), 100 - (float) moonlander.getValue("heroFallingHt"), 100);
  }
  // -----------------------------
  // SCENE 5 - Cosmic
  // -----------------------------
  if(moonlander.getValue("sc") == 6){
   
    frameRate(60);
    if(sc6gb0){
      background(0);
      sc6gb0 = false;
    }
    if(c > 70)
      showFalling = false;
    if(showFalling){
      // while(showFalling){
        stroke(99+c,b,b);
        fill(10,5,9);
        ellipse(b,b,c,c);
        filter(BLUR,0.9);
        a+=0.3;
        b+=0.8;
        c+=0.3;
        //if(c > 70){
        //  showFalling = false;
        //}
      // }
    }
    else{
      cosmicCloud();
    }
  }
  // -----------------------------
  // SCENE 5 - Cosmic
  // -----------------------------
  if(moonlander.getValue("sc") == 7){
  }
  
}


//void setup(){
//  size(600,600);
//  background(0);
//  noStroke();
//  frameRate(60);
//}
//void draw(){
  
//  }
  
  void cosmicCloud(){
    for (int x = 0; x <= width; x+=dim) {
    for(int y = 0; y <= height; y+=dim){ 
      float ms = millis();
      fill (random(255)*noise(ms/1000)
         ,random(255)*noise(ms/200)
         ,30*noise(ms/300));

    float r=random(dim/2);    
    ellipse(random(width), random(height), r, r);
    }
  }
  filter (ERODE);
  filter (BLUR,1);
 // if ((frameCount % 2) == 0)
  filter (DILATE);
  filter (DILATE);
}