import moonlander.library.*;
import ddf.minim.*;
import java.util.Map;

int CANVAS_WIDTH = 1920;
int CANVAS_HEIGHT = 1080;
int CENTER_X = CANVAS_WIDTH / 2;
int CENTER_Y = CANVAS_HEIGHT / 2;
float MAX_LENGTH = sqrt(pow(CANVAS_WIDTH, 2) + pow(CANVAS_HEIGHT, 2));
float ASPECT_RATIO = (float) CANVAS_WIDTH / CANVAS_HEIGHT;
boolean FULLSCREEN = true;


HashMap<Integer, Integer> color_picker = new HashMap<Integer, Integer>();

Moonlander moon;

void draw_rects(int bass, double[] cues) {
  float box_width = CANVAS_WIDTH / 6.0;
  float box_height = CANVAS_HEIGHT / 2.0;
  float x_pos = box_width;
  background(color_picker.get(bass));
  for (double c : cues) {
    fill(color(100,23,23, (int) c));
    rect(x_pos, box_height/2, box_width, box_height);
    x_pos += box_width;
  }
}

ArrayList<Float> sizes = new ArrayList<Float>();
ArrayList<Integer> instruments = new ArrayList<Integer>();
float growth_rate = 1.0;

void draw_circles(double time, int beat, int instrument, int bass, double[] cues, boolean end) {
  background(255);
  
  //If it's time to add a new instrument
  if (instrument != 0) {
     sizes.add(0.0);
     instruments.add(instrument - 1);
  }
  
  //If the size of the circle is too large
  if (sizes.size() > 0 && sizes.get(0) > MAX_LENGTH) {
    sizes.remove(0);
    instruments.remove(0);
  }

  for (int i = 0; i < sizes.size(); i++) {
    float r = sizes.get(i);
    instrument = instruments.get(i);
    int alpha = 255;
    int colour = color(0,0,0);
    if (instrument == 4) {
       colour = color_picker.get(bass + 1);
    }
    else {
      alpha = (int) cues[instrument];
    }
    fill(colour, alpha);
    ellipse(CENTER_X, CENTER_Y, r, r);
    sizes.set(i, r + growth_rate);
  }
  if (end) {
    int colour = color(0,0,0);
    fill(colour, (float) time);
    rect(0,0,CANVAS_WIDTH, CANVAS_HEIGHT);
  }
}

void draw_demo(double time, int beat, int instrument, int bass, double[] cues, boolean end) {
  draw_circles(time, beat, instrument, bass, cues, end);
}

public enum Section {
  INTRO, VERSE1, CHORUS1, VERSE2, CHORUS2, OUTRO1, OUTRO2
}

void settings() {
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P2D); 
  if (FULLSCREEN) {
     fullScreen(); 
  }
}

void setup() {
  moon = Moonlander.initWithSoundtrack(this, "BouncyPS.wav", 87, 8);
  color_picker.put(0, color(0,0,0));
  color_picker.put(1, color(255,0,0));
  color_picker.put(2, color(0,255,0));
  color_picker.put(3, color(0,0,255));
  color_picker.put(4, color(255,255,0));
  color_picker.put(5, color(255,0,255));
  color_picker.put(6, color(0,255,255));
  color_picker.put(7, color(255,255,255));
  
  frameRate(60);
  background(255);
  noStroke();
  fill(255);
  //smooth();
  moon.start();
}

Section getSection(int section) {
  return Section.values()[section]; 
}

void draw() {
  moon.update();
  
  int section = (int) moon.getValue("Section");
  double time = moon.getValue("Time");
  int beat = (int) moon.getValue("Beat");
  int instrument = (int) moon.getValue("Instrument");
  int bass = (int) moon.getValue("BassCues");
  double noise = moon.getValue("NoiseCues");
  double bass_drum = moon.getValue("BassDrumCues");
  double clave = moon.getValue("ClaveCues");
  double gamelan = moon.getValue("GamelanCues"); 
  
  double[] cues = {bass_drum, clave, gamelan, noise};
  
  clear();
  
  switch (getSection(section)) {
    case INTRO:
    case VERSE1:
    case CHORUS1: 
    case VERSE2: 
    case CHORUS2:
      draw_demo(time, beat, instrument, bass, cues, false);
      break;
    case OUTRO1:
    case OUTRO2:
      draw_demo(time, beat, instrument, bass, cues, true);
      break;
  }
}