//The texture loader
function TextureLoader(){

    //List of textures to be loaded
    var toBeLoaded = [
        {
            name : "kootti",
            path: "bin/kuvat/mopeygoth_12.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "kootti2",
            path: "bin/kuvat/mopeygoth_eyes_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "tiara",
            path: "bin/kuvat/tiara_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "kissa_transparent",
            path: "bin/kuvat/kisse_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "diskokootti",
            path: "bin/kuvat/diskokootti.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "diskokootti2",
            path: "bin/kuvat/diskokootti2.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "sydan",
            path: "bin/kuvat/pinkkisydan.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "paraguay",
            path: "bin/kuvat/powerguay_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "jumalauta",
            path: "bin/kuvat/powerlauta_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.ClampToEdgeWrapping,
            wrapT : THREE.ClampToEdgeWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        },

        {
            name : "hearts_filled",
            path: "bin/kuvat/hearts2_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.RepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [8, 8],
            offset : [0, 0]
        },

        {
            name : "kisse",
            path: "bin/kuvat/kisse_1.png",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [8, 8],
            offset : [0, 0]
        },

        {
            name : "valot",
            path: "bin/kuvat/valot6.jpg",//url or the variable name if base64 string
            loaded : false,
            mapping : THREE.UVMapping,
            wrapS : THREE.MirroredRepeatWrapping,
            wrapT : THREE.RepeatWrapping,
            magFilter : THREE.LinearFilter,
            minFilter : THREE.LinearMipMapLinearFilter,
            format : THREE.RGBAFormat,
            flipY : true,
            repeat : [1, 1],
            offset : [0, 0]
        }
    ];

    var textures = {};
    var loader = new THREE.TextureLoader();

    var loadReady = function(callback){
        for(var i = 0; i < toBeLoaded.length; ++i){
            if(!toBeLoaded[i].loaded){
                return false;
            }
        }
        callback(textures);
    };

    var textureOnLoad = function(index, one, callback){
        var info = toBeLoaded[index];
        if(info.loaded){
            if(one){
                callback(textures[info.name.toString()]);
            }
            else{
                loadReady(callback);
            }
        }
        else{
            loader.load(info.path,
            function(texture){
                texture.mapping = info.mapping;
                texture.wrapS = info.wrapS;
                texture.wrapT = info.wrapT;
                texture.magFilter = info.magFilter;
                texture.minFilter = info.minFilter;
                texture.format = info.format;
                texture.flipY = info.flipY;

                texture.repeat.set(info.repeat[0], info.repeat[1]);
                texture.offset.set(info.offset[0], info.offset[1]);


                textures[info.name.toString()] = texture;
                info.loaded = true;

                if(one){
                    callback(texture);
                }
                else{
                    loadReady(callback);
                }
            },
            function(xhr){
                console.log( (xhr.loaded / xhr.total * 100) + "% loaded");
            },
            function ( xhr ) {
                console.log("An error happened when loading texture: ", info.name);
                //Should we just stop or continue or what to do?
            });
        }
    };

    var customLoad = function(path, callback){
        loader.load(path,
        function(texture){
            callback(texture);
        },
        function(xhr){
            console.log( (xhr.loaded / xhr.total * 100) + "% loaded");
        },
        function(xhr){
            console.log("An error happened when loading texture: ", path);
            callback(false);
        });
    };

    var t = {
        loader : loader,

        //Loads all textures in the list and then calls the function given as parameter
        loadAll : function(cb){
            if(toBeLoaded.length < 1){
                loadReady(cb);
            }
            else{
                for(var i = 0; i < toBeLoaded.length; ++i){
                    textureOnLoad(i, false, cb);
                }
            }

        },

        //Loads one texture and then calls the function given as parameter
        loadOne : function(index, cb){
            textureOnLoad(index, true, cb);
        },

        loadOther : function(path, cb){
            customLoad(path, cb);
        },

        getTextures : function(){
            return textures;
        }
    }

    return t;
};
TDEMO.TEXTURES = TextureLoader();
