class Config:

    WINDOWWIDTH = 640
    WINDOWHEIGHT = 480

    INTRO_LETTER_S = [[1,2],[0,1.5],[0,1],[1,0.5],[1,0],[0,0]]
    INTRO_LETTER_t = [[0,2],[0,1.5],[0.5,1.5],[0,1.5],[0,0]] #2
    INTRO_LETTER_e = [[1,0],[0,0],[0,1],[1,1],[1,1.5],[0,1.5],[0,1]] #3
    INTRO_LETTER_r = [[0.5,1.5],[0,1],[0,0]] #4.5
    INTRO_LETTER_o = [[0,0],[1,0],[1,1.5],[0,1.5]] #5.5
    INTRO_LETTER_i = [[0,0],[0,1.5]] #7
    INTRO_LETTER_D = [[0,2],[1,1],[1,0.5],[0,0]] #7.5
    INTRO_LETTER_SCALE = 40

    SHIPSIZE = 20
    SHIPSTART = [0.7,0.85]
    SHIPPOINTS = [[0,-1],[-0.5,0.5],[0.5,0.5]]
    SHIPBOOSTPOINTS = [[0,1.25],[-0.25,0.75],[0.25,0.75]]
    SHIPBOOSTFORCE = 400
    SHIPROTATIONSPEED = 8
    SENSORRANGE = WINDOWHEIGHT*6

    FUEL_HEIGHT = 16
    FUEL_WIDTH = 128
    FUEL_X = WINDOWWIDTH - FUEL_WIDTH - 4
    FUEL_Y = 128 - FUEL_HEIGHT

    FUELMAX = 20
    FUELBOOSTCONSUMPTION = 2.5
    FUELTIMESLOWCONSUMPTION = 1.0
    FUELCOLLISIONCONSUMPTION = 0.1
    FUELTIMEOVERCONSUMPTION = 4.0

    TIMESLOWMULTIPLIER = 0.25

    PLANETSHAPE1 = [[0,0.05],[0.2,0.05],[0.3,0.1],[0.4,0.05],[0.55,0.15],[0.65,0.1],[0.75,0.1],[0.8,0.2],[0.85,0.2],[1,0.05]]
    PLANETSHAPE2 = [[0,0.15],[0.1,0.2],[0.3,0.25],[0.4,0.15],[0.55,0.25],[0.6,0.125]]

    ASTEROIDMINRADIUS = 5
    ASTEROIDMAXRADIUS = 30
    ASTEROIDMINPOINTS = 5
    ASTEROIDMAXPOINTS = 8
    ASTEROIDMINPOINTDISTANCE = 0.7
    ASTEROIDMAXPOINTDISTANCE = 1.3
    ASTEROIDMINSPAWN = -WINDOWHEIGHT*20
    ASTEROIDMAXSPAWN = -WINDOWHEIGHT*2
    ASTEROIDLIMIT = WINDOWHEIGHT*2

    ASTEROIDCOUNT = 30

    STARMINRADIUS = 1
    STARMAXRADIUS = 4

    STARCOUNT = 10

    OFFSETLIMIT = WINDOWHEIGHT*0.75

    BLACK     = (0  ,0  ,0  )
    DARKBLUE  = (0  ,0  ,50 )
    WHITE     = (255,255,255)
    GREEN     = (0  ,255,0  )
    GREY      = (120,120,120)
    RED       = (255,0,0)
    YELLOW    = (255,255,0)