import pygame, sys, math
from pygame.locals import *
from config import Config

class Entity:

    Offset = 0
    Shake = [0,0]

    def __init__(self, _position, _radius, _points):
        self.Position = _position
        self.Radius = _radius
        self.Points = _points
        self.Velocity = [0,0]
        self.Rotation = 0
        self.Scale = 1
        self.LineClosed = True

    def UpdateXLimit(self):
        if self.Position[0] > Config.WINDOWWIDTH+self.Radius:
            self.Position[0] = -self.Radius
        elif self.Position[0] < -self.Radius:
            self.Position[0] = Config.WINDOWWIDTH+self.Radius

    def UpdateYLimit(self):
        if self.Position[1] > Config.WINDOWHEIGHT+self.Radius:
            self.Position[1] = -self.Radius
        elif self.Position[1] < -self.Radius:
            self.Position[1] = Config.WINDOWHEIGHT+self.Radius

    def TransformPoints(self, _points):
        transformedPoints = []
        for point in _points:
            newPoint = [
                point[0] * math.cos(self.Rotation) - point[1] * math.sin(self.Rotation),
                point[1] * math.cos(self.Rotation) + point[0] * math.sin(self.Rotation)]

            newPoint[0] *= self.Scale
            newPoint[1] *= self.Scale

            newPoint[0] += self.Position[0] + Entity.Shake[0]
            newPoint[1] += self.Position[1] - Entity.Offset + Entity.Shake[1]

            transformedPoints.append(newPoint)
        return transformedPoints

    def Update(self, _fTime):

        self.Position[0] += self.Velocity[0]*_fTime
        self.Position[1] += self.Velocity[1]*_fTime

    def Draw(self, _screen):
        realYPosition = self.Position[1] - Entity.Offset
        if realYPosition < -self.Radius:
            return

        if realYPosition > self.Radius + Config.WINDOWHEIGHT:
            return

        transformedPoints = self.TransformPoints(self.Points)

        pygame.draw.lines(_screen, Config.WHITE, self.LineClosed, transformedPoints, 5)
        #pygame.draw.circle(_screen, Config.GREEN, [int(self.Position[0]),int(realYPosition)], int(self.Radius), 5)