import pygame, sys, math, vector
from pygame.locals import *
import math
from entity import Entity
from config import Config

class Planet:

    def __init__(self, _pointsFront, _pointsBack, _position, _modifier):
        self.PointsFront = []
        for point in _pointsFront:
            newPoint = [
                point[0] * Config.WINDOWWIDTH,
                point[1] * Config.WINDOWHEIGHT * _modifier]
            self.PointsFront.append(newPoint)

        self.PointsBack = []
        for point in _pointsBack:
            newPoint =[
                point[0] * Config.WINDOWWIDTH,
                point[1] * Config.WINDOWHEIGHT * _modifier]
            self.PointsBack.append(newPoint)

        self.Position = _position

    def DrawFront(self, _screen):

        pygame.draw.circle(_screen, Config.YELLOW, [
            20,
            int(self.Position - Entity.Offset*0.5 - 200)], 80)

        transformedPointsBack = []
        for point in self.PointsBack:
            transformedPointsBack.append([
                point[0],
                point[1] + self.Position - Entity.Offset])
        pygame.draw.lines(_screen, Config.GREY, False, transformedPointsBack, 5)

    def DrawBack(self, _screen):

        transformedPointsFront = []
        for point in self.PointsFront:
            transformedPointsFront.append([
                point[0],
                point[1] + self.Position - Entity.Offset])
        pygame.draw.lines(_screen, Config.WHITE, False, transformedPointsFront, 5)
