Game.Glyph = function(properties) {
    properties = properties || {};
    this._char = properties['character'] || ' ';
    this._foreground = properties['foreground'] || 'white';
    this._background = properties['background'] || 'black';
	this._colourVariance = properties['colourVariance'] || [10,10,10];
    this._vertical = properties['vertical'] || 0;
};

// Create standard getters for glyphs
Game.Glyph.prototype.getChar = function(){ 
    return this._char; 
};
Game.Glyph.prototype.getBackground = function(){
    return this._background;
};
Game.Glyph.prototype.getForeground = function(){ 
    return this._foreground; 
};
Game.Glyph.prototype.getColourVariance = function(){ 
    return this._colourVariance; 
};
Game.Glyph.prototype.getVertical = function() {
    return this._vertical;
};
Game.Glyph.prototype.getRepresentation = function() {
    return '%c{' + this._foreground + '}%b{' + this._background + '}' + this._char +
        '%c{white}%b{black}';
};