// A repository has a name and a constructor. The constructor is used to create items in the repository.
Game.Repository = function(name, ctor) {
    this._name = name;
    this._templates = {};
    this._ctor = ctor;
    this._randomTemplates = {};
};

// Define a new named template
Game.Repository.prototype.define = function(name, template, options) {
    this._templates[name] = template;
    var disableRandomCreation = options && options['disableRandomCreation'];
    if (!disableRandomCreation)
        this._randomTemplates[name] = template;
};

// Create an object based on a template
Game.Repository.prototype.create = function(name, extraProperties) {
    if (!this._templates[name])
        throw new Error("No template named '" + name + "' in repository '" + this._name + "'");
		
    var template = Object.create(this._templates[name]);	// Copy the template
    if (extraProperties)
        for (var key in extraProperties)
            template[key] = extraProperties[key];
    
    return new this._ctor(template);						// Create the object, passing the template as an argument
};

// Create an object based on a random template
Game.Repository.prototype.createRandom = function() {
    return this.create(Object.keys(this._randomTemplates).random());
};