Game.Tile = function(properties) {
    properties = properties || {};
    Game.Glyph.call(this, properties);	// Pass props to parent
    this._minimap = properties['minimap'] || properties['background'];
	this._walkable = properties['walkable'] || false;
    this._diggable = properties['diggable'] || false;
    this._blocksLight = (properties['blocksLight'] !== undefined) ? properties['blocksLight'] : true;
    this._description = properties['description'] || '';
};
Game.Tile.extend(Game.Glyph);

// Standard getters
Game.Tile.prototype.isWalkable = function() {
    return this._walkable;
};
Game.Tile.prototype.isDiggable = function() {
    return this._diggable;
};
Game.Tile.prototype.isBlockingLight = function() {
    return this._blocksLight;
};
Game.Tile.prototype.getDescription = function() {
    return Game.capitaliseFirstLetter(this._description);
};
Game.Tile.prototype.getMinimapCol = function() {
    return this._minimap;
};

// Get neighbouring tiles in random order
Game.getNeighborPositions = function(x, y) {
    var tiles = [];
    for (var dX = -1; dX < 2; dX ++)
        for (var dY = -1; dY < 2; dY++) {
            if (dX == 0 && dY == 0)
				continue;

            tiles.push({x: x + dX, y: y + dY});
        }
	return tiles;
};