// Player template
Game.PlayerTemplate = {
    name: 'human (you)',
    character: '@',
    foreground: 'white',
    maxHp: 50,
    attackValue: 3,
	defenseValue: 3,
    sightRadius: 10,
    inventorySlots: 22,
    mixins: [Game.EntityMixins.PlayerActor,
             Game.EntityMixins.Attacker, 
			 Game.EntityMixins.Destructible,
             Game.EntityMixins.InventoryHolder, 
			 Game.EntityMixins.FoodConsumer,
             Game.EntityMixins.Sight,
			 Game.EntityMixins.MessageRecipient,
             Game.EntityMixins.Equipper,
			 Game.EntityMixins.Autopilotable,
             Game.EntityMixins.ExperienceGainer, 
			 Game.EntityMixins.PlayerStatGainer,
			 Game.EntityMixins.Recoverer]
};

// Create our central entity repository
Game.EntityRepository = new Game.Repository('entities', Game.Entity);

Game.EntityRepository.define('slime mold', {
    name: 'slime mold',
    character: '*',
    foreground: 'green',
	defenseValue: 1,
	maxHp: 4,
    level: 1,
	speed: 250,
    mixins: [Game.EntityMixins.FungusActor, Game.EntityMixins.Destructible,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('newt', {
    name: 'newt',
    character: ':',
    foreground: 'yellow',
    attackValue: 2,
	defenseValue: 0,
	maxHp: 8,
    level: 1,
	mixins: [Game.EntityMixins.TaskActor,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('drunk bat', {
    name: 'drunk bat',
    character: '"',
    foreground: 'navy',
    attackValue: 2,
	defenseValue: 1,
    maxHp: 12,
	level: 1,
	speed: 2000,
    mixins: [Game.EntityMixins.TaskActor, 
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('winged hob', {
    name: 'winged hob',
    character: 'w',
    foreground: 'navy',
    attackValue: 3,
	defenseValue: 1,
    maxHp: 16,
	level: 1,
    speed: 2000,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('kobold', {
    name: 'kobold',
    character: 'k',
    foreground: 'white',
    attackValue: 4,
    defenseValue: 3,
	maxHp: 24,
    level: 1,
	sightRadius: 5,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('feral mani', {
    name: 'feral mani',
    character: 'm',
    foreground: 'brown',
    attackValue: 3,
	defenseValue: 3,
    maxHp: 24,
    level: 1,
	sightRadius: 5,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('barrel-man', {
    name: 'barrel-man',
    character: 'U',
    foreground: 'purple',
    attackValue: 4,
	defenseValue: 4,
    maxHp: 16,
	level: 1,
	sightRadius: 5,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('farty hog', {
    name: 'farty hog', 
    character: '&',
    foreground: 'pink',
    attackValue: 8,
    defenseValue: 8,
    maxHp: 28,
	level: 1,
	sightRadius: 16,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('balrog', {
    name: 'balrog', 
    character: 'B',
    foreground: 'red',
    attackValue: 9,
    defenseValue: 9,
    maxHp: 40,
    level: 1,
	sightRadius: 16,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('fungleater', {
    name: 'fungleater',
    character: 'f',
    foreground: 'lightgreen',
    attackValue: 5,
	defenseValue: 1,
    maxHp: 40,
    level: 1,
	sightRadius: 3,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('basilisk', {
    name: 'basilisk',
    character: 's',
    foreground: 'darkgreen',
    attackValue: 2,
    defenseValue: 2,
    maxHp: 20,
    level: 1,
	sightRadius: 3,
    tasks: ['hunt', 'wander'],
    mixins: [Game.EntityMixins.TaskActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer, Game.EntityMixins.RandomStatGainer]
});

Game.EntityRepository.define('giant zombie', {
    name: 'giant zombie', 
    character: 'Z',
    foreground: 'teal',
    attackValue: 8,
    defenseValue: 5,
    maxHp: 80,
    level: 5,
    sightRadius: 6,
    mixins: [Game.EntityMixins.GiantZombieActor, Game.EntityMixins.Sight,
             Game.EntityMixins.Attacker, Game.EntityMixins.Destructible,
             Game.EntityMixins.CorpseDropper,
             Game.EntityMixins.ExperienceGainer]
}, {
    disableRandomCreation: true
});