SamplerState sm:register(s1);
Texture2D depth:register(t1); // depth input buffer
Texture2D input:register(t0); // color input buffer

#define distanceUnit (16.0)

cbuffer c : register(b1)
{
	//https://en.wikipedia.org/wiki/Circle_of_confusion
	float Aperture;
	float Focus; // multiplied with distanceUnit (see above)
	float Limit; // blur limit, screen space
}

float getDepth(float2 uv) { //return depth of pixel
	return depth.Sample(sm, uv).x * 5.0f;
}

float4 p(float4 PositionSS : SV_Position, float2 t : TEXCOORD) : SV_TARGET0
{
	float4 c = input.Sample(sm,t);
	float limit = Limit;
	float aperture = Aperture*Aperture;
	limit = limit*limit;

	float f = Focus*distanceUnit;
	float Object = getDepth(t);
	float Result = aperture*abs(Object - f) / Object;

	c.w = min(Result,limit); //pack color and coc into a pixel

	return c; //send it away to the next pass
}