#version 330 core

// inputz
in vec2 UV;
uniform sampler2D source;
uniform vec2 blurvec;
uniform vec2 iResolution;

const float B = 6.0;

// outputz
out vec4 color;

void main(){
    vec4 acc = vec4(0.0);
    for(float i = -B/2.0; i < B/2.0; i += 1.0){
        acc += texture(source, UV + blurvec * i / iResolution);
    }
    color = acc / B;
}