#version 330 core
layout(location=0) in vec3 vertex;
layout(location=1) in vec3 normal;
layout(location=2) in vec2 uv;
out vec2 UV;
out vec3 n;
uniform mat4 MVP;
uniform mat4 MV;
uniform vec3 S;
uniform mat3 R;
uniform vec3 posBias;

void main() {
	vec3 curVertex = R * (S * vertex + posBias);
	n = normalize(transpose(inverse(MV)) * vec4(normal, 0.0)).xyz;
	UV = uv;
	gl_Position = MVP * vec4(curVertex, 1.0);
}
