var CONF = {
    
    //AUDIO VARIABLES
    pbm : 120,
    //beats per row
    bpr : 4,
    //row rate
    rr : 120/60*4,
    //current row
    row : 0,
    
    //DEMO OR SYNC MODE?
    demomode : true,
    
    //DEVICE
    syncDevice : new JSRocket.SyncDevice()
};

//sync tracks for rocket
var SYNC = {
    part : false,
    brightness : false,
    negate : false,
    
    fov : false,
    near : false,
    far : false,
    aspect : false,
    
    heart : false,

    camera : {
        pos : {x: false, y: false, z: false},
        rot : {x: false, y: false, z: false}
    },
    
    obj : {
        pos : {x: false, y: false, z: false},
        rot : {x: false, y: false, z: false}
    },
    
    getHeartBeat : function(){
        var hb = SYNC.heart.getValue(CONF.row);
        return hb;
    },
    getCameraPosition : function(){
        var x = SYNC.camera.pos.x.getValue(CONF.row);
        var y = SYNC.camera.pos.y.getValue(CONF.row);
        var z = SYNC.camera.pos.z.getValue(CONF.row);
        
        return new THREE.Vector3(x,y,z);
    },
    getCameraRotation : function(){
        var x = SYNC.camera.rot.x.getValue(CONF.row);
        var y = SYNC.camera.rot.y.getValue(CONF.row);
        var z = SYNC.camera.rot.z.getValue(CONF.row);
        
        return new THREE.Vector3(x,y,z);
    },
    getObjPosition : function(){
        var x = SYNC.obj.pos.x.getValue(CONF.row);
        var y = SYNC.obj.pos.y.getValue(CONF.row);
        var z = SYNC.obj.pos.z.getValue(CONF.row);
        
        return new THREE.Vector3(x,y,z);
    },
    getObjRotation : function(){
        var x = SYNC.obj.rot.x.getValue(CONF.row);
        var y = SYNC.obj.rot.y.getValue(CONF.row);
        var z = SYNC.obj.rot.z.getValue(CONF.row);
        
        return new THREE.Vector3(x,y,z);
    },
    
    //Binding tracks
    bindTracks : function(test){

        SYNC.part = CONF.syncDevice.getTrack('part');
        SYNC.brightness = CONF.syncDevice.getTrack('brightness');

        if(test === true){
            SYNC.camZ = CONF.syncDevice.getTrack('camz');
            SYNC.cubeRot = CONF.syncDevice.getTrack('cuberot');
        }
        else{
            SYNC.negate = CONF.syncDevice.getTrack('negate');
        
            SYNC.fov = CONF.syncDevice.getTrack('fov');
            SYNC.near = CONF.syncDevice.getTrack('near');
            SYNC.far = CONF.syncDevice.getTrack('far');
            SYNC.aspect = CONF.syncDevice.getTrack('aspect');
            
            //Heart Beat
            SYNC.heart = CONF.syncDevice.getTrack('heart_beat');
            
            //CAMERA
            SYNC.camera.pos.x = CONF.syncDevice.getTrack('cam_x');
            SYNC.camera.pos.y = CONF.syncDevice.getTrack('cam_y');
            SYNC.camera.pos.z = CONF.syncDevice.getTrack('cam_z');
            
            SYNC.camera.rot.x = CONF.syncDevice.getTrack('cam_rot_x');
            SYNC.camera.rot.y = CONF.syncDevice.getTrack('cam_rot_y');
            SYNC.camera.rot.z = CONF.syncDevice.getTrack('cam_rot_z');
            
            //OBJECT
            SYNC.obj.pos.x = CONF.syncDevice.getTrack('obj_x');
            SYNC.obj.pos.y = CONF.syncDevice.getTrack('obj_y');
            SYNC.obj.pos.z = CONF.syncDevice.getTrack('obj_z');
            
            SYNC.obj.rot.x = CONF.syncDevice.getTrack('obj_rot_x');
            SYNC.obj.rot.y = CONF.syncDevice.getTrack('obj_rot_y');
            SYNC.obj.rot.z = CONF.syncDevice.getTrack('obj_rot_z');
        }
    }
};

