var CubeScape = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.scene.fog = new THREE.Fog(0x000000, 100, 550);
    
    var ambientLight = new THREE.AmbientLight(0xFFFFFF);
    this.scene.add(ambientLight);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.pointLight.position.set(20., 30., 0.);
    this.scene.add(this.pointLight);
    
    this.pointLight2 = new THREE.PointLight(0x808080);
    this.pointLight2.position.set(-20., 30., 0.);
    this.scene.add(this.pointLight2);
    
    this.cameraLight = new THREE.PointLight(0xFFFFFF);
    this.scene.add(this.cameraLight);
    
    var sky = this.createSky();
    this.scene.add(sky);
    
    this.grid = this.createCubes();
    this.grid.position.y = -60;
    this.scene.add(this.grid);
    this.ground = this.createHeightMap();
    this.ground.position.y = -60;
    this.scene.add(this.ground);
    
    var h = Heart(new THREE.PointsMaterial({color : 0xFF5555}),
        new THREE.MeshLambertMaterial({
            color : 0x505050,
            emissive : 0x000000,
            emissiveIntensity : 0.5
        }), 80, 80, 40);
    
    this.heart = h.heart;
    this.pyramid = h.diamond;
    
    this.heart.position.y = 30;
    this.scene.add(this.heart);
};

CubeScape.prototype = PartBase.prototype.inheritance();

CubeScape.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.bloom = new THREE.BloomPass(2);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 1);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 2);
    
    this.dof = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 2.0,
        aperture: 0.02
    });
    this.dof.renderToScreen = true;
    TDEMO.composer.addPass(this.dof);
    TDEMO.copyPass.enabled = false;
};

CubeScape.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   
   this.bloom.enabled = false;
   this.copy.enabled = false;
   this.dof.enabled = false;
   TDEMO.copyPass.enabled = true;
};

CubeScape.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.cameraLight.position.set(this.camera.position.clone());
  
  this.heart.scale.x = SYNC.getHeartBeat();
  this.heart.scale.z = SYNC.getHeartBeat();
  this.heart.scale.y = SYNC.getHeartBeat();
  
  this.pyramid.rotation.y += delta;
  
};

CubeScape.prototype.createCubes = function(){

    var material = new THREE.MeshLambertMaterial({
        color : 0x000000,
        emissive : 0xAA5555,
        emissiveIntensity : 0.5
    });
    
    var geometry = new THREE.BoxGeometry(10, 10, 10);
    
    var gridRight = new THREE.Object3D();
    var gridLeft = new THREE.Object3D();
    
    var x = -200;
    var z = -580;
    var defx = x;
    var deltaX = 20;
    var deltaZ = 20;
    
    for(var i = 0; i < 1200; ++i){
        var obj = new THREE.Mesh(geometry, material);
        obj.position.x = x;
        obj.position.z = z;

        obj.position.y = (((Math.sin(x)+1)+(Math.cos(z)+1))*5)+((i+0.5)/1200);
        obj.rotation.y = Math.PI*obj.position.y*0.5;
        
        gridRight.add(obj);
        gridLeft.add(obj.clone());
        
        x += deltaX;
        if((i+1)%20 === 0){
            x = defx;
            z += deltaZ;
        }
    }
    
    gridLeft.position.x = -190;
    gridRight.position.x = 190;
    
    //gridLeft.rotation.y = 0.3*Math.PI;
    //gridRight.rotation.y = -0.3*Math.PI;
    
    var grid = new THREE.Object3D();
    grid.add(gridRight);
    grid.add(gridLeft);
    
    return grid;
};

CubeScape.prototype.createHeightMap = function(){
    var geometry = TDEMO.heightGeometry();
    var material = new THREE.MeshLambertMaterial({
        color : 0xFFFFFF,
        emissive : 0xFF0000,
        emissiveIntensity : 0.5,
        envMap : TDEMO.textures.env_taivas
    });
    
    var ground = new THREE.Mesh( geometry, material );
    ground.rotation.x = -Math.PI/2;
    
    return ground;
};

CubeScape.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(400, 64, 64);
    var material = new THREE.MeshBasicMaterial({
        map: TDEMO.textures.taivas,
        side : THREE.BackSide
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};




