var ExplodingHeart = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.camera.position.set(0., 0., 100.);
    var ambientLight = new THREE.AmbientLight(0x808080);
    this.scene.add(ambientLight);
    var pointLight = new THREE.PointLight(0x222222);
    pointLight.position.set(0., 0., 0.);
    this.scene.add(pointLight);
    
    var h = Heart(new THREE.PointsMaterial({color : 0xFF0000}), false, 10, 20, 10);
    var h2 = Heart(new THREE.PointsMaterial({color : 0xFF5555}), false, 18, 20, 18);
    this.heart = new THREE.Object3D();
    this.heart.add(h.heart);
    this.heart.add(h2.heart);
    this.scene.add(this.heart);
};

ExplodingHeart.prototype = PartBase.prototype.inheritance();

ExplodingHeart.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.hblur = new THREE.ShaderPass( THREE.HorizontalBlurShader );
    this.hblur.uniforms[ "h" ].value =  2.0/TDEMO.width;

    this.vblur = new THREE.ShaderPass( THREE.VerticalBlurShader );
    this.vblur.uniforms[ "v" ].value = 2.0/TDEMO.height;
    
    TDEMO.composer.insertPass(this.hblur, 1);
    TDEMO.composer.insertPass(this.vblur, 2);
    
    this.bloom = new THREE.BloomPass(5);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 3);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 4);
    
    this.dof = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 2.0,
        aperture: 0.1
    });
    this.dof.renderToScreen = true;
    TDEMO.composer.addPass(this.dof);
    TDEMO.copyPass.enabled = false;
};

ExplodingHeart.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   
   this.bloom.enabled = false;
   this.copy.enabled = false;
   this.hblur.enabled = false;
   this.vblur.enabled = false;
   this.dof.enabled = false;
   TDEMO.copyPass.enabled = true;
};

ExplodingHeart.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  
  var heartr = SYNC.getObjRotation();
  this.heart.rotation.x = heartr.x;
  this.heart.rotation.y = heartr.y;
  this.heart.rotation.z = heartr.z;
  
  this.heart.scale.x = SYNC.getHeartBeat();
  this.heart.scale.z = SYNC.getHeartBeat();
  this.heart.scale.y = SYNC.getHeartBeat();  
};


