var LightCloud = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.camera.position.set(0., 0., 100.);
    var ambientLight = new THREE.AmbientLight(0x808080);
    this.scene.add(ambientLight);
    var pointLight = new THREE.PointLight(0x222222);
    pointLight.position.set(0., 0., 0.);
    this.scene.add(pointLight);
    
    this.cloud = this.createObj();
    var h = Heart(new THREE.PointsMaterial({color : 0xFF5555}), new THREE.MeshBasicMaterial({color : 0xFF0000}), 10, 20, 20);
    this.heart = h.heart;
    this.pyramid = h.diamond;
    
    this.heart.position.x = 10;
    this.heart.position.z = 10;
    
    this.cloud.add(this.heart);
    this.scene.add(this.cloud);
    
};

LightCloud.prototype = PartBase.prototype.inheritance();

LightCloud.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.hblur = new THREE.ShaderPass( THREE.HorizontalBlurShader );
    this.hblur.uniforms[ "h" ].value =  6.0/TDEMO.width;

    this.vblur = new THREE.ShaderPass( THREE.VerticalBlurShader );
    this.vblur.uniforms[ "v" ].value = 6.0/TDEMO.height;
    
    TDEMO.composer.insertPass(this.hblur, 1);
    TDEMO.composer.insertPass(this.vblur, 2);
    
    this.bloom = new THREE.BloomPass(3);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 3);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 4);
    
    this.dof = new THREE.BokehPass(this.scene, this.camera, {
        focus : 1.0,
        width: TDEMO.width,
        height: TDEMO.height,
        maxblur: 2.0,
        aperture: 0.03
    });
    this.dof.renderToScreen = true;
    TDEMO.composer.addPass(this.dof);
    TDEMO.copyPass.enabled = false;
};

LightCloud.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.bloom.enabled = false;
   this.copy.enabled = false;
   this.hblur.enabled = false;
   this.vblur.enabled = false;
   this.dof.enabled = false;
   TDEMO.copyPass.enabled = true;
};

LightCloud.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  
  var cloudr = SYNC.getObjRotation();
  this.cloud.rotation.x = cloudr.x;
  this.cloud.rotation.y = cloudr.y;
  this.cloud.rotation.z = cloudr.z;
  
  this.heart.scale.x = SYNC.getHeartBeat();
  this.heart.scale.z = SYNC.getHeartBeat();
  this.heart.scale.y = SYNC.getHeartBeat();
  
  this.pyramid.rotation.y += delta*0.1;
  
};

LightCloud.prototype.createObj = function(){

    var boneMaterial = new THREE.PointsMaterial({
        color : 0xCCCCFF
    });
    var cloud = new THREE.Object3D();
    
    //radius, widthSegments, heightSegments, phiStart, phiLength, thetaStart, thetaLength
    var geometry = new THREE.SphereGeometry(100, 32, 32, 10);
    var s1 = new THREE.Points(geometry, boneMaterial);
    
    var scaleFactor = 2;
    for(var i = 0; i < 6; ++i){
        var s = s1.clone();
        s.scale.x = 1/scaleFactor;
        s.scale.y = 1/scaleFactor;
        cloud.add(s);
        
        scaleFactor *= 2;
        
        
    }
    return cloud;
};




