var Tunnel = function(){
    PartBase.call(this);
    PartBase.prototype.initScene.call(this);
    
    this.video = document.getElementById( 'bolzano' );
    
    this.scene.fog = new THREE.Fog(0xFFFFFF, 100, 800);
    
    this.pointLight = new THREE.PointLight(0x808080);
    this.scene.add(this.pointLight);
    
    this.tunnel = this.createTunnel();
    this.scene.add(this.tunnel);
};

Tunnel.prototype = PartBase.prototype.inheritance();

Tunnel.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    
    this.edge = new THREE.ShaderPass( THREE.EdgeShader2 );
    this.edge.uniforms[ "resolution" ].value =  new THREE.Vector2(TDEMO.width, TDEMO.height);
    TDEMO.composer.insertPass(this.edge, 1);
    
    this.bloom = new THREE.BloomPass(2);
    this.bloom.renderToScreen = true;
    TDEMO.composer.insertPass(this.bloom, 2);
    
    this.copy = new THREE.ShaderPass(THREE.CopyShader);
    TDEMO.composer.insertPass(this.copy, 3);
    
    this.video.currentTime = 10;
    this.video.play();
};

Tunnel.prototype.finish = function(){
   PartBase.prototype.finish.call(this);
   this.edge.enabled = false;
   this.bloom.enabled = false;
   this.copy.enabled = false;
   
   this.video.pause();
};

Tunnel.prototype.animate = function(elapsedTime, delta){
  PartBase.prototype.animate.call(this, elapsedTime, delta);
  this.pointLight.position.set(this.camera.position.clone());
  
  this.tunnelTexture.offset.y += delta;
  this.tunnelTexture.offset.y %= 1;
  this.tunnelTexture.needsUpdate = true;
  
  this.hahmoTexture.offset.x += delta;
  this.hahmoTexture.offset.x %= 1;
  this.hahmoTexture.needsUpdate = true;
};

Tunnel.prototype.createTunnel = function(){

    var geometry = new THREE.BoxGeometry(20, 40, 1000);
    
    this.tunnelTexture = TDEMO.textures.rainbow;
    this.hahmoTexture = TDEMO.textures.hahmo;
    
    var material_tunnel = new THREE.MeshBasicMaterial({
        side : THREE.DoubleSide,
        map : this.tunnelTexture
    });
    
    var material_hahmo = new THREE.MeshBasicMaterial({
        side : THREE.DoubleSide,
        map : this.hahmoTexture
    });
    
    var material_heijastus = new THREE.MeshBasicMaterial({
        side : THREE.DoubleSide,
        color : 0xFFFFFF,
        map : TDEMO.textures.bolzano
    });

    for (var i = 0; i < geometry.faces.length; i++){
        if( i == 2 || i == 3){
            geometry.faces[ i ].materialIndex = 2;
        }
        else if( i == 0 || i == 1){
            geometry.faces[ i ].materialIndex = 1;
        }
        else{
            geometry.faces[ i ].materialIndex = 0;
        }
    }
    
    var material = new THREE.MultiMaterial([material_tunnel, material_hahmo, material_heijastus]);
    
    var tunnel = new THREE.Mesh(geometry, material);
    tunnel.rotation.z = Math.PI;
    return tunnel;
};