;                       /|
;                      //|.
;                     //_| .
;                 __ // /| .
;                /_ \/\__|. 
;                \\_/  _/|_
;                .g.e.n.d.a.
;
;______________________________________________________
;
;
;                   mehcaster 256b
;
;______________________________________________________
;
;	CODE:	        svoy
;______________________________________________________
;
;     Silly Venture 2016 256b intro, Party Version
;______________________________________________________
; tomaswoj@gmail.com
; http://pl.linkedin.com/in/tomaswoj
; Amsterdam - Cracow - Schaumburg

	opt h+	
	org $1200

sm_ptr	equ $58 ; screen memory pointer to text screen
; raycast zeropage
xcal_l	equ $d8 ; xcalc delta
ycal_l	equ $d9 ; ycalc delta
pixfin	equ $df ; final value of the pixel

curad_h equ $e1 ; current screen line address
curad_l	equ $e2
curad1_h equ $e3 ; current line + 2 lines address
curad1_l equ $e4

dl1_l  equ $e6 ; DL address for frame1
;dl2_l  equ $e7 ; DL address for frame2
;dl1_h  equ $e8
;dl2_h  equ $e9
fm1_l	equ $ea ; screen memory address for frame1
;fm2_l	equ $eb ; screen memory address for frame2
;fm1_h	equ $ec 
;fm2_h	equ $ed
frmbit  equ $ee ; user to choose the right frame, osciliate between 0 and 1
; sbc offset 0
xpix	equ $f0 ; order of these matters (in subs) 
;xoff2	equ $fc
xcalcd	equ $f2
; sbc offset 1
yrow	equ $f1
ycalcd	equ $f3
frmcnt	equ $f4
;ramtop equ 106
offset equ 107

; this did not fit into the party version :(
;	ldy #0 ; we start from $ff and clean all at the top of the screen
;	tya ; value is right
;clean:
;	dey
;	sta (sm_ptr), y
;	bne clean
			
	jsr waitloop ; rainbow and string, and first setgfx
tunnel:		       
	;jsr setgfx ; frame buffer 1, no rts in waitloop so it will run it anyway
	;sta 106 ; set memtop to get space for 2nd framebuffer
	jsr setgfx ; frame buffer 2
	;lda #80 ; whoa, 2 bytes less as out of setgfx we get 80 in accu!!! :) 
	;sta offset (reused with memtop - 106, inside the setgfx)

frame:	
	ldx frmbit	; select proper frame memory (0/1/0/1/0...)
	;lda fm1_h,x
	lda #$50	; seems to be always $50, so just use it directly
	sta curad_h
	lda fm1_l,x
	sta curad_l
	ldx #2
	jsr add40	; calculate screen memory loc for next 1 line	
	stx yrow	; start from 2nd line to shave 2 bytes
lines: 
	ldy #39 ; bytes in line (->80 pixels)			 
pixels:	
	ldx #1 ; (index1 for subs: ycalcd=yrow-frmcnt)
	lda yrow
	jsr subs	
	tya
	asl
	;sta xpix; xpix already in accu
	dex 	
	jsr subs ; (index0: xcalcd = xpix - frmcnt)
	stx xcal_l ; clear xcal_l initially
	stx ycal_l ; clear ycal_l initially 
	lda frmcnt ; use frame count as depth offset (increasing)
	asl
	asl ; potential byte saving
	tax ; use frmcnt*4 as depth offset
	;ldx frmcnt
cast: 
	lda xcal_l   ; if (distx>22 || disty>16) break to pix value calc, just check proper bits from high parts of xcal/ycal
	cmp #224
	bcs beyo
	adc xcalcd ; xcalc+=xcalcd
	sta xcal_l	 
	lda ycal_l	
	cmp #128
	bcs beyo
	adc ycalcd   ; ycalc+=ycalcd      
	sta ycal_l ; 3c
	inx ; if depth > 255 = 0
	inx
        bne cast ; we have not reached infinity so keep adding...
	dex ; infinity shall be white :)		       
beyo:	; calculating the pixel value, shifting magic
	; it's about xoring xcal, ycal, depth (in X register), and storing this in a form of abcdabcd (so two pixels in one byte) 
	lda xcal_l 
	eor ycal_l
	asl
	txa		
	bcc depth
	eor #16	 ; calculating the pixel value
		; depth5 = depth5 xor 1, so 0 if depth5=1, 1 otherwise
depth:
	and #240 ; xcal8 xor ycal8 == 0 so: xcal8 & ycal8 => depth5=depth5
	;alr #240
	sta pixfin
	lsr
	lsr
	lsr
	lsr
	ora pixfin
	
	sta (curad_h),Y	 ; store for current line
	sta (curad1_h),Y ; store for current line + 2 lines
	dey
	bne pixels ; if pixels in line left, calculate next pixel
	; if no pixels left go to next line
	; use #0 in y register (due to bne pixels) to initially populate y and x for 4-line shift
	asl offset ; there is 80 in offset, so 80->160, to move by 4 lines (4x40b)  
	ldx #0 ;via tya/tax above
	;inx	
	jsr add40 ; includes inx, inx at the end, move to the next line (4x40 bytes)
	lsr offset ; 160->80 (as every 2nd line is 80b away)
	; ldx #2 ; not needed due to add40
	jsr add40 ; next memory line
	lda #48
	isb yrow ; (inc memory, then subs from accumulator - illegal, but how nice! :) 2 bytes less
	bne lines	
	; ... or done with frame (with all lines)
	; so make current frame visible, set DL address to frame	
	lax frmbit ; loads frmbit to accu and x reg, to set the current bank
	eor #1 ; preps frmbit for next frame (0->1, 1->0)
	sta frmbit
	lda dl1_l,x
	sta $231 ; show calculated frame on screen
	lda #64 ; potential 2-bytes, but shorter tunnel flow				 	
	isb frmcnt 
	bne frame ; heh, this will go to frame until frmcnt reaches 64

	; now as we are done with tunnel part so start.... 
pmg:	; ... Agenda logo part
	lda #46 ; wide, PM enabled
	sta $22f
	;lda #2 or #3 ; enable player0 and missiles, reuse #46 value above
	sta $D01D
	; note that PMG position was already set in setgfx function
	jsr waitloop ; 3b, 8-12s wait with the logo on screen....
		
	; ... and the endless noise end part (inspired by JAC! TV Noise Anthology :)	 	
noise	txa 
	ora $d20a	; ora with random generator
	sta $d400	; set the distortion	
	bvc noise 	; and loop till the end of time

; offsets calculation function, for screen memory lines calculation
add40:  ; 13b 
	; use x as an offset of low pair, y as offset of high pair 
	; so same function can be used to add in place (x=0) or to add relative (x=2)
	clc ; POT
	lda curad_h
	adc offset
	sta curad_h,x
	lda curad_l
	adc #0		; add the carry only
	sta curad_l,x
	inx
	inx
	rts

; rainbow (in text modes) and message on the screen (in text modes, in gfx modes some random pixels, but well....)
; all in all holds on screen for ~12s.
waitloop:
	ldy #$03  ; 3 loops on RTCLOCK+2 so 3 x ~4s		
loop	lda $d40b ; simplest rainbow, VCOUNT number		
	adc 20	  ; add current RTCLOCK+2		
	sta $d018
	cpy 20 ; nice trick to drive display of letters: simply compare 1/60sec RTCLOCK+2 with reg Y. then dec Y, so every ~4s these meet!   
	bne loop
	; print prev letter	 
	dey
	lda meh,y
	sta (sm_ptr), y
	bne loop
	;rts ; this trick saves 4 bytes: jsr + rts :) fall through the setgfx, seems to make no harm :) 				
	
; setup gfx mode 9 (w/ GTIA), and get dlist addresses & screen memory start addresses	
setgfx:
	lda #8
	jsr $EF9C
	; C flag is set out of this jsr sooo....	
	ror $D000 ; ...finishing touch to get 128 into PMG position! nicely in the middle of the screen :)
		  ; that was the last optimization that cut the size from 258b to 256b :)  
	ldx frmcnt ; store it in 0 DL/FM (for first pass) and in 1 DL/FM (2nd pass)
	lda $231
	sta dl1_l,x
	lda 89	
	sta fm1_l,x
	lda 88  ; get memory address (50 returned? use in memtop outside, to skip lsr
	;sta fm1_h,x
	sta $D407 ; set PM memory page - $50
	sta 106,x ; in 1st pass sets RAMTOP (for 2nd pass), in 2nd pass sets offset to 80 :)	
	; on 2nd pass we get $50, soooo nice, that we can use it as offset... 	
	sta $26f ; use it to set graphics 9 GTIA
	inc frmcnt
	rts	

subs:
	;lda xpix,x ; this is moved outside of the subs
	sbc frmcnt
        bcs skipneg ; we want offset to be > 0
	eor #$FF ; negation if needed
	adc #1        
skipneg:		
	lsr
	sta xcalcd,x ; we calc xcald or ycald depending on x reg
	rts

; MEH string
meh dta b(45,37,40)
; Agenda A-logo
	org $5238 ; just put the PMG in the proper place in memory 	
agpmg 	dta b($2,$6,$a,$52,$bf,$e2,$43) 

        		