var Foggy = function(){
    PartBase.call(this);
    
    //POSTPROCESSING
    this.setBloom(2);
    this.setDoF({
        focus : 1.0,
        maxblur: 2.0,
        aperture: 0.01
    });
    
    this.texture = TDEMO.TEXTURES.getTextures().taivas;
    
    this.scene.fog = new THREE.Fog(0x903000, this.near, 1000);
    //this.scene.fog = new THREE.Fog(0xFF88FF, this.near, 1500);
    var sky = this.createSky();
    this.scene.add(sky);
    this.pallo = this.createBall();
    this.scene.add(this.pallo);
    
    //GEOMETRY
    
};

Foggy.prototype = PartBase.prototype.inheritance();

Foggy.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
  
    var ballp = TDEMO.SYNC.getObjPosition();
    this.pallo.position.x = ballp.x;
    this.pallo.position.y = ballp.y;
    this.pallo.position.z = ballp.z;

    var ballr = TDEMO.SYNC.getObjRotation();
    this.pallo.rotation.x = ballr.x;
    this.pallo.rotation.y = ballr.y;
    this.pallo.rotation.z = ballr.z;
    
    this.texture.offset.x += delta*0.005;
    this.texture.needsUpdate = true;
  
};

Foggy.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(1000, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0x303030,
        map : this.texture,
        side : THREE.BackSide
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};

Foggy.prototype.createBall = function(){
    var geometry = new THREE.SphereGeometry(800, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0x303030,
        map : this.texture
    });
    
    var pallo = new THREE.Mesh(geometry, material);
    return pallo;
}
