var Maa = function(){
    PartBase.call(this);
    
    //POSTPROCESSING
    this.setEdgeDetection();
    this.setBloom(0.5);
    
    //VIDEO TEXTURE
    this.video = document.getElementById( 'maa' );
    this.texture = new THREE.VideoTexture(this.video);
    this.texture.minFilter = THREE.LinearFilter;
    this.texture.magFilter = THREE.LinearFilter;
    this.texture.format = THREE.RGBFormat;
    
    //GEOMETRY
    var geometry = new THREE.PlaneGeometry(800, 450);
    var material = new THREE.MeshBasicMaterial({
        map : this.texture
    });

    var display = new THREE.Mesh(geometry, material);
    this.scene.add(display);
};

Maa.prototype = PartBase.prototype.inheritance();

Maa.prototype.prepare = function(){
    PartBase.prototype.prepare.call(this);
    this.video.currentTime = 0;
    this.video.play();
};

Maa.prototype.finish = function(){
   PartBase.prototype.finish.call(this);   
   this.video.pause();
};