var Nost = function(){
    PartBase.call(this);
    
    //POSTPROCESSING
    this.setBloom(2);
    this.setDoF({
        focus : 1.0,
        maxblur: 2.0,
        aperture: 0.01
    });
    
    this.texture = TDEMO.TEXTURES.getTextures().nelionosturit;
    
    this.scene.fog = new THREE.Fog(0x502000, this.near, 1500);
    var sky = this.createSky();
    this.scene.add(sky);
    this.pallot = this.createBalls();
    this.scene.add(this.pallot);
    
    //GEOMETRY
    
};

Nost.prototype = PartBase.prototype.inheritance();

Nost.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);

    var ballp = TDEMO.SYNC.getObjPosition();
    this.pallot.position.x = ballp.x;
    this.pallot.position.y = ballp.y;
    this.pallot.position.z = ballp.z;

    var ballr = TDEMO.SYNC.getObjRotation();
    this.pallot.rotation.x = ballr.x;
    this.pallot.rotation.y = ballr.y;
    this.pallot.rotation.z = ballr.z;

    this.texture.offset.x += delta*0.05;
    this.texture.offset.y += delta*0.05;
    this.texture.needsUpdate = true;
  
};

Nost.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(1000, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0x303030,
        map : this.texture,
        side : THREE.BackSide
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};

Nost.prototype.createBalls = function(){
    var pallot = new THREE.Object3D();
    var geometry = new THREE.SphereGeometry(200, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0x303030,
        map : this.texture,
        side : THREE.BackSide
    });
    
    var pallo = new THREE.Mesh(geometry, material);
    var pallo2 = pallo.clone();
    var pallo3 = pallo.clone();

    pallo.position.set(-300, 0, 200);
    pallo2.position.set(300, 70, 100);
    pallo3.position.set(0, 0, -200); 

    pallot.add(pallo);
    pallot.add(pallo2);
    pallot.add(pallo3);

    
    return pallot;
}
