var ParticleSphere = function(){
    PartBase.call(this);
    
    this.setBloom(3);
    
    this.setDoF({
        focus : 1.0,
        maxblur: 1.8,
        aperture: 0.015
    });
    this.texture = TDEMO.TEXTURES.getTextures().taivas;
    
    this.scene.fog = new THREE.Fog(0x000000, this.near, 1000);
    
    var ambientLight = new THREE.AmbientLight(0xFFFFFF);
    this.scene.add(ambientLight);
    
    this.cameraLight = new THREE.PointLight(0xFFFFFF);
    this.scene.add(this.cameraLight);
    
    this.particles = this.createParticles();
    this.scene.add(this.particles);
    
    var sky = this.createSky();
    this.scene.add(sky);
};

ParticleSphere.prototype = PartBase.prototype.inheritance();

ParticleSphere.prototype.animate = function(elapsedTime, delta){
    PartBase.prototype.animate.call(this, elapsedTime, delta);
    this.cameraLight.position.set(this.camera.position.clone());
    
    this.texture.offset.x += delta*0.005;
    this.texture.needsUpdate = true;
    
    var p = TDEMO.SYNC.getObjPosition();
    this.particles.position.x = p.x;
    this.particles.position.y = p.y;
    this.particles.position.z = p.z;

    var r = TDEMO.SYNC.getObjRotation();
    this.particles.rotation.x = r.x;
    this.particles.rotation.y = r.y;
    this.particles.rotation.z = r.z;
    
    var s = TDEMO.SYNC.getHeartBeat();
    this.particles.scale.x = s;
    this.particles.scale.y = s*1.1;
    this.particles.scale.z = s*1.2;
  
  
};

ParticleSphere.prototype.createSky = function(){
    var geometry = new THREE.SphereGeometry(800, 128, 128);
    var material = new THREE.MeshBasicMaterial({
        color : 0x303030,
        map : this.texture,
        side : THREE.BackSide
    });
    
    var sky = new THREE.Mesh(geometry, material);
    return sky;
};

ParticleSphere.prototype.createParticles = function(){
    
    var geometry = new THREE.SphereGeometry(80, 62, 62, 12);
    
    var group = new THREE.Object3D();
    var rotation = 0;
    
    for(var i = 1; i < 9; ++i){
    
        //TODO:varin muutos
        var material = new THREE.PointsMaterial({
            color : 0xFFFFFF,
            size : 1
        });
        
        
        var sphere = new THREE.Points(geometry, material);
        sphere.scale.x = i;
        sphere.scale.y = i;
        sphere.scale.z = i;
        sphere.rotation.y = rotation;
        sphere.rotation.x = rotation*0.5;
        sphere.rotation.z = rotation*0.25;
        
        group.add(sphere);
        
        rotation = i*0.25*Math.PI;
    }
    
    return group;
    
};



