#version 410 core

uniform vec2 resolution;

uniform sampler2D colorTex;
uniform sampler2D posTex;
uniform sampler2D normalTex;

in vec2 texCoords;

out vec4 FragColor;

void main()
{
    ivec2 uv = ivec2(texCoords * resolution);

    float backgroundGradient = pow(1.0 - clamp(length(texCoords - vec2(.5)), 0.0, 1.0), 4.0);
    vec3 background = mix(vec3(0.6), vec3(1.0), backgroundGradient) * .13;
    vec3 outputColor = background;

    vec3 worldPos = texelFetch(posTex, uv, 0).xyz;
    // TODO: Better check than this (because it can fail with valid values)
    if (worldPos != vec3(0.0))
    {
        vec3 color = texelFetch(colorTex, uv, 0).xyz;
        vec3 worldPos = texelFetch(posTex, uv, 0).xyz;
        vec3 worldNormal = texelFetch(normalTex, uv, 0).xyz;

        vec3 worldLightPos = vec3(100.0, 100.0, 50.0);

        vec3 worldLightDir = normalize(worldLightPos - worldPos);
        // TODO: Transform by view matrix or something
        vec3 lightDir = worldLightDir;
        vec3 viewDir = vec3(0.0, 0.0, -1.0);

        float nDotL = dot(worldNormal, lightDir);
        float diffuse = max(nDotL, 0.0);

        vec3 r = reflect(-lightDir, worldNormal);
        float rDotV = dot(r, viewDir);
        float specular = pow(max(rDotV, 0.0), 7.0);

        outputColor = color * diffuse + specular;
    }

    outputColor = pow(outputColor * 6.0, vec3(3.5));

    FragColor = vec4(outputColor, 1.0);
}
