#pragma once
#include <GL/glew.h>
#include "ShaderProgram.h"
#include "Renderbuffer.h"

#define POINTNUM 160000
#define STEPDIST 0.109

namespace cg {
	class Demo
	{
	public:
		Demo(char *configname, int w, int h);
		~Demo();
		void update(double time);
	private:
		int starty;
		int width;
		int height;
		void readConfig(char *filename); //Future developement
		GLuint vbo[4] = { 0,0,0,0 };
		GLuint vao = 2;

		// Textures
		GLuint walk[74];
		GLuint deserttex;
		GLuint desertbrtex;
		GLuint mountaintex;
		GLuint stargroundtex;
		GLuint starskytex;
		GLuint meteorgroundtex;
		GLuint meteorskysmalltex;
		GLuint meteorskybigtex;
		GLuint credittex;
		GLuint titletex;
		
		GLuint pointsprite;
		GLuint pointsprites_vba;

		Renderbuffer *framebuffer;

		ShaderProgram *defaultprg;
		ShaderProgram *movingtxtprg;
		ShaderProgram *spriteprg;
		ShaderProgram *textsprite;
		ShaderProgram *desertshadow;
		ShaderProgram *backgroundprg;
		ShaderProgram *postprocessing;
		ShaderProgram *rotateprg;
		ShaderProgram *meteorprg;
		ShaderProgram *heatprg;

		void drawBackground(GLuint texture, GLuint brighttex, int ks);
		void heatBackground(GLuint texture, GLuint brighttex, double time);
		void drawMan(GLuint prg, int index, float x, float y, float r, float g, float b);
		void rotateLayer(double time);
		void drawMeteorLayer(GLuint smalltex, GLuint bigtex, double time);

		void Scene4(double time);
		void Scene5(double time);
		void Scene6(double time);
		void MountainScene(double time);
		void DesertScene(double time);
		void NightScene(double time);
		void MeteorScene(double time);
		void EndCredit();
	};
}

