#pragma once

#include "Missile.h"

class Ship;

class IEvent
{
	public:
		enum Type
		{
			MissileHit,
			SunHit
		};

		virtual Type type() const = 0;
		virtual int energyDelta() const = 0;
};

class SunHitEvent : public IEvent
{
	public:
		IEvent::Type type() const override
		{
			return IEvent::SunHit;
		}

		int energyDelta() const override
		{
			return 0;
		}
};

class MissileHitEvent : public IEvent
{
	public:
		MissileHitEvent(const Missile& missile, const int targetId)
			: m_missile(missile)
			, m_targetId(targetId)
		{}

		IEvent::Type type() const override
		{
			return IEvent::MissileHit;
		}

		int targetId() const
		{
			return m_targetId;
		}

		const Missile& missile() const
		{
			return m_missile;
		}

		int energyDelta() const override
		{
			return C::Missile::DAMAGE;
		}

	private:
		const Missile& m_missile;
		const int m_targetId;
};
