#pragma once

#include <QJsonObject>

#include "AbstractGameObject.h"

class Missile : public AbstractGameObject
{
	public:
		enum class Type
		{
			Invalid,
			Normal,
			Mine,
			Seeking
		};

		Missile();
		Missile(int ownerId, Type type, const Angle& rotation, const Position& position);
		Missile(const QJsonObject& jsonObject);

		void step() override;

		int ownerId() const
		{
			return m_ownerId;
		}

		Type type() const
		{
			return m_type;
		}

		bool operator==(const Missile& other) const
		{
			return AbstractGameObject::operator==(other)
				&& m_ownerId == other.m_ownerId
				&& m_type == other.m_type;
		}

	private:
		int m_ownerId;
		Type m_type;
};
