#pragma once

#include <QtTest>

#include "Position.h"

class TestPosition : public QObject
{
	Q_OBJECT

	private slots:
		void directDistanceToOther()
		{
			static constexpr Position p1(-0.85, -0.20);
			static constexpr Position p2(0.45, 0.75);

			const auto& d = p1.distanceTo(p2, Position::DistanceMode::Direct);
			QVERIFY(d > 1.61012421 && d < 1.61012422);
		}

		void wrappingDistanceToOther()
		{
			static constexpr Position p1(-0.9, -0.9);
			static constexpr Position p2(0.9, 0.9);

			const auto& d = p1.distanceTo(p2, Position::DistanceMode::Wrapping);
			QVERIFY(d > 0.28284271 && d < 0.28284272);
		}
};
