﻿


using System;
using System.Collections.Generic;
using System.Linq;
using System.Security;
using System.Text;
using System.Threading.Tasks;

namespace g23pax {
   public class G_23_pax : IPax {

      private const int PRED_STEPS = 70;
      private int HUNT_STEPS;
      Dictionary<int, LinkedList<Missile>> MissilePredictions = new Dictionary<int, LinkedList<Missile>>();

      public G_23_pax(int hsteps = 70) {
         HUNT_STEPS = hsteps;
      }

      void PredictMissile(int id) {
         var l = MissilePredictions[id];
         while (l.Count < PRED_STEPS && l.Last != null && l.Last.Value != null) {
            var next = new Missile(l.Last.Value);
            l.AddLast(next.DoMove() ? next : null);
         }
      }


      void PredictMissiles(GameState gamestate) {
         gamestate.Missiles.ForEach(m => {
            if (!MissilePredictions.ContainsKey(m.ID))
               MissilePredictions.Add(m.ID, new LinkedList<Missile>(new[] { m }));
            else {
               var ml = MissilePredictions[m.ID];
               if (ml.Count > 0)
                  ml.RemoveFirst();
               if (ml.First != null && ml.First.Value != null) {
                  var d = ml.First.Value.SqDistTo(m);
                  if (d > 0.00001) {
                     ml.Clear();
                     ml.AddLast(m);
                  }
               }
            }
            PredictMissile(m.ID);
         });

         MissilePredictions.Keys
            .Where(p => gamestate.Missiles.All(q => q.ID != p)).ToList()
            .ForEach(q => MissilePredictions.Remove(q));
      }

      Dictionary<int, LinkedList<Player>> PlayerPredictions = new Dictionary<int, LinkedList<Player>>();
      private void PredictPlayer(int id) {
         var l = PlayerPredictions[id];
         while (l.Count < PRED_STEPS && l.Last != null && l.Last.Value != null) {
            var next = new Player(l.Last.Value);
            l.AddLast(next.DoMove() ? next : null);
            next.Energy -= 4;
         }
      }

      void PredictPlayers(GameState gamestate) {
         gamestate.All.ForEach(p => {
            if (!PlayerPredictions.ContainsKey(p.ID))
               PlayerPredictions.Add(p.ID, new LinkedList<Player>(new[] { p }));
            else {
               var pl = PlayerPredictions[p.ID];
               if (pl.Count > 0)
                  pl.RemoveFirst();
               if (pl.First != null && pl.First.Value != null) {
                  var d = pl.First.Value.SqDistTo(p);
                  if (d > 0.00001) {
                     pl.Clear();
                     pl.AddLast(p);
                  }
               }
            }
            PredictPlayer(p.ID);
         });

         PlayerPredictions.Keys
            .Where(p => gamestate.All.All(q => q.ID != p)).ToList()
            .ForEach(q => PlayerPredictions.Remove(q));
      }

      void ClearState() {
         PlayerPredictions.Clear();
         MissilePredictions.Clear();
      }

      public GameState.Decision PaxilonHydrochlorate(GameState gamestate) {
         if (gamestate == null || !gamestate.Players.ContainsKey(gamestate.YouID)) {
            ClearState();
            return GameState.Decision.None;
         }

         PredictMissiles(gamestate);
         PredictPlayers(gamestate);

         var tmp = new Player(gamestate.You);
         tmp.DoMove();
         tmp.Energy--;

         var ejaculate = new List<Missile>(HUNT_STEPS * 2 + 1);
         ejaculate.Add(tmp.Decide(GameState.Decision.M, false));

         var othersPredictions =
            gamestate.Others.Select(p => PlayerPredictions[p.ID].First).Where(p => p != null).ToList();
         for (int o = 0; o < othersPredictions.Count; o++)
            othersPredictions[o] = othersPredictions[o].Next != null && othersPredictions[o].Next.Value != null
                  ? othersPredictions[o].Next
                  : othersPredictions[o];

         for (int i = 0; i < HUNT_STEPS * 2; i++) {
            for (int j = 0; j < ejaculate.Count; j++) {
               var sperm = ejaculate[j];
               if (sperm.DoMove()) {
                  var opfer = othersPredictions.FirstOrDefault(p => sperm.SqDistTo(p.Value) < C.SUN_RADIUS_SQ);
                  if (opfer != null) {
                     if (j == 0)
                        return GameState.Decision.M;
                     return (j % 2) == 0
                        ? GameState.Decision.L
                        : GameState.Decision.R;
                  }
               }
            }

            if ((i % 2) == 0) {
               tmp.Rotate(i, 1);
               tmp.DoMove();
               tmp.Energy--;
            } else
               tmp.Rotate(-i, 0);
            ejaculate.Add(tmp.Decide(GameState.Decision.M, false));

            for (int o = 0; o < othersPredictions.Count; o++)
               othersPredictions[o] = othersPredictions[o].Next != null && othersPredictions[o].Next.Value != null
                  ? othersPredictions[o].Next
                  : othersPredictions[o];
         }

         return GameState.Decision.None;
      }

      public string Name { get { return "pax" + HUNT_STEPS; } }
   }
}
