﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using Newtonsoft.Json;
using Redzen.Numerics;

namespace g23pax {
   public class TurnonmeWorld {
      private TurnonmeParser _parser;
      private GameState State { get; set; }
      private StreamReader rdr;
      private StreamWriter sw;
      private bool _tcp;

      public TurnonmeWorld(int maxTimesteps, bool tcp, string Name = "guru meditation") {
         _tcp = tcp;
         while (true) {
            try {
               //if (tcp) {
                  var cli = new TcpClient();
                  cli.Connect("127.0.0.1", 54321);
                  sw = new StreamWriter(cli.GetStream());
                  sw.Write("NAME " + Name + "\r\n");
                  sw.Flush();
                  rdr = new StreamReader(cli.GetStream());
                  State = TurnonmeParser.Parse(rdr.ReadLine());

                  var d = GameState.Decision.None;
               sw.Write(
                  d == GameState.Decision.A
                     ? "ACCELERATE\n"
                     : d == GameState.Decision.L
                        ? "LEFT\n"
                        : d == GameState.Decision.R
                           ? "RIGHT\n"
                           : d == GameState.Decision.M
                              ? "MISSILE\n"
                              : d == GameState.Decision.Mine
                                 ? "Mine\n"
                                 : "");
                  sw.Flush();
                  State = TurnonmeParser.Parse(rdr.ReadLine());
                  while ((State == null || State.You == null || State.You.Energy < 1))
                     State = TurnonmeParser.Parse(rdr.ReadLine());
                  // OR 
                  State.Tick(d);


               //} else {
               //   State = new GameState() {
               //      Missiles = new List<Weapon>(),
               //      Others =
               //         Enumerable.Range(1, C.RNG.Next(4))
               //         //Enumerable.Range(1, 1)
               //            .Select(p => new Someone { ID = p, Energy = C.START_ENERGY })
               //            .ToList(),
               //      You = new Someone { Energy = C.START_ENERGY }
               //   };
               //
               //   int playerCount = State.Others.Count + 1;
               //   int o = C.RNG.Next(playerCount);
               //   for (int i = 0; i < playerCount; i++) {
               //      double angle = i * Math.PI * 2.0 / (double)playerCount;
               //      var p = State.Players[(i + o) % playerCount];
               //      p.X = Math.Cos(angle) * 0.5;
               //      p.Y = Math.Sin(angle) * 0.5;
               //
               //      double velocityAngle = Math.Atan2(p.Y, p.X) + Math.PI / 2.0;
               //      p.VelocityX = Math.Cos(velocityAngle) / 35.0;
               //      p.VelocityY = Math.Sin(velocityAngle) / 35.0;
               //      p.Rotation = velocityAngle;
               //
               //      //Console.WriteLine(angle);
               //      //Console.WriteLine(p);
               //      //Console.Out.Flush();
               //   }
               //
               //}
            } catch {
               Thread.Sleep(543);
            }
         }
      }

      public TurnonmeWorld() { }

      private double t(double y, double x) {
         return Math.Atan2(y, x);
      }

      private double r(Entity p) {
         return Math.Sqrt((p.X * p.X) + (p.Y * p.Y));
      }

      private double CalcAngleDelta(double a, double b) {
         return Math.Min(Math.Abs(a - b), Math.Abs(b - a));
      }

      public void Dispose() {
         if (_tcp) {
            rdr.BaseStream.Close();
         }
      }
   }

   public class Pos {
      public double X { get; set; }
      public double Y { get; set; }

      public Pos() { }

      public Pos(Pos copy) {
         X = copy.X;
         Y = copy.Y;
      }
   }

   public class Entity : Pos {
      public int ID { get; set; }
      public double Energy { get; set; }
      public double Rotation { get; set; }
      public double VelocityX { get; set; }
      public double VelocityY { get; set; }

      public Entity() { }

      public Entity(Entity copy) : base(copy) {
         ID = copy.ID;
         Energy = copy.Energy;
         Rotation = copy.Rotation;
         VelocityX = copy.VelocityX;
         VelocityY = copy.VelocityY;
      }

      public Entity CopyFrom(Entity copy) {
         ID = copy.ID;
         Energy = copy.Energy;
         Rotation = copy.Rotation;
         VelocityX = copy.VelocityX;
         VelocityY = copy.VelocityY;
         return this;
      }
   }


   public class PredictionWeapon : Weapon {
      public GameState.Decision ToGet { get; private set; }

      public PredictionWeapon(GameState.Decision toGet, Weapon m) : base(m) {
         ToGet = toGet;
      }
   }

   public class Weapon : Entity {
      public int Owner { get; set; }
      public string Type { get; set; }

      public Weapon() { }

      public Weapon(Weapon copy)
         : base(copy) {
         Owner = copy.Owner;
      }

      public Weapon CopyFrom(Weapon copy) {
         base.CopyFrom(copy);
         Owner = copy.Owner;
         return this;
      }

      public bool DoMove() {
         var sqd = X * X + Y * Y;
         if (sqd < C.SUN_RADIUS_SQ) {
            return false;
         }
         var sqv = VelocityX * VelocityX + VelocityY * VelocityY;
         if (sqv > C.MISSILE_MAX_SPEED_SQ) {
            var va = Math.Atan2(VelocityY, VelocityX);
            VelocityX = Math.Cos(va) * C.MISSILE_MAX_SPEED;
            VelocityY = Math.Sin(va) * C.MISSILE_MAX_SPEED;
         }
         var f = Math.Sqrt(sqd) / 1000d;
         var a = Math.Atan2(Y, X);
         VelocityX -= Math.Cos(a) * f;
         VelocityY -= Math.Sin(a) * f;
         X += VelocityX;
         Y += VelocityY;

         if (X > 1) X = -1d;
         if (X < -1) X = 1d;
         if (Y > 1) Y = -1d;
         if (Y < -1) Y = 1d;

         if (Type == "NORMAL") {
            Rotation = C.rot(Math.Atan2(VelocityY, VelocityX));
         }
         if (Energy < 10) {
            VelocityX /= 1.01;
            VelocityY /= 1.01;
            return true;
         }
         if (Type == "MINE") {

            VelocityX += Math.Cos(Rotation) * 0.0005d;
            VelocityY += Math.Sin(Rotation) * 0.0005d;
            Energy--;
            return true;
         }
         Energy -= 50;
         if (Type == "NORMAL") {

            VelocityX += Math.Cos(Rotation) * (Energy / 1000000.0);
            VelocityY += Math.Sin(Rotation) * (Energy / 1000000.0);
         } else if (Type == "SEEKING") {
            VelocityX += Math.Cos(Rotation) * (Energy / 100000.0);
            VelocityY += Math.Sin(Rotation) * (Energy / 100000.0);
         }
         return true;
      }
   }

   public class Someone : Entity {
      public int Score { get; set; }
      public List<int> HitBy { get; set; }

      public Someone() { }

      public Someone(Someone copy)
         : base(copy) {
         Score = copy.Score;
      }

      public Someone CopyFrom(Someone copy) {
         base.CopyFrom(copy);
         Score = copy.Score;
         return this;
      }

      public override string ToString() {
         return string.Format("{0}: {1}\t{2:0.00},{3:0.00}", ID, Energy, X, Y);
      }

      public void Rotate(int steps, int costsEnergyForSteps = 1) {
         Energy -= C.ROTATE_COST * costsEnergyForSteps;

         Rotation = C.rot(Rotation + C.ROTATE_AMOUNT_RAD * steps);
      }

      private void Rotate(double amount, bool costsEnergy=true) {
         if(costsEnergy)
            Energy -= C.ROTATE_COST;

         Rotation = C.rot(Rotation + amount);
      }

      public bool DoMove(bool costsEnergy = false) {
         if (Energy < 1) {
            return false;
         }

         double angle = Math.Atan2(Y, X);
         double dsq = X * X + Y * Y;

         if (dsq < C.SUN_RADIUS_SQ) {
            Energy = 0;
            return false;
         }

         var force = Math.Sqrt(dsq) / Energy;
         VelocityX -= Math.Cos(angle) * force;
         VelocityY -= Math.Sin(angle) * force;

         if (VelocityX > 0.05) VelocityX = 0.05;
         if (VelocityY > 0.05) VelocityY = 0.05;
         if (VelocityX < -0.05) VelocityX = -0.05;
         if (VelocityY < -0.05) VelocityY = -0.05;

         X += VelocityX;
         Y += VelocityY;

         if (X > 1.0) X = -1.0;
         if (Y > 1.0) Y = -1.0;
         if (X < -1.0) X = 1.0;
         if (Y < -1.0) Y = 1.0;

         if (costsEnergy)
            Energy--;

         return true;
      }

      private int MISSIDEES = int.MinValue;
      public Weapon Decide(GameState.Decision decision, bool costsEnergy = true) {
         switch (decision) {
            case GameState.Decision.None:
               return null;
            case GameState.Decision.A:
               VelocityX += Math.Cos(Rotation) * C.ACCELERATION_FORCE;
               VelocityY += Math.Sin(Rotation) * C.ACCELERATION_FORCE;
               if (costsEnergy)
                  Energy -= C.ACCELERATION_COST;
               return null;
            case GameState.Decision.L:
               Rotate(-C.ROTATE_AMOUNT_RAD, costsEnergy);
               return null;
            case GameState.Decision.R:
               Rotate(C.ROTATE_AMOUNT_RAD, costsEnergy);
               return null;
            case GameState.Decision.Mine:
               if (costsEnergy)
                  Energy -= C.MINE_COST;

               return new Weapon {
                  ID = ++MISSIDEES,
                  X = X,
                  Y = Y,
                  Rotation = Math.Atan2(Y, X),
                  Owner = ID,
                  Type = "MINE",
                  VelocityX = Math.Cos(Rotation) * 0.005,
                  VelocityY = Math.Sin(Rotation) * 0.005,
                  Energy = 5000,
               };
            case GameState.Decision.M:
               //     player->decreaseEnergy(SEEKING_MISSILE_COST);
               //     player->decreaseEnergy(MINE_COST);
               if (costsEnergy)
                  Energy -= C.MISSILE_COST;


               //    if (type == Mine) {
               //        setRotation(atan2(startPosition.y(), startPosition.x()));
               //
               //        m_velocityX = cos(m_rotation) * 0.005;
               //        m_velocityY = sin(m_rotation) * 0.005;
               //        m_energy = 5000;
               //        return;
               //    } else if (type == Seeking) {
               //        m_velocityX = cos(m_rotation) * 0.03;
               //        m_velocityY = sin(m_rotation) * 0.03;
               //    }

               return new Weapon {
                  ID = ++MISSIDEES,
                  X = X,
                  Y = Y,
                  Rotation = Rotation,
                  Owner = ID,
                  Type = "NORMAL",
                  VelocityX = Math.Cos(Rotation) * 0.05,
                  VelocityY = Math.Sin(Rotation) * 0.05,
                  Energy = 1000,
               };
            default:
               return null;
         }
      }
   }


   public class GameState {
      public List<Weapon> Missiles { get; set; }
      public List<Someone> All { get; set; }

      private int _youID;

      public int YouID {
         get { return _youID; }
         set {
            _others = null;
            _you = null;
            _youID = value;
         }
      }

      private List<Someone> _others;

      public IReadOnlyList<Someone> Others {
         get { return _others ?? (_others = All.Where(p => p.ID != YouID).ToList()); }
      }

      private Someone _you;

      public Someone You {
         get { return _you ?? (_you = Players[YouID]); }
      }

      private Dictionary<int, Someone> _players;

      public Dictionary<int, Someone> Players {
         get { return _players ?? (_players = All.ToDictionary(p => p.ID)); }
      }

      public GameState() { }

      public GameState(GameState copy) {
         Missiles = copy.Missiles.Select(p => new Weapon(p)).ToList();
         All = copy.All.Select(p => new Someone(p)).ToList();
         YouID = copy.YouID;
      }

      public enum Decision {
         None,
         L,
         R,
         A,
         M,
         Mine
      }


      private double oc;
      private bool first = true;
      private int[,] loveact;
      private int t = 0;

      public void Tick(Decision d) {
         if (first) {
            oc = Others.Count;
            first = false;
            loveact = new int[8, Others.Count];
            for (int j = 0; j < 8; j++)
               for (int i = 0; i < Others.Count; i++)
                  loveact[j, i] = ((int)(C.RNG.NextDouble() * C.RNG.NextDouble() * 5d)) % 5;
         }
         t++;
         for (int i = Missiles.Count - 1; i >= 0; i--) {
            var m = Missiles[i];
            if (!m.DoMove()) {
               Missiles.RemoveAt(i);
               continue;
            }
            Someone closest = null;
            double closestDX = 0, closestDY = 0, cdsq = 99;

            foreach (var P in Players) {
               var player = P.Value;
               if (player.Energy < 1)
                  continue;
               if (player.ID == m.Owner)
                  continue;
               double dx = player.X - m.X;
               double dy = player.Y - m.Y;
               double dsq = dx * dx + dy * dy;
               if (dsq < C.SUN_RADIUS_SQ) {
                  var win = Players[m.Owner];
                  win.Energy += C.MISSILE_DAMAGE;
                  win.Score++;
                  player.Energy -= C.MISSILE_DAMAGE;
                  Missiles.RemoveAt(i);
                  break;
               }
               if (closest == null || dsq < cdsq) {
                  cdsq = dsq;
                  closest = player;
                  closestDX = dx;
                  closestDY = dy;
                  continue;
               }
            }

            if (m.Type == "SEEKING" && closest != null) {
               m.Rotation = C.rot(Math.Atan2(closestDX, closestDY));
            }
         }


         for (int i = All.Count - 1; i >= 0; i--) {
            var player = Others[i];
            if (player.Energy < 1) {
               All.RemoveAt(i);
               continue;
            }

            if (!player.DoMove()) {
               All.RemoveAt(i);
               continue;
            }
            player.Energy--;

            var m = player.ID == YouID
               ? player.Decide(d)
               : player.Decide(
                  new[] {
                     Decision.None,
                     Decision.R,
                     Decision.M,
                     Decision.A,
                     Decision.L,
                  }[loveact[t%8, i]]);
            
            if (m != null)
               Missiles.Add(m);
         }
         if (!You.DoMove()) {
            return;
         }
         You.Energy--;
         var M = You.Decide(d);
         if (M != null)
            Missiles.Add(M);
      }
   }

   public class TurnonmeParser {
      public static GameState Parse(string json) {
         if (json == null)
            return null;
         using (var jsonReader = new JsonTextReader(new StringReader(json))) {
            do {
               jsonReader.Read();
               if (jsonReader.Value == null || !jsonReader.Value.Equals("gamestate")) continue;

               var parsable = new GameState();

               do {
                  jsonReader.Read();
               } while (!jsonReader.TokenType.Equals(JsonToken.PropertyName) &&
                        !jsonReader.TokenType.Equals(JsonToken.None));

               do {
                  Build(parsable, jsonReader);
                  jsonReader.Read();
               } while (!jsonReader.TokenType.Equals(JsonToken.None));
               return parsable;
            } while (!jsonReader.TokenType.Equals(JsonToken.None));
         }
         return null;
      }

      private static void Build(GameState state, JsonTextReader r) {
         var sb = new StringBuilder();
         do {
            if (r.Value != null) {
               if (r.Value.Equals("missiles")) {
                  r.Read(); // startarray
                  state.Missiles = new List<Weapon>();
                  do {
                     if (r.TokenType == JsonToken.StartObject) {
                        var m = new Weapon();
                        state.Missiles.Add(m);
                        r.Read();
                        do {
                           if (r.TokenType == JsonToken.PropertyName) {
                              if (m.Build(r)) { } else if (r.Value.Equals("owner")) {
                                 m.Owner = r.Consume<int>();
                              }
                           }
                           r.Read();
                        } while (r.TokenType != JsonToken.EndObject);
                     }
                     r.Read(); //endarray ?or=>
                  } while (r.TokenType != JsonToken.EndArray);
               } else if (r.Value.Equals("others")) {
                  r.Read(); // startarray
                  state.All = state.All ?? new List<Someone>();
                  do {
                     if (r.TokenType == JsonToken.StartObject) {
                        var m = new Someone();
                        state.All.Add(m);
                        r.Read();
                        do {
                           if (r.TokenType == JsonToken.PropertyName) {
                              m.Build(r);
                           }
                           r.Read();
                        } while (r.TokenType != JsonToken.EndObject);
                     }
                     r.Read(); //endarray ?or=>
                  } while (r.TokenType != JsonToken.EndArray);
               } else if (r.Value.Equals("you")) {
                  r.Read();
                  var you = new Someone();
                  do {
                     if (r.TokenType == JsonToken.PropertyName) {
                        you.Build(r);
                     }
                     r.Read();
                  } while (r.TokenType != JsonToken.EndObject);
                  state.All = state.All ?? new List<Someone>();
                  state.All.Add(you);
                  state.YouID = you.ID;
               }
            }
         } while (r.Read());
      }
   }

   public static class ExtM {
      public static double SqDistTo(this Pos e, Pos f) {
         if (e == null || f == null)
            return 666;
         var foo = new {
            x = e.X - f.X,
            y = e.Y - f.Y,
         };
         return foo.x*foo.x + foo.y*foo.y;
      }

      public static bool JOK(this object o, string name) {
         return o != null && o.Equals(name);
      }

      public static bool Build(this Entity e, JsonTextReader r) {
         if (r.Value.Equals("id"))
            e.ID = r.Consume<int>();
         else if (r.Value.Equals("rotation"))
            e.Rotation = C.DEG2RAD * r.Consume<int>();
         else if (r.Value.Equals("energy"))
            e.Energy = r.Consume<int>();
         else if (r.Value.Equals("velocityX"))
            e.VelocityX = r.Consume<double>();
         else if (r.Value.Equals("velocityY"))
            e.VelocityY = r.Consume<double>();
         else if (r.Value.Equals("x"))
            e.X = r.Consume<double>();
         else if (r.Value.Equals("y"))
            e.Y = r.Consume<double>();
         else
            return false;
         return true;
      }

      public static T Consume<T>(this JsonTextReader r) {
         r.Read();
         if (typeof(T) == typeof(int)) {
            return (T)(object)(int)(Int64)r.Value;
         }
         if (typeof(T) == typeof(double)) {
            if (r.ValueType == typeof(double)) {
               return (T)r.Value;
            }
            if (r.ValueType == typeof(int)) {
               return (T)(object)(double)(int)r.Value;
            }
            if (r.ValueType == typeof(Int64)) {
               return (T)(object)(double)(Int64)r.Value;
            }
         }
         return (T)r.Value;
      }
   }

   public static class C {
      public static XorShiftRandom RNG = new XorShiftRandom();
      public const double MISSILE_MAX_SPEED = 0.05;
      public const double MISSILE_MAX_SPEED_SQ = MISSILE_MAX_SPEED * MISSILE_MAX_SPEED;
      public const int ACCELERATION_COST = 2;
      public const double ACCELERATION_FORCE = 0.001;
      public const int MISSILE_COST = 10;
      public const int SEEKING_MISSILE_COST = 15;
      public const int MINE_COST = 20;
      public const int MISSILE_DAMAGE = 50;
      public const int ROTATE_COST = 1;
      public const double ROTATE_AMOUNT = 10d;
      public const double DEG2RAD = Math.PI / 180.0;
      public const double ROTATE_AMOUNT_RAD = ROTATE_AMOUNT * DEG2RAD;
      public const int START_ENERGY = 1000;
      public const double SUN_RADIUS = 0.1;
      public const double SUN_RADIUS_SQ = SUN_RADIUS * SUN_RADIUS;

      public static double rot(double ang) {
         while (ang < 0) ang += Math.PI * 2d;
         while (ang > 2d * Math.PI) ang -= Math.PI * 2d;
         return ang;
      }
   }
}
