//main functionality
var operations =  {
  LEFT: "LEFT", 
  SHOOT: "SHOOT",
  MINE: "MINE",
  WAIT: "WAIT",
  SHOOT2: "SHOOT2",
  RIGHT: "RIGHT"
};

var action;

function calcX(x) {
	return x + 1;
}

function calcY(y) {
	var y2 = y;
	if(y <= 0) {
		y2 *= -1;
		y2 += 1;
	} else {
		y2 = Math.abs(y - 1);
	}
	return y2;
}

function onMessage(jsonMessage) {
    if (jsonMessage.messagetype == "stateupdate") {
        var moves = [
            "LEFT\n",
            "RIGHT\n",
            "ACCELERATE\n",
            "MISSILE\n",
            "MINE\n",
            "SEEKING\n"
        ];
      
        var you = jsonMessage.gamestate.you;
      
        var shortestDist = -1;
        var shortestPlayer;
      
        var others = jsonMessage.gamestate.others;
        var othersAmount = others.length;
        var attackType = othersAmount / 2.5;
		
		var ourX = you.x;
		var ourY = you.y;
      
        ourX = calcX(ourX);
        ourY = calcY(ourY);
		
		
        for(i = 0; i < othersAmount; i++) {
         var distance; 
         
         var theirX;
         var theirY;
          
         theirX = calcX(others[i].x);
         theirY = calcY(others[i].y);
		 
          
          
          
         distance = Math.sqrt(Math.pow((Math.abs(ourX - theirX)), 2) + Math.pow((Math.abs(ourY - theirY)), 2));
         if(shortestDist == -1 || distance < shortestDist) {
           shortestDist = distance;
           shortestPlayer = others[i];
         }
        }
		
				 //console.log(theirX + " " + theirY + " - " + ourX + " " + ourY + "/" + shortestDist);

      
        var energy = you.energy;
        var attackRate = energy/2000;
      
      
      
        if(shortestDist < 2.6 && shortestDist != -1) {
          var angle = Math.atan2((-(calcY(shortestPlayer.y)) - (calcY(ourY))), (calcX(shortestPlayer.x)) - (calcX(ourX))) ;
		  
			  angle += Math.PI/2;
			  angle *= 180 / Math.PI;
		  if(angle < 0) {
			  angle += 360;
		  }
		  angle += 90;
		  angle = angle % 360;
		  
		  //angle = (angle) % 360;

          if(angle + 10 > you.rotation && angle - 10 < you.rotation){
            if(Math.random() < attackRate * 2) {
              if(shortestDist < 0.25) {
                action = operations.SHOOT2; } else {
              action = operations.SHOOT; } }
            else {
              action = operations.WAIT; }
          } else if (Math.abs(angle - (you.rotation))< 180 || Math.abs(Math.abs(angle - 360) - (you.rotation))< 180) {
            if(you.rotation > angle || Math.abs(you.rotation - 360) < angle) {
              action = operations.LEFT; }
            else {
              action = operations.RIGHT; }
          }
		           console.log(angle + " " + you.rotation + " " + action);

        } else {
          
          

        if(Math.random() < attackRate) {
          if(Math.random() < attackType) {
            action = operations.MINE;
            
          } else {
            action = operations.SHOOT;
          }
        } else {
          action = operations.WAIT;
        }
        }

        switch (action) {
          case operations.SHOOT:
            client.write(moves[5]);
            break;
          case operations.MINE:
            client.write(moves[4]);
            break;
          case operations.WAIT:
            //wait
            break;
          case operations.LEFT:
            client.write(moves[0]);
            break;
          case operations.RIGHT:
            client.write(moves[1]);
            break;
          case operations.SHOOT2:
            client.write(moves[3]);
            break;
            
        }
        
    } else if(jsonMessage.messagetype == "dead" || jsonMessage.messagetype == "endofround") {
      action = operations.WAIT;
  
    } 
}


/*
 * Basic connection stuff
 */

//vars

var net = require('net');
var HOST = '88.92.6.84';
var PORT = 54321;
var client = new net.Socket();

//start connection
client.connect(PORT, HOST);

client.on('connect', function()
{
    console.log('CONNECTED TO: ' + HOST + ':' + PORT);
    client.write('NAME NesciO_bot\n');
});

//log errors
client.on('error', function(data) {
    console.log('ERROR: ' + data);
    client.destroy();
});

//get incoming data
var buffer = new Buffer(0);
var buffer2 = new Buffer(0);
client.on('data', function(data) {
    var newdata = Buffer.concat([buffer, data]);
    buffer = parseBuffer(newdata, onMessage);
});



//parse incoming data
function parseBuffer(buffer, msgCallback) {
    var start = 0;

    while(start < buffer.length) {
        var endOfMsg = buffer.indexOf('\n', start) + 1;
        if(endOfMsg <= 0)
            break;

        msgCallback(JSON.parse(buffer.toString('utf-8', start, endOfMsg)));

        start = endOfMsg;
    }

    
    return buffer.slice(start, buffer.length);
}

//close
client.on('close', function(error) {
    client.destroy();
    if (error === true)
    {
        console.log("An error occured. Unexpected disconnect");
    } else {
        console.log("Disconnected.");
    }
});

