#!/usr/bin/python           # This is server.py file

import socket               # Import socket module
from random import random
from time import sleep
import json
import pprint
import math
import sys
import traceback
import time
import copy

host = "127.0.0.1" #socket.gethostname() # Get local machine name
port = 54321                # Reserve a port for your service.

MISSILE_MAX_SPEED = 0.05
MISSILE_START_ENERGY = 1000
MINE_START_ENERGY    = 5000


def get_rotation(rotation):

    if rotation < 0:
        rotation += math.pi * 2.0
    if rotation > (math.pi*2):
        rotation -= math.pi * 2.0

    return rotation

def plant_mine(jsondata):

    mine_x = jsondata['gamestate']['you']['x']
    mine_y = jsondata['gamestate']['you']['y']

    mine_energy = MINE_START_ENERGY
    mine_rotation = math.atan2(mine_y, mine_x)
    mine_rotation = get_rotation(mine_rotation)

    mine_vel_x = math.cos(mine_rotation) * 0.005
    mine_vel_y = math.sin(mine_rotation) * 0.005

    enemy_cunts = len(jsondata['gamestate']['others'])

    enemy_x = []
    enemy_y = []

    enemy_vel_x = []
    enemy_vel_y = []

    enemy_energy = []

    future_counter = 23 + jsondata['gamestate']['you']['energy']/42

    for i in range(0, enemy_cunts):

     enemy_x.append(jsondata['gamestate']['others'][i]['x'])
     enemy_y.append(jsondata['gamestate']['others'][i]['y'])

     enemy_vel_x.append(jsondata['gamestate']['others'][i]['velocityX'])
     enemy_vel_y.append(jsondata['gamestate']['others'][i]['velocityY'])

     enemy_energy.append(jsondata['gamestate']['others'][i]['energy'])

    while True:

     if future_counter <= 0:
      break

     future_counter -= 1

     mine_distance = math.hypot(mine_x, mine_y)
     if mine_distance < 0.1:
      break

     for i in range(0, enemy_cunts):

      if enemy_energy[i] <= 0:
       continue

      d_x = mine_x - enemy_x[i]
      d_y = mine_y - enemy_y[i]
      player_mine_dist = math.hypot(d_x, d_y)

      if player_mine_dist < 0.1:
       return True

      enemy_angle = math.atan2(enemy_y[i], enemy_x[i])
      enemy_distance = math.hypot(enemy_x[i], enemy_y[i])
      enemy_force = enemy_distance / enemy_energy[i]

      enemy_vel_x[i] -= math.cos(enemy_angle) * enemy_force
      enemy_vel_y[i] -= math.sin(enemy_angle) * enemy_force

      if enemy_vel_x[i] > 0.05:
       enemy_vel_x[i] = 0.05

      if enemy_vel_y[i] > 0.05:
       enemy_vel_y[i] = 0.05

      if enemy_vel_x[i] < -0.05:
       enemy_vel_x[i] = -0.05

      if enemy_vel_y[i] < -0.05:
       enemy_vel_y[i] = -0.05

      enemy_x[i] += enemy_vel_x[i]
      enemy_y[i] += enemy_vel_y[i]

      if enemy_x[i] > 1.0:
       enemy_x[i] = -1.0

      if enemy_y[i] > 1.0:
       enemy_y[i] = -1.0

      if enemy_x[i] < -1.0:
       enemy_x[i] = 1.0

      if enemy_y[i] < -1.0:
       enemy_y[i] = 1.0

      enemy_energy[i] = enemy_energy[i] - 5


     mine_velocityMagnitude = math.hypot(mine_vel_x, mine_vel_y)
     if mine_velocityMagnitude > MISSILE_MAX_SPEED:
         mine_velocityAngle = math.atan2(mine_vel_y, mine_vel_x)
         mine_vel_x = math.cos(mine_velocityAngle) * MISSILE_MAX_SPEED
         mine_vel_y = math.sin(mine_velocityAngle) * MISSILE_MAX_SPEED

     mine_force = mine_distance / 1000
     mine_angle = math.atan2(mine_y, mine_x)
     mine_vel_x -= math.cos(mine_angle) * mine_force
     mine_vel_y -= math.sin(mine_angle) * mine_force

     mine_x += mine_vel_x
     mine_y += mine_vel_y

     if mine_x > 1.0:
         mine_x = -1.0

     if mine_y > 1.0:
         mine_y = -1.0

     if mine_x < -1.0:
         mine_x = 1.0

     if mine_y < -1.0:
         mine_y = 1.0

     if mine_energy < 10:
      mine_vel_x /= 1.01
      mine_vel_y /= 1.01
      continue

     mine_vel_x += math.cos(mine_rotation) * 0.0005
     mine_vel_y += math.sin(mine_rotation) * 0.0005

     mine_energy -= 1

    return False

def missile_move(jsondata):

    missile_energy = MISSILE_START_ENERGY
    missile_rotation = (jsondata['gamestate']['you']['rotation']*math.pi)/180.0
    missile_rotation = get_rotation(missile_rotation)

    missile_vel_x = math.cos(missile_rotation) * 0.05
    missile_vel_y = math.sin(missile_rotation) * 0.05

    missile_x = jsondata['gamestate']['you']['x']
    missile_y = jsondata['gamestate']['you']['y']

    enemy_cunts_alive = 0
    enemy_cunts = len(jsondata['gamestate']['others'])

    enemy_x = []
    enemy_y = []

    enemy_vel_x = []
    enemy_vel_y = []

    enemy_energy = []

    future_counter = 10+jsondata['gamestate']['you']['energy']/30

    for i in range(0, enemy_cunts):

     enemy_x.append(jsondata['gamestate']['others'][i]['x'])
     enemy_y.append(jsondata['gamestate']['others'][i]['y'])

     enemy_vel_x.append(jsondata['gamestate']['others'][i]['velocityX'])
     enemy_vel_y.append(jsondata['gamestate']['others'][i]['velocityY'])

     enemy_energy.append(jsondata['gamestate']['others'][i]['energy'])



    while True:

        missile_distance = math.hypot(missile_x, missile_y)

        if future_counter <= 0:
            break

        future_counter -= 1

        if missile_distance < 0.1:
            break

        missile_velocityMagnitude = math.hypot(missile_vel_x, missile_vel_y)

        if(missile_velocityMagnitude > MISSILE_MAX_SPEED):
            missile_velocityAngle = math.atan2(missile_vel_y, missile_vel_x)
            missile_vel_x = math.cos(missile_velocityAngle) * MISSILE_MAX_SPEED
            missile_vel_y = math.sin(missile_velocityAngle) * MISSILE_MAX_SPEED

        missile_force = missile_distance / 1000
        missile_angle = math.atan2(missile_y, missile_x)
        missile_vel_x -= math.cos(missile_angle) * missile_force
        missile_vel_y -= math.sin(missile_angle) * missile_force

        missile_x += missile_vel_x
        missile_y += missile_vel_y

        if missile_x > 1.0:
            missile_x = -1.0
        if missile_y > 1.0:
            missile_y = -1.0
        if missile_x < -1.0:
            missile_x = 1.0
        if missile_y < -1.0:
            missile_y = 1.0

        missile_rotation = math.atan2(missile_vel_y, missile_vel_x)
        missile_rotation = get_rotation(missile_rotation)

        if missile_energy < 10:
         missile_vel_x /= 1.01
         missile_vel_y /= 1.01
        else:
         missile_energy -= 50
         missile_vel_x += math.cos(missile_rotation) * (missile_energy / 1000000.0)
         missile_vel_y += math.sin(missile_rotation) * (missile_energy / 1000000.0)

        for i in range(0, enemy_cunts):

         if enemy_energy[i] <= 0:
          continue

         d_x = missile_x - enemy_x[i]
         d_y = missile_y - enemy_y[i]
         player_rocket_dist = math.hypot(d_x, d_y)

         if player_rocket_dist < 0.1:
          return True

         enemy_angle = math.atan2(enemy_y[i], enemy_x[i])
         enemy_distance = math.hypot(enemy_x[i], enemy_y[i])
         enemy_force = enemy_distance / enemy_energy[i]

         enemy_vel_x[i] -= math.cos(enemy_angle) * enemy_force
         enemy_vel_y[i] -= math.sin(enemy_angle) * enemy_force

         if enemy_vel_x[i] > 0.05:
            enemy_vel_x[i] = 0.05

         if enemy_vel_y[i] > 0.05:
            enemy_vel_y[i] = 0.05

         if enemy_vel_x[i] < -0.05:
            enemy_vel_x[i] = -0.05

         if enemy_vel_y[i] < -0.05:
            enemy_vel_y[i] = -0.05

         enemy_x[i] += enemy_vel_x[i]
         enemy_y[i] += enemy_vel_y[i]

         if enemy_x[i] > 1.0:
             enemy_x[i] = -1.0

         if enemy_y[i] > 1.0:
             enemy_y[i] = -1.0

         if enemy_x[i] < -1.0:
             enemy_x[i] = 1.0

         if enemy_y[i] < -1.0:
             enemy_y[i] = 1.0

         enemy_energy[i] = enemy_energy[i] - 5


    return False




while True:
 try:
  s = socket.socket()         # Create a socket object
  s.connect((host, port))
  s.send(b"NAME niosHD\n")
  t1 = 0
  t3 = 0
  while True:
            data = s.recv(999999)

            try:
                jsondata = json.loads(data)
            except:
                pass
                #print data
                #print "json parse:", sys.exc_info()[0]
                #exit()

            if len(jsondata) != 2:
                continue

            me_x = jsondata['gamestate']['you']['x']
            me_y = jsondata['gamestate']['you']['y']
            me_angle = jsondata['gamestate']['you']['rotation']
            me_energy = jsondata['gamestate']['you']['energy']

            # find nearest enemy
            enemy_cunts =  len(jsondata['gamestate']['others'])
            players_dist = []
            for i in range(0, enemy_cunts):
                enemy_x = jsondata['gamestate']['others'][i]['x']
                enemy_y = jsondata['gamestate']['others'][i]['y']
                d_x = me_x - enemy_x
                d_y = me_y - enemy_y
                players_dist.append(math.hypot(d_x, d_y))

            nearest_dist = 2
            nearest_player = 0
            for i in range(0, enemy_cunts):
             if nearest_dist < players_dist[i]:
                 nearest_dist = players_dist[i]
                 nearest_player = i

            # X=AK, Y=GK
            diff_x = jsondata['gamestate']['others'][nearest_player]['x'] - me_x
            diff_y = jsondata['gamestate']['others'][nearest_player]['y'] - me_y

            me_vec_x = math.cos((me_angle*math.pi)/180.0)
            me_vec_y = math.sin((me_angle*math.pi)/180.0)

            oben = me_vec_x*diff_x + me_vec_y*diff_y
            unten = math.sqrt(me_vec_x*me_vec_x+me_vec_y*me_vec_y) * math.sqrt(diff_x*diff_x+diff_y*diff_y)

            angle_to_enemy = (math.acos(oben/unten)*180.0)/math.pi
            angle_diff = angle_to_enemy

            if plant_mine(jsondata):
             s.send(b"MINE\n")
             continue

            if missile_move(jsondata):
             s.send(b"MISSILE\n")
             continue

            if angle_diff > 5:
             s.send(b"RIGHT\n")
             continue

            if angle_diff < -5:
             s.send(b"LEFT\n")
             continue


  s.close
 except Exception, e:
  pass
  #print e
  #print "Unexpected error:", sys.exc_info()[0]
  #exit()