import socket
import json
from time import sleep
from numpy import sqrt, degrees, arctan2, cos, sin, radians


def main():
    s = socket.socket()
    s.connect((socket.gethostname(), 54321))
    s.send(b"NAME USS-LIBRTY\n")

    data = None
    while True:
        try:
            sleep(0.01)
            new_state = json.loads(s.recv(81820).decode().strip().split("\n")[-1])
            if new_state is not data and new_state.get("messagetype") == "stateupdate" and len(
                    new_state.get("gamestate", 0).get("others", 0)) > 0:
                data = new_state
                # DO SHIT HERE
                if viable_shot(data):
                    s.send(b"MISSILE\n")
                elif relative_angle_to_impact(data) < 180:
                    s.send(b"LEFT\n")
                elif relative_angle_to_impact(data) > 180:
                    s.send(b"RIGHT\n")
            else:
                continue
        except:
            print("Error occured. Is the game ready to accept connections?")


def scale(data, base=100):
    return base / distance_to_enemy(data) ** 2


def angular_scale(data):
    return 7 * (1 + distance_to_enemy(data))**(1.5)


def angle_to_impact(data):
    player_x, player_y = player_position(data)
    # enemy_x, enemy_y = enemy_position(data)
    # enemy_velocity_x, enemy_velocity_y = enemy_component_velocity(data)
    # impact_x = enemy_x + enemy_velocity_x * scale(data)
    # impact_y = enemy_y + enemy_velocity_y * scale(data)

    # Changed trajectory analysis from linear to angular.
    impact_x, impact_y = angular_impact_position(data)
    return relative_angle(player_x, player_y, impact_x, impact_y)


def angular_impact_position(data):
    impact_angle = enemy_angular_position(data) + enemy_angular_velocity(data) * angular_scale(data)
    impact_x = cos(radians(impact_angle)) * enemy_distance_to_sun(data)
    impact_y = sin(radians(impact_angle)) * enemy_distance_to_sun(data)
    return impact_x, impact_y


def viable_angle(data):
    return relative_angle_to_impact(data) < 7 or relative_angle_to_impact(data) > 358


def viable_shot(data):
    if not sun_obstructing(data) and viable_angle(data):
        return True
    else:
        return False


def sun_obstructing(data):
    a = distance_to_enemy(data) > player_distance_to_sun(data)
    b = relative_angle_to_sun(data) < 15 or relative_angle_to_sun(data) > 345
    if a and b:
        return True
    else:
        return False


def player_direction(data):
    player_velocity_x, player_velocity_y = player_velocity(data)
    return relative_angle(0, 0, player_velocity_x, player_velocity_y) % 360


def player_speed(data):
    player_velocity_x, player_velocity_y = player_velocity(data)
    return sqrt(player_velocity_x ** 2 + player_velocity_y ** 2)


def player_velocity(data):
    return data.get("gamestate").get("you").get("velocityX"), data.get("gamestate").get("you").get("velocityY")


def player_rotation(data):
    return data.get("gamestate").get("you").get("rotation")

def player_energy(data):
    return data.get("gamestate").get("you").get("energy")

def player_position(data):
    return data.get("gamestate").get("you").get("x"), data.get("gamestate").get("you").get("y")


def enemy_position(data):
    return data.get("gamestate").get("others")[0].get("x"), data.get("gamestate").get("others")[0].get("y")


def enemy_component_velocity(data):
    return data.get("gamestate").get("others")[0].get("velocityX"), data.get("gamestate").get("others")[0].get(
        "velocityY")


def enemy_angular_velocity(data):
    return degrees(enemy_speed(data) / enemy_distance_to_sun(data))


def enemy_angular_position(data):
    enemy_x, enemy_y = enemy_position(data)
    return degrees(arctan2(enemy_y, enemy_x)) % 360


def enemy_speed(data):
    enemy_velocity_x, enemy_velocity_y = enemy_component_velocity(data)
    return sqrt(enemy_velocity_x ** 2 + enemy_velocity_y ** 2)


def enemy_energy(data):
    return data.get("gamestate").get("others")[0].get("energy")


def enemy_distance_to_sun(data):
    enemy_x, enemy_y = enemy_position(data)
    return relative_distance(enemy_x, enemy_y, 0, 0)


def player_distance_to_sun(data):
    player_x, player_y = player_position(data)
    return relative_distance(player_x, player_y, 0, 0)


def relative_angle_to_sun(data):
    player_x, player_y = player_position(data)
    return (player_rotation(data) - relative_angle(player_x, player_y, 0, 0)) % 360


def distance_to_enemy(data):
    player_x, player_y = player_position(data)
    enemy_x, enemy_y = enemy_position(data)
    return relative_distance(player_x, player_y, enemy_x, enemy_y)


def relative_angle_to_impact(data):
    return (player_rotation(data) - angle_to_impact(data)) % 360


def relative_angle(x1, y1, x2, y2):
    return degrees(arctan2(y2 - y1, x2 - x1))


def relative_distance(x1, y1, x2, y2):
    return sqrt((x2 - x1) ** 2 + (y2 - y1) ** 2)


main()
