import json
import socket
import pprint
import datetime
import time
import sys
import asynchat
import math
# from coord import Coord

import logging
logging.basicConfig()
logger = logging.getLogger(__name__)


class GameConnector(asynchat.async_chat):
    handler_updateself = None
    handler_enemylist = None
    handler_endround = None
    handler_commandrequest = None
    handler_death = None

    sock = None
    ownName = None
    ownId = 0
    inputbuf = ""
    initing = True
    ppJson = True

    missileTypes = {'NORMAL': 1, 'MINE': 2, 'SEEKING': 3}

    def __init__(self, ownName):
        self.ownName = ownName
        self.received_data = []

        asynchat.async_chat.__init__(self)
        self.set_terminator("\n")
        self.create_socket(socket.AF_INET, socket.SOCK_STREAM)

    def startConnect(self, host, port):
        self.host = host
        self.port = port
        self.connect((host, port))

    def handle_connect(self):
        self.sendLine("JSON")
        self.sendLine("NAME " + self.ownName)

    def handle_close(self):
        sys.exit("Disconnected or unable to connect to {0}:{1}...".format(self.host, self.port))

    def collect_incoming_data(self, data):
        self.received_data.append(data)

    def found_terminator(self):
        self.parseLine(''.join(self.received_data))
        self.received_data = []

    def handleJSONPacket(self, packet):
        msgType = packet['messagetype']

        if self.ppJson:
            packet_json = "Packet:\n{0}".format(json.dumps(packet, indent=4))
            # print packet_json

        if(msgType == "dead"):
            self.handler_death()

        if(msgType == "endofround"):
            self.handler_endround()

        if(msgType == "stateupdate"):
            me = packet['gamestate']['you']
            enemies = packet['gamestate']['others']
            shells = packet['gamestate']['missiles']

            for shell in shells:
                shell['rotation'] = shell['rotation'] * (math.pi / 180)
                shell['stype'] = shell['type']
                shell['type'] = self.missileTypes[shell['type']]

            self.handler_updateself(me)
            self.handler_shelllist(shells)
            self.handler_enemylist(enemies)

            a = time.clock()
            cmd = self.handler_commandrequest()

            timeused = (time.clock() - a) * 1000
            print "Command request took: {0} ms".format(timeused)

            if cmd is not None:
                self.sendLine(cmd)

    def parseLine(self, line):
        # print "SERVER: |{0}|".format(line)

        try:
            packet = json.loads(line)
        except ValueError as e:
            print("Error decoding JSON packet: {0}\nJSON: {1}".format(e, line))
        except AttributeError as e:
            print("Invalid message: %s" % e)
        else:
            self.handleJSONPacket(packet)

    def sendLine(self, line):
        # print "CLIENT: |{0}|".format(line)
        self.push(line + "\n")
