import sys
sys.path.append("..")
sys.path.append("../py_simuli")

from optparse import OptionParser
from connector import GameConnector
from datetime import datetime
import simuli
import asyncore
import random
import json

# from coord import Coord
# from world import World
# from players import Players
# from mapwindow import MapWindow, MapWindowThread


class Bot(object):
    debug = False
    enableLog = True
    name = "zomgBot"
    gc = None
    missiles = []
    me = None
    frame = 0
    logfile = None

    missileTypes = {'NORMAL': 0, 'MINE': 1, 'SEEKING': 2}
    missileCost = {'NORMAL': 10, 'MINE': 20, 'SEEKING': 15}

    def __init__(self, host, port):
        self.host = host
        self.port = port

        self.gc = GameConnector(self.name)

        self.gc.handler_updateself = self.updateSelf
        self.gc.handler_enemylist = self.enemyList
        self.gc.handler_commandrequest = self.makeChoice
        self.gc.handler_shelllist = self.missileList
        self.gc.handler_endround = self.endOfRound
        self.gc.handler_death = self.death

        self.gc.startConnect(self.host, self.port)

        # self.world.debug = self.debug
        # self.world.setPlayers(self.players)

    def run(self):
        asyncore.loop()

    def missileList(self, missiles):
        if self.debug:
            print "Missiles: {0}\n".format(missiles)

        self.missiles = missiles
        # self.world.updateShells(shells)

    def convertPlayerToCFormat(self, objs, myself):
        if(isinstance(objs, list)):
            res = {}
            idx = int()
            for idx, obj in enumerate(objs):
                res[obj['id']] = self.getPlayerValues(obj)
            res[myself['id']] = self.getPlayerValues(myself)
            return res

        else:
            return self.getPlayerValues(objs)

    def getPlayerValues(self, obj):
        return [
            obj['id'],
            obj['energy'],
            obj['rotation'],
            obj['velocityX'],
            obj['velocityY'],
            obj['x'],
            obj['y']
        ]

    def convertMissileToCFormat(self, objs):
        if(isinstance(objs, list)):
            res = {}
            for idx, obj in enumerate(objs):
                res[str(idx)] = self.getMissileValues(obj)
            return res
        else:
            print "Not a list!! This is an error"
            return []

    def getMissileValues(self, obj):
        return [
            obj['owner'],
            obj['energy'],
            obj['rotation'],
            obj['type'],
            obj['velocityX'],
            obj['velocityY'],
            obj['x'],
            obj['y']
        ]

    def makeChoice(self):
        self.frame += 1

        if self.enableLog:
            self.writeState()

        if self.debug:
            print "Making a choice"

        energyDeployed = 0
        for m in self.missiles:
            if m['owner'] == self.me['id']:
                energyDeployed += self.missileCost[m['stype']]

        if energyDeployed > (self.me['energy'] * 0.9) and self.me['energy'] != 0:
            str = "{0} energy deployed out of my {1} energy, {2}% exceeds limit of 90%."
            print str.format(energyDeployed, self.me['energy'], round(100 * (float(energyDeployed) / float(self.me['energy'])), 1))
            return None
        # "Me: {0}".format(self.convertPlayerToCFormat(self.me))
        # "Enemies: {0}".format(self.convertPlayerToCFormat(self.enemies))

        TICKS = 40

        me_id = self.me["id"]

        allplayers = self.convertPlayerToCFormat(self.enemies, self.me)
        missiles = self.convertMissileToCFormat(self.missiles)

        simuli.Update(allplayers, missiles, self.gameId, self.frame)
        action = simuli.SimulateAggressive(me_id, self.missileTypes['NORMAL'], TICKS, 40)

        # if action > 0:
        #    currentCommand = 'MISSILE'
        # else:
        # currentCommand = random.choice([None])  # , 'RIGHT'
        currentCommand = action

        return currentCommand

    def writeState(self):
        if self.logfile is None:
            self.gameId = datetime.now().strftime("%Y%m%d%H%M%S")
            self.logfile = open('gamelogs/gamelog-{0}.log'.format(self.gameId), 'w')

        self.writeLogLine({'type': 'tick', 'tickno': self.frame})
        self.writeLogLine({'type': 'me', 'energy': self.me['energy'], 'id': self.me['id'], 'x': self.me['x'], 'y': self.me['y'], 'rot': self.me['rotation']})

        for enemy in self.enemies:
            self.writeLogLine({'type': 'enemy', 'energy': self.me['energy'], 'id': enemy['id'], 'x': enemy['x'], 'y': enemy['y'], 'rot': enemy['rotation']})

        for missile in self.missiles:
            self.writeLogLine({'type': missile['stype'], 'owner': missile['owner'], 'rot': missile['rotation'], 'x': missile['x'], 'y': missile['y']})

    def writeLogLine(self, data):
        self.logfile.write(json.dumps(data, separators=(',', ':')))
        self.logfile.write("\n")

    def enemyList(self, enemies):
        if self.debug:
            print "Enemies: {0}".format(enemies)

        self.enemies = enemies

    def death(self):
        if self.debug:
            print "You died"

    def endOfRound(self):
        if self.debug:
            print "Round is over"

        self.frame = 0
        if self.logfile is not None:
            self.logfile.close()

        simuli.EndRound()

        self.logfile = None

    def updateSelf(self, me):
        if self.debug:
            print "I am {0}\n".format(me)

        self.me = me

if __name__ == "__main__":
    parser = OptionParser()

    parser.add_option("-p", "--port", dest="port",
                      type="int", default=54321)

    parser.add_option("--host", dest="host",
                      type="string", default="localhost")

    (options, args) = parser.parse_args()

    bot = Bot(options.host, options.port)
    bot.run()
