/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.applet2.preloader.CancelException;
import com.sun.applet2.preloader.Preloader;
import com.sun.applet2.preloader.event.UserDeclinedEvent;
import com.sun.deploy.appcontext.AppContext;
import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.model.LocalApplicationProperties;
import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.net.JARSigningException;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.BlacklistedCerts;
import com.sun.deploy.security.BlockedDialog;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CertValidator;
import com.sun.deploy.security.DecisionTime;
import com.sun.deploy.security.DeniedCertStore;
import com.sun.deploy.security.DeployCertPathChecker;
import com.sun.deploy.security.DeployManifestChecker;
import com.sun.deploy.security.DeploySigningCertStore;
import com.sun.deploy.security.LazyRootStore;
import com.sun.deploy.security.RevocationCheckHelper;
import com.sun.deploy.security.RevocationChecker;
import com.sun.deploy.security.RootCertStore;
import com.sun.deploy.security.SandboxSecurity;
import com.sun.deploy.security.SessionCertStore;
import com.sun.deploy.security.UserDeclinedException;
import com.sun.deploy.security.ValidationState;
import com.sun.deploy.security.X509CertificateWrapper;
import com.sun.deploy.security.X509Util;
import com.sun.deploy.security.ruleset.BlockRule;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import com.sun.deploy.util.DeployLock;
import com.sun.deploy.util.JarUtil;
import com.sun.deploy.util.PerfLogger;
import com.sun.deploy.util.SecurityBaseline;
import com.sun.deploy.util.URLUtil;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Timestamp;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarFile;
import javax.security.auth.x500.X500Principal;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;
import sun.security.validator.ValidatorException;

public class TrustDecider {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    static final String ROOT_CA_NOT_VALID = "self-signed";
    private static CertStore rootStore = null;
    private static CertStore permanentStore = null;
    private static CertStore sandboxStore = null;
    private static CertStore sessionStore = null;
    private static CertStore sessionRevocationStore = null;
    private static CertStore sessionSandboxStore = null;
    private static CertStore sessionDRSStore = null;
    private static CertStore deniedStore = null;
    private static CertStore browserRootStore = null;
    private static CertStore browserTrustedStore = null;
    private static CertStore browserUntrustedStore = null;
    private static LazyRootStore lazyRootStore = null;
    private static X509CRL crl509 = null;
    private static boolean ocspValidConfig = false;
    private static String ocspSigner = null;
    private static String ocspURL = null;
    private static String revType = null;
    private static boolean crlCheck = false;
    private static boolean ocspCheck = false;
    private static DeployLock deployLock = null;
    private static String timeout = null;
    private static String clockSkew = null;
    public static final long PERMISSION_DENIED = 0L;
    public static final long PERMISSION_GRANTED_FOR_SESSION = 1L;
    public static final long PERMISSION_UNKNOWN = 2L;
    private static final String SUN_NAMESPACE = "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Sun Microsystems Inc";
    private static final String ORACLE_NAMESPACE = "OU=Java Signed Extensions,OU=Corporate Object Signing,O=Oracle Corporation";
    private static final String[] PRE_TRUSTED_NAMESPACES;
    private static final List preTrustList;
    private static boolean storesLoaded;
    private static boolean reloadDeniedStore;
    private static final String MAIN_JAR_FOUND = "true";

    protected static void grabDeployLock() throws InterruptedException {
        deployLock.lock();
    }

    protected static void releaseDeployLock() {
        try {
            deployLock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public static void resetDenyStore() {
        Trace.msgSecurityPrintln("trustdecider.check.reset.denystore");
        try {
            try {
                TrustDecider.grabDeployLock();
                deniedStore = new DeniedCertStore();
                reloadDeniedStore = true;
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            Object var2 = null;
        }
        catch (Throwable throwable) {
            Object var2_1 = null;
            TrustDecider.releaseDeployLock();
            throw throwable;
        }
        TrustDecider.releaseDeployLock();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void reset() {
        block12: {
            block11: {
                PerfLogger.setTime("Security: Start Reset call in TrustDecider class");
                try {
                    try {
                        TrustDecider.grabDeployLock();
                        storesLoaded = false;
                        rootStore = RootCertStore.getCertStore();
                        permanentStore = DeploySigningCertStore.getCertStore();
                        sandboxStore = DeploySigningCertStore.getSandboxCertStore();
                        sessionStore = new SessionCertStore("TrustDecider");
                        sessionRevocationStore = new SessionCertStore("Revocation");
                        sessionSandboxStore = new SessionCertStore("SandboxSecurity");
                        sessionDRSStore = new SessionCertStore("DeploymentRuleSet");
                        deniedStore = new DeniedCertStore();
                        if (Config.getBooleanProperty("deployment.security.browser.keystore.use")) {
                            Service service = ServiceManager.getService();
                            browserRootStore = service.getBrowserSigningRootCertStore();
                            browserTrustedStore = service.getBrowserTrustedCertStore();
                            browserUntrustedStore = service.getBrowserUntrustedCertStore();
                        }
                        try {
                            lazyRootStore = new LazyRootStore(browserRootStore, rootStore);
                        }
                        catch (Exception exception) {
                            Trace.ignored(exception);
                        }
                        revType = Config.getStringProperty("deployment.security.revocation.check");
                        if (revType.equals("NO_CHECK")) {
                            crlCheck = false;
                            ocspCheck = false;
                            Object var2_3 = null;
                            break block11;
                        }
                        timeout = Config.getStringProperty("deployment.security.validation.timeout");
                        clockSkew = Config.getStringProperty("deployment.security.validation.clockskew");
                        crlCheck = Config.getBooleanProperty("deployment.security.validation.crl");
                        if (crlCheck) {
                            crl509 = RevocationCheckHelper.retrieveCRL(Config.getStringProperty("deployment.security.validation.crl.url"));
                        }
                        if (!(ocspCheck = Config.getBooleanProperty("deployment.security.validation.ocsp"))) break block12;
                        ocspSigner = Config.getStringProperty("deployment.security.validation.ocsp.signer");
                        ocspURL = Config.getStringProperty("deployment.security.validation.ocsp.url");
                        if (ocspSigner != null && ocspSigner.length() > 0 && ocspURL != null && ocspURL.length() > 0) {
                            ocspValidConfig = true;
                        }
                        break block12;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                }
                catch (Throwable throwable) {
                    Object var2_5 = null;
                    TrustDecider.releaseDeployLock();
                    PerfLogger.setTime("Security: End Reset call in TrustDecider class");
                    throw throwable;
                }
            }
            TrustDecider.releaseDeployLock();
            PerfLogger.setTime("Security: End Reset call in TrustDecider class");
            return;
        }
        Object var2_4 = null;
        TrustDecider.releaseDeployLock();
        PerfLogger.setTime("Security: End Reset call in TrustDecider class");
    }

    static void notifyOnUserDeclined(Preloader preloader, String string) {
        if (preloader == null) {
            preloader = (Preloader)ToolkitStore.get().getAppContext().get("preloader_key");
        }
        try {
            if (preloader != null) {
                preloader.handleEvent(new UserDeclinedEvent(string));
            }
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
    }

    protected static List breakDownMultiSignerChains(Certificate[] certificateArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        ArrayList arrayList = new ArrayList();
        while (n2 < certificateArray.length) {
            ArrayList<Certificate> arrayList2 = new ArrayList<Certificate>();
            int n4 = n;
            while (n4 + 1 < certificateArray.length && certificateArray[n4] instanceof X509Certificate && certificateArray[n4 + 1] instanceof X509Certificate && CertUtils.isIssuerOf((X509Certificate)certificateArray[n4], (X509Certificate)certificateArray[n4 + 1])) {
                ++n4;
            }
            n2 = n4 + 1;
            for (int i = n; i < n2; ++i) {
                arrayList2.add(certificateArray[i]);
            }
            arrayList.add(arrayList2);
            n = n2;
            ++n3;
        }
        return arrayList;
    }

    private static boolean haveValidatorSupport() {
        if (Config.isJavaVersionAtLeast16()) {
            try {
                Class<?> clazz = Class.forName("sun.security.validator.Validator", true, ClassLoader.getSystemClassLoader());
                if (clazz != null) {
                    return true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                Trace.msgSecurityPrintln("trustdecider.check.validate.notfound");
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void validateChainForWarmup(X509Certificate[] x509CertificateArray, CodeSource codeSource, int n, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        try {
            try {
                TrustDecider.grabDeployLock();
                TrustDecider.ensureBasicStoresLoaded();
                long l = TrustDecider.validateChain(x509CertificateArray, codeSource, n, appInfo, deploymentRuleSet, null, true);
                Trace.println("Warmup validation completed (res=" + l + ")", TraceLevel.SECURITY);
            }
            catch (InterruptedException interruptedException) {
                Object var8_8 = null;
                TrustDecider.releaseDeployLock();
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            TrustDecider.releaseDeployLock();
            throw throwable;
        }
        TrustDecider.releaseDeployLock();
    }

    private static long validateChain(X509Certificate[] x509CertificateArray, CodeSource codeSource, int n, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader, boolean bl) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        boolean bl2 = deploymentRuleSet.isRevocationCheckBestEffort();
        boolean bl3 = deploymentRuleSet.isRuleRun();
        ValidationState validationState = TrustDecider.getValidationState(x509CertificateArray, codeSource, n, ValidationState.TYPE.ALL_PERMISSIONS, bl2, bl3, appInfo, deploymentRuleSet, bl);
        LocalApplicationProperties localApplicationProperties = Cache.getLocalApplicationProperties(appInfo.getLapURL());
        if (localApplicationProperties != null) {
            localApplicationProperties.storeMainPublisherAndTitle(validationState.getPublisher(), appInfo.getDisplayTitle());
        }
        if (bl3) {
            validationState.trustDecision = 1L;
            sessionDRSStore.add(x509CertificateArray[0], TrustDecider.getLocString(codeSource.getLocation(), appInfo), validationState.timeValid);
        }
        String string = null;
        SecurityException securityException = null;
        if (validationState.trustDecision == 2L) {
            if (!validationState.rootCAValid) {
                if (!deploymentRuleSet.isAskGrantSelfSignedSet()) {
                    string = "deployment.grant.notinca.never.text";
                } else if (SecurityBaseline.isExpired() && deploymentRuleSet.isSSVModeNever()) {
                    string = "deployment.ssv2.mode.never.selfsigned";
                }
            }
            if (string == null && !validationState.timeValid && deploymentRuleSet.isExpiredBlocked()) {
                string = "deployment.block.expired.text";
            }
            if (string == null && !deploymentRuleSet.isAskGrantShowSet()) {
                string = "deployment.grant.signed.never.text";
            }
        }
        if (string == null && validationState.trustDecision != 0L) {
            try {
                TrustDecider.checkMainJarManifest(deploymentRuleSet, codeSource.getLocation(), appInfo, true);
            }
            catch (SecurityException securityException2) {
                string = "deployment.blocked.permissions";
                securityException = securityException2;
            }
        }
        if (string != null) {
            String string2 = TrustDecider.getLocString(codeSource.getLocation(), appInfo);
            deniedStore.add(x509CertificateArray[0], string2, validationState.timeValid);
            deniedStore.save();
            BlockedDialog.show(appInfo, null, string, securityException, codeSource, deploymentRuleSet);
        }
        if (validationState.trustDecision == 2L) {
            if (DecisionTime.withinTime(codeSource.getLocation(), appInfo, x509CertificateArray[0], "ssv.decision.all-perms.time")) {
                validationState.trustDecision = 1L;
            } else {
                validationState.trustDecision = TrustDecider.askUser(x509CertificateArray, codeSource, validationState, appInfo, deploymentRuleSet, preloader);
                if (validationState.trustDecision == 1L && !Platform.get().isNativeSandbox()) {
                    DecisionTime.setTime(codeSource.getLocation(), appInfo, x509CertificateArray[0], "ssv.decision.all-perms.time");
                }
            }
        }
        return validationState.trustDecision;
    }

    static ValidationState getValidationState(X509Certificate[] x509CertificateArray, CodeSource codeSource, int n, ValidationState.TYPE tYPE, boolean bl, boolean bl2, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, boolean bl3) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, CRLException, InvalidAlgorithmParameterException {
        Object object;
        Object object2;
        X509Certificate x509Certificate;
        LazyRootStore.TrustedRootResult trustedRootResult;
        List<X509Certificate> list;
        int n2;
        PerfLogger.setTime("Security: begin getValidationState()");
        boolean bl4 = crlCheck;
        boolean bl5 = ocspCheck;
        String string = TrustDecider.getLocString(codeSource.getLocation(), appInfo);
        boolean[] blArray = new boolean[x509CertificateArray.length];
        ValidationState validationState = new ValidationState(tYPE);
        for (n2 = 0; n2 < x509CertificateArray.length; ++n2) {
            long l = x509CertificateArray[n2].getNotAfter().getTime();
            if (l < validationState.expirationDate) {
                validationState.expirationDate = l;
            }
            try {
                blArray[n2] = true;
                x509CertificateArray[n2].checkValidity();
                blArray[n2] = false;
                continue;
            }
            catch (CertificateExpiredException certificateExpiredException) {
                if (validationState.certExpiredException != null) continue;
                validationState.certExpiredException = certificateExpiredException;
                validationState.certValidity = -1;
                validationState.certValidityNoTS = -1;
                validationState.timeValid = false;
                continue;
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                if (validationState.certNotYetValidException != null) continue;
                validationState.certNotYetValidException = certificateNotYetValidException;
                validationState.certValidity = 1;
                validationState.certValidityNoTS = 1;
                validationState.timeValid = false;
            }
        }
        if (!validationState.timeValid) {
            validationState.timeStampInfo = TrustDecider.getTimeStampInfo(codeSource, n, x509CertificateArray, lazyRootStore);
            if (validationState.timeStampInfo != null) {
                validationState.timeValid = true;
                validationState.certValidity = 0;
            }
        }
        List<X509Certificate> list2 = list = (trustedRootResult = lazyRootStore.getTrustAnchors(x509Certificate = x509CertificateArray[(n2 = x509CertificateArray.length) - 1])) == null ? null : trustedRootResult.getMatchedCAList();
        if (list == null) {
            validationState.rootCAValid = false;
            TrustDecider.setSelfSignedUsage();
            list = new ArrayList<X509Certificate>();
            list.add(x509Certificate);
        }
        PerfLogger.setTime("Security: End replace CA check and start timestamp check");
        PKIXBuilderParameters pKIXBuilderParameters = null;
        X509Certificate[] x509CertificateArray2 = null;
        try {
            PerfLogger.setTime("Security: Start getting validator class");
            object2 = Validator.getInstance("PKIX", "plugin code signing", list);
            object = (PKIXValidator)object2;
            pKIXBuilderParameters = ((PKIXValidator)object).getParameters();
            pKIXBuilderParameters.addCertPathChecker(new DeployCertPathChecker((PKIXValidator)object));
            pKIXBuilderParameters.setDate(new Date());
            PerfLogger.setTime("Security: End getting validator class and start validator class");
            x509CertificateArray2 = new X509Certificate[n2];
            for (int i = 0; i < n2; ++i) {
                x509CertificateArray2[i] = new X509CertificateWrapper(x509CertificateArray[i]);
            }
            x509CertificateArray2 = ((Validator)object2).validate(x509CertificateArray2);
            PerfLogger.setTime("Security: End call validator class");
        }
        catch (CertificateException certificateException) {
            if (certificateException instanceof ValidatorException) {
                object = (ValidatorException)certificateException;
                if (ValidatorException.T_NO_TRUST_ANCHOR.equals(((ValidatorException)object).getErrorType())) {
                    validationState.rootCAValid = false;
                    TrustDecider.setSelfSignedUsage();
                }
                throw object;
            }
            throw certificateException;
        }
        PerfLogger.setTime("Security: End certificate validation and start blacklist and revocation check");
        if (validationState.rootCAValid) {
            validationState.setPublisher(CertUtils.extractSubjectAliasName(x509CertificateArray[0]));
        }
        if (validationState.type != ValidationState.TYPE.SPECIAL && !bl3) {
            TrustDecider.ensureAllJarEntriesSigned(codeSource.getLocation(), deploymentRuleSet);
        }
        if (sessionStore.contains(x509CertificateArray[0], string, validationState.timeValid) || validationState.type == ValidationState.TYPE.SANDBOX_PERMISSIONS && sessionSandboxStore.contains(x509CertificateArray[0], string, validationState.timeValid) || bl2 && sessionDRSStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validationState.trustDecision = 1L;
            return validationState;
        }
        object2 = new ArrayList<X509Certificate>(Arrays.asList(x509CertificateArray));
        if (list != null && validationState.rootCAValid) {
            object2.addAll(list);
        }
        object = object2.iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate2 = (X509Certificate)object.next();
            BlacklistedCerts.check(x509Certificate2);
            if (browserUntrustedStore == null || !browserUntrustedStore.contains(x509Certificate2)) continue;
            String string2 = ResourceManager.getMessage("security.dialog.unverified.signed.publisher");
            Trace.println(string2, TraceLevel.SECURITY);
            throw new CertificateException(string2);
        }
        if (!sessionRevocationStore.contains(x509CertificateArray[0], string, false)) {
            if (sessionRevocationStore.contains(x509CertificateArray[0], string, true)) {
                validationState.revStatusUnknown = true;
            } else if (!TrustDecider.willBlock(validationState, deploymentRuleSet)) {
                TrustDecider.checkRevocationStatus(bl5, bl4, x509CertificateArray2, pKIXBuilderParameters, validationState, bl, blArray);
                sessionRevocationStore.add(x509CertificateArray[0], string, validationState.revStatusUnknown);
                sessionRevocationStore.save();
            }
        }
        if (deniedStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validationState.trustDecision = 0L;
            return validationState;
        }
        if (!validationState.rootCAValid) {
            validationState.trustDecision = 2L;
            return validationState;
        }
        if (permanentStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validationState.trustDecision = validationState.expirationDate;
            sessionStore.add(x509CertificateArray[0], string, validationState.timeValid);
            sessionStore.save();
            return validationState;
        }
        if (validationState.type == ValidationState.TYPE.SANDBOX_PERMISSIONS && sandboxStore.contains(x509CertificateArray[0], string, validationState.timeValid)) {
            validationState.trustDecision = validationState.expirationDate;
            sessionSandboxStore.add(x509CertificateArray[0], string, validationState.timeValid);
            sessionSandboxStore.save();
            return validationState;
        }
        if (browserTrustedStore != null && browserTrustedStore.contains(x509CertificateArray[0])) {
            validationState.trustDecision = 1L;
            return validationState;
        }
        validationState.trustDecision = 2L;
        return validationState;
    }

    private static void ensureAllJarEntriesSigned(URL uRL, DeploymentRuleSet deploymentRuleSet) throws CertificateException {
        Object object;
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        int n = 2;
        if (resource != null) {
            object = resource.getJarFile();
            if (object != null) {
                try {
                    boolean bl;
                    if (JarUtil.isBlobSigned((JarFile)object)) {
                        return;
                    }
                    boolean bl2 = bl = deploymentRuleSet != null && deploymentRuleSet.skipMetaInfDirectory();
                    if (JarUtil.allJarEntriesSigned((JarFile)object, bl)) {
                        return;
                    }
                    n = 3;
                }
                catch (IOException iOException) {
                    throw new CertificateException(iOException.getMessage(), iOException);
                }
            } else {
                Trace.println("getJarFile() returned null from resource: " + resource, TraceLevel.SECURITY);
            }
        } else {
            Trace.println("Unable to retrieve resource from: " + uRL + ", " + string, TraceLevel.SECURITY);
        }
        object = new JARSigningException(uRL, string, n);
        Trace.ignored((Throwable)object);
        throw new CertificateException(((JARSigningException)object).getRealMessage(), (Throwable)object);
    }

    public static ValidationState getJarValidationState(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet) {
        return TrustDecider.getJarValidationState(codeSource, appInfo, ValidationState.TYPE.SPECIAL, deploymentRuleSet);
    }

    public static ValidationState getJarValidationState(CodeSource codeSource, AppInfo appInfo, ValidationState.TYPE tYPE, DeploymentRuleSet deploymentRuleSet) {
        Iterator iterator;
        X509Certificate[] x509CertificateArray = null;
        Certificate[] certificateArray = codeSource.getCertificates();
        if (certificateArray != null) {
            try {
                TrustDecider.ensureBasicStoresLoaded();
                List list = TrustDecider.breakDownMultiSignerChains(certificateArray);
                if (TrustDecider.haveValidatorSupport()) {
                    iterator = list.iterator();
                    if (iterator.hasNext()) {
                        List list2 = (List)iterator.next();
                        x509CertificateArray = list2.toArray(new X509Certificate[list2.size()]);
                        try {
                            return TrustDecider.getValidationState(x509CertificateArray, codeSource, 0, tYPE, true, false, appInfo, deploymentRuleSet, false);
                        }
                        catch (Exception exception) {
                            Trace.ignored(exception);
                        }
                    } else {
                        Trace.println("Canot validate certificate - unsigned", TraceLevel.SECURITY);
                    }
                } else {
                    Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                    rootStore.load();
                    if (browserRootStore != null) {
                        browserRootStore.load();
                    }
                    if (CertValidator.validate(codeSource, appInfo, certificateArray, list.size(), rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore, deploymentRuleSet)) {
                        ValidationState validationState = new ValidationState(tYPE);
                        validationState.rootCAValid = true;
                        return validationState;
                    }
                }
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        iterator = new ValidationState(tYPE);
        ((ValidationState)((Object)iterator)).trustDecision = 0L;
        return iterator;
    }

    public static boolean willBlock(ValidationState validationState, DeploymentRuleSet deploymentRuleSet) {
        if (!validationState.timeValid && (deploymentRuleSet == null || deploymentRuleSet.isExpiredBlocked())) {
            return true;
        }
        if (!validationState.rootCAValid && (deploymentRuleSet == null || deploymentRuleSet.isSSVModeNever() && SecurityBaseline.isExpired())) {
            return true;
        }
        switch (validationState.type) {
            case SANDBOX_PERMISSIONS: {
                return deploymentRuleSet == null || (validationState.rootCAValid ? deploymentRuleSet.isCaSignedNever() : deploymentRuleSet.isSelfSignedNever());
            }
            case ALL_PERMISSIONS: {
                return deploymentRuleSet == null || (validationState.rootCAValid ? !deploymentRuleSet.isAskGrantShowSet() : !deploymentRuleSet.isAskGrantSelfSignedSet());
            }
            case SPECIAL: {
                return !validationState.rootCAValid;
            }
        }
        return false;
    }

    private static void checkRevocationStatus(boolean bl, boolean bl2, X509Certificate[] x509CertificateArray, PKIXParameters pKIXParameters, ValidationState validationState, boolean bl3, boolean[] blArray) throws CertificateException {
        if (bl) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.on");
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.ocsp.off");
        }
        if (bl2) {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.on");
        } else {
            Trace.msgSecurityPrintln("trustdecider.check.validation.crl.off");
        }
        if (!bl && !bl2) {
            Trace.msgSecurityPrintln("Revocation check disabled");
            return;
        }
        if (!Config.isJavaVersionAtLeast17()) {
            Trace.msgSecurityPrintln("Revocation check skipped: Java version < 1.7");
            return;
        }
        if (x509CertificateArray.length < 2) {
            return;
        }
        X509Certificate x509Certificate = null;
        if (bl && ocspValidConfig) {
            try {
                lazyRootStore.containSubject(ocspSigner);
                x509Certificate = lazyRootStore.getOCSPCert();
            }
            catch (Exception exception) {
                Trace.ignored(exception);
            }
        }
        boolean bl4 = revType.equals("PUBLISHER_ONLY");
        X509Certificate x509Certificate2 = x509CertificateArray[x509CertificateArray.length - 1];
        RevocationChecker revocationChecker = new RevocationChecker(x509Certificate2, pKIXParameters, bl, bl2, ocspURL, x509Certificate, bl4, crl509, validationState.timeStampInfo, timeout, clockSkew);
        for (int i = x509CertificateArray.length - 2; i >= 0; --i) {
            X509Certificate x509Certificate3 = x509CertificateArray[i];
            try {
                revocationChecker.check(x509Certificate3, blArray[i]);
                continue;
            }
            catch (CertificateException certificateException) {
                if (certificateException instanceof RevocationChecker.StatusUnknownException && bl3) {
                    Trace.msgSecurityPrintln("Revocation Status Unknown");
                    Trace.ignored(certificateException);
                    validationState.revStatusUnknown = true;
                    continue;
                }
                throw certificateException;
            }
        }
        if (!validationState.revStatusUnknown) {
            Trace.msgSecurityPrintln("trustdecider.check.revocation.succeed");
        }
    }

    static boolean checkTrustedExtension(X509Certificate x509Certificate) {
        Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction");
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        String string = x500Principal.getName();
        for (String string2 : preTrustList) {
            if (!string.endsWith(string2)) continue;
            Trace.msgSecurityPrintln("trustdecider.check.trustextension.jurisdiction.found");
            return true;
        }
        return false;
    }

    private static long askUser(X509Certificate[] x509CertificateArray, CodeSource codeSource, ValidationState validationState, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) throws CertificateException, KeyStoreException, IOException, NoSuchAlgorithmException {
        String string = TrustDecider.getLocString(codeSource.getLocation(), appInfo);
        TrustDecider.releaseDeployLock();
        int n = X509Util.showSecurityDialog(x509CertificateArray, codeSource.getLocation(), 0, x509CertificateArray.length, !validationState.rootCAValid, validationState.certValidity, validationState.timeStampInfo, new AppInfo(appInfo), validationState.revStatusUnknown);
        try {
            TrustDecider.grabDeployLock();
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException("Intermediate error trying to perform security validation");
        }
        PerfLogger.setTime("Security: Start take action on security dialog box");
        if (n == 0) {
            Trace.msgSecurityPrintln("trustdecider.user.grant.session");
            sessionStore.add(x509CertificateArray[0], string, validationState.timeValid);
            sessionStore.save();
            validationState.trustDecision = 1L;
        } else if (n == 2) {
            Trace.msgSecurityPrintln("trustdecider.user.grant.forever");
            CertStore certStore = DeploySigningCertStore.getUserCertStore();
            certStore.load(true);
            if (certStore.add(x509CertificateArray[0], string, validationState.timeValid)) {
                certStore.save();
            }
            storesLoaded = false;
            validationState.trustDecision = validationState.expirationDate;
        } else {
            Trace.msgSecurityPrintln("trustdecider.user.deny");
            deniedStore.add(x509CertificateArray[0], string, validationState.timeValid);
            deniedStore.save();
            String string2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
            TrustDecider.notifyOnUserDeclined(preloader, string2);
            validationState.trustDecision = 0L;
        }
        PerfLogger.setTime("Security: End take action on security dialog box");
        return validationState.trustDecision;
    }

    protected static void recordSandboxAnswer(Certificate[] certificateArray, CodeSource codeSource, ValidationState validationState, Preloader preloader, int n, AppInfo appInfo) {
        boolean bl = false;
        try {
            String string = TrustDecider.getLocString(codeSource.getLocation(), appInfo);
            if (n == 0) {
                sessionSandboxStore.add(certificateArray[0], string, validationState.timeValid);
                sessionSandboxStore.save();
                validationState.trustDecision = 1L;
            } else if (n == 2) {
                sandboxStore.load(true);
                if (sandboxStore.add(certificateArray[0], string, validationState.timeValid)) {
                    sandboxStore.save();
                }
                validationState.trustDecision = validationState.expirationDate;
            } else {
                deniedStore.add(certificateArray[0], string, validationState.timeValid);
                deniedStore.save();
                bl = true;
                String string2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
                validationState.trustDecision = 0L;
                TrustDecider.notifyOnUserDeclined(preloader, string2);
            }
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        if (bl) {
            throw new UserDeclinedException("user declined to run signed sandbox app");
        }
    }

    protected static void ensureBasicStoresLoaded() throws InterruptedException, IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        if (reloadDeniedStore || !storesLoaded) {
            deniedStore.load();
            reloadDeniedStore = false;
        }
        if (storesLoaded) {
            return;
        }
        storesLoaded = true;
        PerfLogger.setTime("Security: Start loading JRE permanent certStore");
        permanentStore.load();
        sandboxStore.load();
        PerfLogger.setTime("Security: End loading JRE permanent certStore");
        sessionStore.load();
        sessionRevocationStore.load();
        sessionSandboxStore.load();
        sessionDRSStore.load();
        PerfLogger.setTime("Security: start loading browser Trust certStore");
        if (browserTrustedStore != null) {
            browserTrustedStore.load();
        }
        PerfLogger.setTime("Security: End loading browser Trust certStore");
        PerfLogger.setTime("Security: start loading browser Untrust certStore");
        if (browserUntrustedStore != null) {
            browserUntrustedStore.load();
        }
        PerfLogger.setTime("Security: End loading browser Untrust certStore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long isAllPermissionGranted(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        Config.getHooks().trackUsage(appInfo, deploymentRuleSet);
        boolean bl = true;
        try {
            long l = TrustDecider.isAllPermissionGrantedInt(codeSource, appInfo, deploymentRuleSet, preloader);
            bl = false;
            if (l == 0L) {
                Config.getHooks().confirmAppDenied(deploymentRuleSet);
            }
            long l2 = l;
            Object var10_7 = null;
            if (bl) {
                Config.getHooks().confirmAppBlocked(deploymentRuleSet);
            }
            return l2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var10_8 = null;
                if (!bl) break block4;
                Config.getHooks().confirmAppBlocked(deploymentRuleSet);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized long isAllPermissionGrantedInt(CodeSource codeSource, AppInfo appInfo, DeploymentRuleSet deploymentRuleSet, Preloader preloader) throws CertificateException, KeyStoreException, NoSuchAlgorithmException, IOException, CRLException, InvalidAlgorithmParameterException {
        long l;
        block22: {
            long l2;
            block21: {
                Certificate[] certificateArray;
                if (deploymentRuleSet.isRuleBlock()) {
                    certificateArray = "deployment.blocked.by.rule";
                    if (deploymentRuleSet instanceof BlockRule && ((BlockRule)deploymentRuleSet).isFromExceptionList()) {
                        certificateArray = "deployment.blocked.by.exception.list";
                    }
                    BlockedDialog.show(appInfo, deploymentRuleSet.getMessage(), (String)certificateArray, deploymentRuleSet.getException(), codeSource, deploymentRuleSet);
                }
                try {
                    try {
                        TrustDecider.grabDeployLock();
                        certificateArray = codeSource.getCertificates();
                        if (certificateArray == null) {
                            l2 = 0L;
                            Object var15_9 = null;
                            break block21;
                        }
                        try {
                            DeployManifestChecker.verify(deploymentRuleSet, codeSource.getLocation(), true, appInfo);
                        }
                        catch (SecurityException securityException) {
                            Trace.ignored(securityException);
                            BlockedDialog.show(appInfo, null, null, securityException, codeSource, deploymentRuleSet);
                        }
                        TrustDecider.ensureBasicStoresLoaded();
                        List list = TrustDecider.breakDownMultiSignerChains(certificateArray);
                        PerfLogger.setTime("Security: End break certificate chain");
                        if (TrustDecider.haveValidatorSupport()) {
                            List list2;
                            Trace.msgSecurityPrintln("trustdecider.check.validate.certpath.algorithm");
                            long l3 = 0L;
                            Iterator iterator = list.iterator();
                            int n = 0;
                            while (iterator.hasNext()) {
                                list2 = (List)iterator.next();
                                X509Certificate[] x509CertificateArray = list2.toArray(new X509Certificate[list2.size()]);
                                if (iterator.hasNext() && deploymentRuleSet.skipThisCertArray(x509CertificateArray)) {
                                    Trace.println("Skipping cert chain - using DRS run rule for differand cert hash", TraceLevel.RULESET);
                                } else {
                                    l3 = TrustDecider.validateChain(x509CertificateArray, codeSource, n, appInfo, deploymentRuleSet, preloader, false);
                                    if (l3 != 0L) {
                                        if (deploymentRuleSet.isRuleRun()) {
                                            SandboxSecurity.checkRunRuleMessage(deploymentRuleSet, codeSource.getLocation(), appInfo, x509CertificateArray[0]);
                                        }
                                        long l4 = l3;
                                        Object var15_10 = null;
                                        TrustDecider.releaseDeployLock();
                                        return l4;
                                    }
                                }
                                ++n;
                            }
                            if (l3 == 0L) {
                                list2 = codeSource.getLocation() != null ? codeSource.getLocation().toString() : null;
                                TrustDecider.notifyOnUserDeclined(preloader, (String)((Object)list2));
                            }
                        } else {
                            Trace.msgSecurityPrintln("trustdecider.check.validate.legacy.algorithm");
                            rootStore.load();
                            if (browserRootStore != null) {
                                browserRootStore.load();
                            }
                            if (CertValidator.validate(codeSource, appInfo, certificateArray, list.size(), rootStore, browserRootStore, browserTrustedStore, sessionStore, permanentStore, deniedStore, deploymentRuleSet)) {
                                if (deploymentRuleSet.isRuleRun()) {
                                    X509Certificate x509Certificate = certificateArray[0] instanceof X509Certificate ? (X509Certificate)certificateArray[0] : null;
                                    SandboxSecurity.checkRunRuleMessage(deploymentRuleSet, codeSource.getLocation(), appInfo, x509Certificate);
                                }
                                l = 1L;
                                break block22;
                            }
                        }
                        Object var15_12 = null;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException(interruptedException);
                    }
                    TrustDecider.releaseDeployLock();
                    return 0L;
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    TrustDecider.releaseDeployLock();
                    throw throwable;
                }
            }
            TrustDecider.releaseDeployLock();
            return l2;
        }
        Object var15_11 = null;
        TrustDecider.releaseDeployLock();
        return l;
    }

    private static boolean checkTSAPath(CertPath certPath, LazyRootStore lazyRootStore) {
        Trace.msgSecurityPrintln("trustdecider.check.timestamping.tsapath");
        List<? extends Certificate> list = certPath.getCertificates();
        X509Certificate[] x509CertificateArray = list.toArray(new X509Certificate[list.size()]);
        X509Certificate x509Certificate = x509CertificateArray[x509CertificateArray.length - 1];
        try {
            List<X509Certificate> list2;
            LazyRootStore.TrustedRootResult trustedRootResult = lazyRootStore.getTrustAnchors(x509Certificate);
            List<X509Certificate> list3 = list2 = trustedRootResult == null ? null : trustedRootResult.getMatchedCAList();
            if (list2 == null) {
                return false;
            }
            Validator validator = Validator.getInstance("PKIX", "tsa server", list2);
            validator.validate(x509CertificateArray);
            return true;
        }
        catch (CertificateException certificateException) {
            Trace.msgSecurityPrintln(certificateException.getMessage());
        }
        catch (IOException iOException) {
            Trace.msgSecurityPrintln(iOException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            Trace.msgSecurityPrintln(keyStoreException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Trace.msgSecurityPrintln(noSuchAlgorithmException.getMessage());
        }
        return false;
    }

    private static Date getTimeStampInfo(CodeSource codeSource, int n, X509Certificate[] x509CertificateArray, LazyRootStore lazyRootStore) {
        try {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.need");
            CodeSigner[] codeSignerArray = codeSource.getCodeSigners();
            Timestamp timestamp = codeSignerArray[n].getTimestamp();
            if (timestamp != null) {
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.yes");
                Date date = timestamp.getTimestamp();
                CertPath certPath = timestamp.getSignerCertPath();
                Date date2 = x509CertificateArray[0].getNotAfter();
                Date date3 = x509CertificateArray[0].getNotBefore();
                if (date.before(date2) && date.after(date3)) {
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.valid");
                    if (!TrustDecider.checkTSAPath(certPath, lazyRootStore)) {
                        Trace.msgSecurityPrintln("trustdecider.check.timestamping.notinca");
                        return null;
                    }
                    Trace.msgSecurityPrintln("trustdecider.check.timestamping.inca");
                    return date;
                }
                Trace.msgSecurityPrintln("trustdecider.check.timestamping.invalid");
                return null;
            }
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.no");
            return null;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Trace.msgSecurityPrintln("trustdecider.check.timestamping.notfound");
            return null;
        }
    }

    protected static String getLocString(URL uRL, AppInfo appInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = URLUtil.urlToLocation(uRL);
        if (string != null) {
            stringBuffer.append(string);
        }
        if (appInfo != null) {
            if (appInfo.getMainJNLP() != null) {
                stringBuffer.append("##jnlp:");
                stringBuffer.append(URLUtil.urlToLocation(appInfo.getMainJNLP()));
            }
            if (appInfo.getDocumentBase() != null) {
                stringBuffer.append("##docbase:");
                stringBuffer.append(URLUtil.urlToLocation(appInfo.getDocumentBase()));
            }
            if (appInfo.getFrom() != null) {
                stringBuffer.append("##from:");
                stringBuffer.append(URLUtil.urlToLocation(appInfo.getFrom()));
            }
        }
        return stringBuffer.toString();
    }

    private static void setSelfSignedUsage() {
        ToolkitStore.get().getAppContext().put(ROOT_CA_NOT_VALID, MAIN_JAR_FOUND);
    }

    protected static void checkMainJarManifest(DeploymentRuleSet deploymentRuleSet, URL uRL, AppInfo appInfo, boolean bl) {
        if (deploymentRuleSet.isPermissionsManifestRequired()) {
            AppContext appContext = ToolkitStore.get().getAppContext();
            String string = (String)appContext.get("deploy-main-class");
            String string2 = (String)appContext.get("deploy-" + uRL);
            if (string != null) {
                if (string.equals(MAIN_JAR_FOUND)) {
                    return;
                }
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(ResourceProvider.get().getCachedResourceFilePath(uRL, string2), false);
                }
                catch (IOException iOException) {
                    return;
                }
                if (jarFile != null) {
                    String string3;
                    if (string.endsWith(".class")) {
                        string = string.substring(0, string.length() - ".class".length());
                    }
                    if (jarFile.getJarEntry(string3 = string.replace('.', '/') + ".class") != null) {
                        Trace.println("Verifying permission attribute in main jar: " + uRL, TraceLevel.SECURITY);
                        DeployManifestChecker.verifyMainJar(deploymentRuleSet, uRL, bl, appInfo);
                        appContext.put("deploy-main-class", MAIN_JAR_FOUND);
                    } else {
                        Trace.println("Verified non-main jar: " + uRL, TraceLevel.SECURITY);
                    }
                } else {
                    throw new SecurityException("could not construct jar file for jar: " + uRL);
                }
            }
        }
    }

    static {
        deployLock = new DeployLock();
        TrustDecider.reset();
        PRE_TRUSTED_NAMESPACES = new String[]{SUN_NAMESPACE, ORACLE_NAMESPACE};
        preTrustList = Arrays.asList(PRE_TRUSTED_NAMESPACES);
        storesLoaded = false;
        reloadDeniedStore = false;
    }
}

