"use strict";
///////////////////////////////////////////////
//
//  Copyright 2016 David Gross
//  Not for distribution of modification of any kind without explicit written permission!
//
//  World/level stuff for the Cheese Harrier
//

var scores = new Array();
function score_toaster(num){
	this.num = num;
	this.life = 0;
}

var max_foods = 256;
var food_dist = 32; // Over this, the food is destroyed, and more is added to the level.



// Takes a serialized JSON of level.
function level(params){
	glevel = this;
	
	this.score = 0;
	
	this.drawables = new Array();
	this.actors = new Array();
	this.bullets = new Array();
	
	this.lastfruit = 0;
	
	
	this.badger_negative = 0;
	this.badger_fifd = 0;
	this.badger_seven = 0;
	this.badger_fruit = 0;
	this.badger_score = 0;
	this.badger_goodscore = 0;
	this.badger_f1 = 0;
	
	this.objective_text = ["Score points by cheesin' up some crackers.","The optimal score is five cheeses per cracker!"];
	
	// Do loop for objects
	// Do loop for actors
	// Other params need to be fleshed out.
}



level.prototype.postinit = function(){
	var a;
	for(a=0; a<max_foods; a+=1){
		this.lastfruit = !this.lastfruit;
		var f = new food(this.lastfruit);
		f.velx = (Math.random() - .5) * 0.0125;
		f.vely = (Math.random() - .5) * 0.0125;
		f.pos[0] = Math.random() * food_dist * 2 - food_dist;
		f.pos[1] = Math.random() * food_dist * 2 - food_dist;
		this.actors.push(f);
	}
}



var tmpasd = 0;

level.prototype.render = function(){
	var x;
	for(x in this.actors){
		this.actors[x].render();
	}
	
	for(x in this.bullets){
		this.bullets[x].render();
	}
	player.render();

}

/*level.prototype.getz = function(x,y){
	var tx = ((x + 1.5) / 3) | 0;
	var ty = ((y + 1.5) / 3) | 0;
	var xx = x - tx * 3;
	var yy = y - ty * 3;
	if(tx < 0 || ty < 0 || tx >= this.size[0] || ty >= this.size[1]) return null; // OOB
	var i = this.size[0] * ty + tx;
	
	if(i < 0 || i >= this.tiles.length) return null; // OOB
	
	
	// Todo:  Make it search more than one tile for a z-pos.
	if(this.tiles[i][0]){
		if(this.tiles[i][2]){
			var t = [xx,yy,0];
			vec3.transformMat4(t,t,tile_rot_mats[this.tiles[i][2]]);
			return this.tiles[i][0].testpos(t);
		}else{
			return this.tiles[i][0].testpos([xx,yy,0]);
		}
	}
	return null;
	
}/**/ // Keep code later, might be handy.

//Casts towards something by step, will return false if it goes under the terrain.
/*level.prototype.raycast = function(start,end,step){
	if(start == end) return true;
	
	
	var dist = dist2d(start[0],start[1],end[0],end[1]);
	dist = Math.ceil((dist * .999) / step) - 1;
	var dir = vec3.clone(end);
	vec3.sub(dir, dir, start);
	
	
	dir[0] /= dist;
	dir[1] /= dist;
	dir[2] /= dist;
	
	
	var p = vec3.clone(start);
	var a;
	for(a=0; a<dist; a+=1){
		vec3.add(p, p, dir);
		var t = this.getz(p[0], p[1]);
		if(t == null){
			return 0;
		}
		if(p[2] < t[0]) {
			return 0;
		}
	}
	
	return 1;
	
}/**/ // Keep code later, might be handy.



level.prototype.tick = function(){
	var a;
	player.tick();
	
	var score = this.score;
	this.score = 0;
	
	for(a in this.actors){
		this.score += this.actors[a].score();
		if(this.actors[a].tick()){
			this.actors.splice(a, 1);
		}
	}
	
	if(score != this.score){
		scores.push(new score_toaster(this.score - score));
		if(this.score > 250 && !this.badger_score){
			this.badger_score = 1;
			var b = new badger("models/badgerastro.png", rand_array(scoretxt));
			badgers.push(b);
		}
		if(this.score > 400 && !this.badger_goodscore){
			this.badger_goodscore = 1;
			var b = new badger("models/badgerhat.png", rand_array(goodscoretxt));
			badgers.push(b);
		}
	}
	
	//console.log(this.bullets);
	for(a in this.bullets){
		if(this.bullets[a].tick()){
			this.bullets.splice(a, 1);
		}
	}
	/*
	var x;
	for(x in this.actors){ // Lets push actors away from one another slightly.  SLOW.
		for(a in this.actors){
			var act = this.actors[a];
			if(a == 0) act = player;
			if(a > x || a == 0){ // Don't need to recheck 'em.
				var cs = this.actors[x].size + act.size;
				if(vec3.dist(this.actors[x].pos, act.pos) < cs){
					cs /= 5.0;
					if(cs < .2) cs = .2;
					var v = vec3.clone(act.pos);
					vec3.sub(v, v, this.actors[x].pos);
					vec3.normalize(v, v);
					v[0] *= cs;
					v[1] *= cs;
					v[2] = 0;
					act.move(v);
					v[0] *= -cs;
					v[1] *= -cs;
					this.actors[x].move(v);
				}
			}
		}
	}/**/
}







