/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;

public class DemoTG16
extends PApplet {
    Moonlander ml;
    boolean started = false;
    float counter = 0.0f;
    int WIDTH = 400;
    int HEIGHT = 400;
    int SPACE = 4;
    int NUM_SQUARES = this.WIDTH / (this.SPACE * 2);
    int WIDTH2 = 400;
    int HEIGHT2 = 400;
    int SPACE2 = 4;
    int NUM_SQUARES2 = this.WIDTH2 / (this.SPACE * 2);

    public void setup() {
        this.noCursor();
        this.ml = Moonlander.initWithSoundtrack((PApplet)this, (String)"Broke_For_Free_-_08_-_Living_In_Reverse.mp3", (int)120, (int)8);
        this.background(10);
        this.fill(255);
        this.textAlign(3);
        this.textSize(60.0f);
        this.text("LOADING ...", this.width / 2, this.height / 2);
    }

    public void draw() {
        this.ml.update();
        this.pushMatrix();
        double row = this.ml.getCurrentRow();
        if (row > 0.0 && row < 209.0) {
            this.drawScene1(row);
        } else if (row > 209.0 && row < 472.0) {
            this.drawScene2(row);
        } else if (row > 472.0 && row < 624.0) {
            this.drawScene3(row);
        } else if (row > 624.0 && row < 750.0) {
            this.drawScene4(row);
        } else if (row > 750.0 && row < 820.0) {
            DemoTG16.println((double)this.ml.getCurrentTime());
            this.drawEnd(row);
        } else if (row > 820.0 && row < 84.0) {
            this.exit();
        }
        this.popMatrix();
        if ((float)this.ml.getValue("my_track") > 0.0f) {
            this.pushMatrix();
            this.translate(0.0f, 0.0f);
            this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("my_track"));
            this.rect(0.0f, 0.0f, this.width, this.height);
            this.popMatrix();
        }
        if (!this.started) {
            this.delay(1000);
            this.ml.start();
            this.started = true;
        }
        if (this.keyPressed && this.key == '\u001b') {
            this.exit();
        }
    }

    public void drawScene1(double row) {
        this.translate(this.width / 2, this.height / 2);
        this.background(20);
        this.noStroke();
        this.pushMatrix();
        float angle = DemoTG16.radians((float)((float)this.ml.getCurrentTime() * 15.0f));
        float x = DemoTG16.cos((float)angle) * 10.0f;
        float y = DemoTG16.sin((float)angle) * 10.0f;
        int i = 0;
        while (i < 16) {
            this.strokeWeight(10.0f);
            this.rotate(angle);
            float receivedValue = DemoTG16.norm((float)x, (float)-10.0f, (float)10.0f);
            receivedValue = DemoTG16.norm((float)i, (float)0.0f, (float)16.0f);
            float c = DemoTG16.map((float)receivedValue, (float)0.0f, (float)1.0f, (float)0.0f, (float)360.0f);
            if (i % 2 == 1) {
                this.fill(this.HSL2RGB(c, 1.0f, 0.7f));
            } else {
                this.fill(this.HSL2RGB(c, 1.0f, 0.7f));
            }
            this.scale((float)this.ml.getValue("scale"));
            float something = (float)this.ml.getValue("i");
            if (row < 26.0) {
                this.ellipse(x * 15.0f, y * 15.0f, x * 25.0f, y * 25.0f);
            } else {
                this.ellipse(x * 15.0f, y * 15.0f, something * 25.0f, something * 25.0f);
            }
            ++i;
        }
        this.popMatrix();
        this.textSize(64.0f);
        this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("alpha"));
        this.textAlign(3);
        if (row >= 30.0 && row < 90.0) {
            this.text("\u2764 Hello, The Gathering 2016 \u2764", x * 20.0f, 450.0f);
        } else if (row >= 90.0 && row < 130.0) {
            this.text("3D demos?", x * 20.0f, 450.0f);
        } else if (row > 130.0 && row < 170.0) {
            this.text("Pfft! 2d is love, 2d is life", x * 20.0f, 450.0f);
        }
    }

    public void drawScene2(double row) {
        this.background(20);
        this.strokeWeight(2.0f);
        this.translate(600.0f, this.height / 2);
        if (row > 220.0 && row < 272.0) {
            this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("alpha"));
            this.textSize(32.0f);
            this.text("Code & GFX by", 0.0f, 0.0f);
        }
        if (row > 220.0 && row < 272.0) {
            this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("track_name"));
            this.textSize(80.0f);
            this.textAlign(39);
            this.text("_tor", 0.0f, 70.0f);
        }
        if (row > 272.0 && row < 320.0) {
            this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("alpha"));
            this.textSize(32.0f);
            this.text("Music by", 0.0f, 0.0f);
        }
        if (row > 272.0 && row < 320.0) {
            this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("track_name"));
            this.textSize(80.0f);
            this.textAlign(39);
            this.text("Broke For Free", 0.0f, 70.0f);
            this.textSize(32.0f);
            this.text("(CC BY 3.0)", 0.0f, 102.0f);
        }
        this.translate(0.0f, 0.0f);
        this.translate((float)((this.width - 1000) / 2) + (float)this.ml.getValue("i"), 0.0f);
        int x = -8;
        while (x <= 8) {
            int y = -8;
            while (y <= 8) {
                this.fill(0);
                this.pushMatrix();
                this.translate(x * 40, y * 40);
                this.rotate(DemoTG16.cos((float)DemoTG16.radians((float)((float)(y * x * -5) + (float)this.ml.getCurrentTime() * 75.0f))));
                this.noStroke();
                this.stroke(0);
                DemoTG16.abs((float)DemoTG16.map((float)DemoTG16.sin((float)DemoTG16.radians((float)((float)(x * y) + (float)this.ml.getCurrentTime() * 75.0f / 100.0f))), (float)-1.0f, (float)1.0f, (float)1.0f, (float)360.0f));
                float i = DemoTG16.sin((float)((float)row * (float)x / 50.0f));
                float receivedValue = DemoTG16.norm((float)i, (float)-1.0f, (float)1.0f);
                float c = DemoTG16.map((float)receivedValue, (float)0.0f, (float)1.0f, (float)0.0f, (float)360.0f);
                this.fill(this.HSL2RGB(c, 1.0f, 0.7f));
                if (row > 335.0) {
                    float scale = (float)this.ml.getValue("scale");
                    this.scale(DemoTG16.sin((float)DemoTG16.radians((float)(x * y))) * ((float)row / 100.0f) * scale);
                } else {
                    this.scale(1.0f);
                }
                this.ellipse(-40.0f, -40.0f, 20.0f, 20.0f);
                this.popMatrix();
                ++y;
            }
            ++x;
        }
    }

    public void drawScene3(double row) {
        this.background(20);
        this.translate(this.width / 2, this.height / 2);
        this.strokeWeight(1.0f);
        this.pushMatrix();
        float fck = (float)this.ml.getValue("scale") * 1.0f;
        if (fck == 0.0f) {
            fck = 1.0f;
        }
        this.scale(fck);
        int i = 1;
        while (i < 50) {
            this.rotate(this.counter);
            this.fill(255);
            float x = DemoTG16.sin((float)((float)row * (float)i * 0.005f));
            float receivedValue = DemoTG16.norm((float)x, (float)-1.0f, (float)1.0f);
            float c = DemoTG16.map((float)receivedValue, (float)0.0f, (float)1.0f, (float)0.0f, (float)360.0f);
            this.fill(this.HSL2RGB(c, 1.0f, 0.75f));
            this.rect(i * 2, i * 2, this.WIDTH - i * this.SPACE * 2, this.HEIGHT - i * this.SPACE * 2);
            ++i;
        }
        this.popMatrix();
        if (row > 520.0 & row < 560.0) {
            this.pushMatrix();
            this.fill(255.0f, 255.0f, 255.0f, (float)this.ml.getValue("alpha"));
            this.rotate(0.0f);
            this.textSize(80.0f);
            this.textAlign(3);
            float xPos = 0.0f;
            xPos = row < 545.0 ? DemoTG16.sin((float)((float)row)) * 40.0f : 0.0f;
            this.text("Greetings to everyone", xPos, -400.0f);
            this.popMatrix();
        }
        this.counter = (float)this.ml.getValue("myTrack") * 0.8f;
    }

    public void drawScene4(double row) {
        this.background(20);
        this.translate(this.width / 2 - 1200, this.height / 2 - 800);
        this.noStroke();
        this.scale(6.0f);
        this.pushMatrix();
        int i = 1;
        while (i < this.NUM_SQUARES2) {
            float x = DemoTG16.sin((float)((float)row * (float)i * 0.006f));
            float receivedValue = DemoTG16.norm((float)x, (float)-1.0f, (float)1.0f);
            float c = DemoTG16.map((float)receivedValue, (float)0.0f, (float)1.0f, (float)0.0f, (float)360.0f);
            this.fill(this.HSL2RGB(c, DemoTG16.map((float)i, (float)0.0f, (float)this.NUM_SQUARES2, (float)0.0f, (float)1.0f), 0.75f), DemoTG16.map((float)(i * i), (float)0.0f, (float)this.NUM_SQUARES2, (float)0.0f, (float)255.0f));
            this.rect(i * 2, i * 2, this.WIDTH2 - i * this.SPACE * 2, this.HEIGHT2 - i * this.SPACE2 * 2);
            ++i;
        }
        this.popMatrix();
    }

    public void drawEnd(double row) {
        this.translate(this.width / 2, this.height / 2);
        this.background(20);
        this.fill(255);
        this.textSize(32.0f);
        this.text("Thanks for watching!\nUntil next year I shall learn more about graphics programming!", DemoTG16.sin((float)((float)row * 0.5f)) * 40.0f * 0.5f, DemoTG16.cos((float)((float)row * 0.5f)) * 40.0f * 0.5f);
    }

    public int HSL2RGB(float hue, float sat, float lum) {
        float red = lum;
        float green = lum;
        float blue = lum;
        float v = lum <= 0.5f ? lum * (1.0f + sat) : lum + sat - lum * sat;
        float m = lum + lum - v;
        float sv = (v - m) / v;
        int sextant = DemoTG16.floor((float)(hue /= 60.0f));
        float fract = hue - (float)sextant;
        float vsf = v * sv * fract;
        float mid1 = m + vsf;
        float mid2 = v - vsf;
        if (v > 0.0f) {
            switch (sextant) {
                case 0: {
                    red = v;
                    green = mid1;
                    blue = m;
                    break;
                }
                case 1: {
                    red = mid2;
                    green = v;
                    blue = m;
                    break;
                }
                case 2: {
                    red = m;
                    green = v;
                    blue = mid1;
                    break;
                }
                case 3: {
                    red = m;
                    green = mid2;
                    blue = v;
                    break;
                }
                case 4: {
                    red = mid1;
                    green = m;
                    blue = v;
                    break;
                }
                case 5: {
                    red = v;
                    green = m;
                    blue = mid2;
                }
            }
        }
        return this.color(red * 255.0f, green * 255.0f, blue * 255.0f);
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"DemoTG16"};
        if (passedArgs != null) {
            PApplet.main((String[])DemoTG16.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

