#version 130
varying vec2 tCoord;
varying vec4 pos;
varying float distPosToCam;
uniform sampler2D iChannel0;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform vec3 cameraPosition;

#define MAX_STEPS 512.
#define MAX_DISTANCE 2.4
#define epsilon 0.0001
#define infinite 1e7
#define lightSize 0.2
#define powLight 5.
#define lightColor vec3(1.0,0.9,0.8)
vec3 lightSource = vec3(12.0, 7.0, 0.0);

mat3 rotationMatrix(vec3 axis, float angle) {
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}
float rand(float co){
    return rand(vec2(co));
}
float smin( float a, float b, float k ) {
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float udRoundBox( vec3 p, vec3 b, float r ) {
  return length(max(abs(p)-b,0.0))-r;
}
float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}
float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}
float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    q=q.zxy;
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}

float length2( vec2 p ) {
    return sqrt( p.x*p.x + p.y*p.y );
}

float length6( vec2 p ) {
    p = p*p*p; p = p*p;
    return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p ) {
    p = p*p; p = p*p; p = p*p;
    return pow( p.x + p.y, 1.0/8.0 );
}
float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdTorus82( vec3 p, vec2 t )
{
  vec2 q = vec2(length2(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}
float sdCappedCylinder( vec3 p, vec2 h )
{
  vec2 d = abs(vec2(length(p.xz),p.y)) - h;
  return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}
float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
mat3 rotY(in float a)
{
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}

mat2 rotate(float Angle)
{
    mat2 rotation = mat2(
        vec2( cos(Angle),  sin(Angle)),
        vec2(-sin(Angle),  cos(Angle))
    );
    return rotation;
}

vec2 hash( vec2 p )
{
    p = vec2( dot(p,vec2(127.1,311.7)),
              dot(p,vec2(269.5,183.3)) );

    return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

    vec2 i = floor( p + (p.x+p.y)*K1 );
    
    vec2 a = p - i + (i.x+i.y)*K2;
    vec2 o = (a.x>a.y) ? vec2(1.0,0.0) : vec2(0.0,1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
    vec2 b = a - o + K2;
    vec2 c = a - 1.0 + 2.0*K2;

    vec3 h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );

    vec3 n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));

    return dot( n, vec3(70.0) );
    
}
float getColorReflection( vec3 position, out vec3 color, out float reflectiveValue) {

    vec3 _position = position;
    float dist = 1e8;
    dist = min(dist,sdBox(_position,vec3(.1)));
    
    
    color = vec3(1.);
    reflectiveValue = 0.6;
    
    
    return dist;
}
float getDistance( in vec3 position) {
    vec3 _position = position;
    vec3 c;
    float r;
    return getColorReflection(_position, c, r);
}

vec3 getSurfaceNormal(vec3 position) {
    float e=epsilon;
    vec3 normalVector = vec3(
                            getDistance(position+vec3( e,  0., 0.)) - getDistance(position+vec3(  -e,   0.,  0.)) ,
                            getDistance(position+vec3( 0., e,  0.)) - getDistance(position+vec3(   0., -e,   0.)) ,
                            getDistance(position+vec3( 0., 0., e)) - getDistance(position+vec3(    0.,  0., -e)) );
    normalVector = normalize(normalVector);
    return normalVector;
}
float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource, float raylightdist){

    vec3 ro = rayPosition;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.3;
    float k = distance(lightSource, rayPosition)/4.;
    float res = 1.0;
    for( int i=0; i<11; i++ )
    {
        float h = getDistance(ro + rd*t);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.01) break;
    }
    return clamp(res,0.07,9.0);
}
float getSurfaceColor( vec3 curPosition, vec3 normalVector, vec3 lightSource, vec3 lightDirection) {
    float intensity = lightSize * pow( 0.001 + max(0.0, dot( lightDirection, normalVector)),  powLight);
    intensity = lightSize * pow( intensity / distance( curPosition, lightSource),  powLight);
    intensity += pow (max( dot( normalize( lightSource - curPosition), normalVector), 0.0), powLight);
    return intensity;
}

vec3 AO(vec3 rayOrigin, vec3 rayDirection) {
    float AO = 0.0;
    for(float i=1.0; i<4.0; i++) {
        vec3 position =  rayOrigin + i * 0.1 * rayDirection;
        AO += getDistance( position);
    }
    return vec3(AO);
}

vec4 march(vec3 rayOrigin, vec3 rayDirection) {
     vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec3 origRayDirection=rayDirection;
    vec3 endColorResult = vec3(0.0);
    vec3 prevPosition = rayOrigin;
    vec3 curPosition = rayOrigin ;
    vec3 normalVector;
    vec4 result=vec4( 0., 0., 0., 0.);
    vec3 finalLight = vec3(0.0);
    float dist = 0.0;
    float storeColorStrength = 1.0;
    int hit = 0;
    float collisions = 0.;
    float distanceOfCollision = 1111110.;
    
    
    float distanceOfFirstHit = 0.;
    
    
        for(float i = 0.; i < MAX_STEPS; i++) {
            float R = 0.0;
            vec3 color = vec3( 0.0);
            float stepable = getColorReflection( curPosition, color, R);
            dist += stepable;
            curPosition = prevPosition + dist * rayDirection;
            float browse = dist * 100.;
           /*too far from begining point, call it an end*/
            if( abs( stepable) < epsilon ) {
                //if( reflection == 0.) {
                //    distanceOfCollision = distance(rayOrigin, curPosition);
                //}
                normalVector = getSurfaceNormal( curPosition);
                
                float raylightdist = distance( curPosition, lightSource);
                float light = traceToLight( curPosition, normalVector, lightSource, raylightdist);
                vec3 lightDirection = normalize( lightSource - curPosition);
                lightDirection = normalize(lightDirection);
                float directLight = dot(normalVector, lightDirection);
                finalLight += light * max( lightSize * directLight,0.01);
                float surfaceBrightness = length(finalLight);
                vec3 lightColorInside = color + finalLight * lightColor;
               
                vec3 surfaceFinalColor = color * lightColor * storeColorStrength * finalLight;
                
                float surfLight = getSurfaceColor(curPosition, normalVector, lightSource, lightDirection);
                            

                endColorResult += (lightColor + color)/2. * storeColorStrength * pow(max(dot(normalize(lightSource-curPosition),normalVector),0.0),powLight);
                endColorResult += storeColorStrength * ( surfaceFinalColor) / (1.0+surfLight);
                endColorResult += storeColorStrength * ( surfaceFinalColor) * pow(lightColor,vec3(powLight))/ (1.0+surfLight+pow(distance(curPosition,lightSource),2.) ) ;
                endColorResult += storeColorStrength * ( surfaceFinalColor) * ( (surfLight) ) * R * surfaceFinalColor ;
               
                //endColorResult += 0.32*storeColorStrength * ( surfaceFinalColor) * giTrace(curPosition, normalVector) ;
               
                vec3 AOresult = log(AO(curPosition, normalVector)) ;
                endColorResult += storeColorStrength * AOresult /(1.0+surfLight);
                if(collisions==0.) {
                    distanceOfFirstHit = dist/32.;
                }
                collisions++;
                storeColorStrength *= R;
                hit = 1;
                dist = 0.0;
                prevPosition = curPosition + normalVector*0.001;
                curPosition = prevPosition;
                rayDirection = normalize(reflect(rayDirection, -normalVector));
                if(R<0.5)
                    break;
                else
                    hit=0;
            }
            /*too far from begining  point, call it an end*/
            if( length( curPosition  ) > MAX_DISTANCE) {
                break;
            }
    }
    
    
    
    if(hit==0 && collisions == 0.) distanceOfFirstHit = 0.3;
    
    vec3 lightDir = (lightSource-rayOrigin);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    vec3 backdrop=min(max( pow(directLight,40.0) * vec3(1.8,1.1,.9) * 0.2, 0.01),1.);
    backdrop+=min(max( pow(directLight,2.0) * vec3(0.8,0.9,1.0) * 1.6, 0.01),1.);
    backdrop+=min(max( pow(directLight,80.0) * 1.6, 0.01),1.);
    
    
    vec3 farShoot=rayOrigin+origRayDirection*10.;
    backdrop*=min(max(farShoot.y+0.5,0.),1.);
    if(distance(curPosition,lightSource) < distance(rayOrigin,lightSource)) endColorResult += backdrop ;
    endColorResult = max(endColorResult,vec3(0.0));
    return vec4( endColorResult, distanceOfFirstHit);
}

vec4 render( vec2 uv ) {  
     float aspect = iResolution.x / iResolution.y;
        float fov = 2. * atan( tan( 45. / 2. ));
        vec3 cameraPosition = vec3( 0.0, 0.0, 2.);
        float T=iGlobalTime*0.2;
        vec3 direction = normalize( vec3(.5 * uv * vec2( aspect, 1.0), fov) );
        direction *= rotationMatrix(vec3(1.0,0.0,0.0),.0);
        cameraPosition *= rotationMatrix(vec3(0.0,1.0,0.0),-iGlobalTime);
        direction *= rotationMatrix(vec3(0.0,1.0,0.0), iGlobalTime);
        direction.z *= -1.0;
    
        vec4 color = march( cameraPosition, direction);

        return color;
        
}

void main( ) {  
    vec2 p = gl_FragCoord.xy / iResolution.xy;
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.y / iResolution.x;
    if (  length(uv.y)*2.>aspect ){
        discard;
    } else {
        vec4 C=render( uv );
        gl_FragColor =  vec4(C.rgb,1.) +  texture2D( iChannel0, p );
    }
}
    