from drawingutils import SmartBuffer
import time
import win32api
import multiprocessing
from globals import *
from effects import *
from devices import Excel
import os 


def getSushiEffect(waithWith3D):
    sushiRotator = SushiRotator(EXCEL_MAX_X, EXCEL_MAX_Y)
    SUSHI_WIDTH, SUSHI_HEIGHT = 120, 80
    SCALE = 1 # currently copying the background fails!
    sushi3D = SushiCPP(0.3, SUSHI_WIDTH, SUSHI_HEIGHT, scale=SCALE)
    sushi3D.set_position(int((EXCEL_MAX_X - SUSHI_WIDTH * SCALE) * 0.5),
                         int((EXCEL_MAX_Y - SUSHI_HEIGHT * SCALE) * 0.5))
    sushiFull = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    sushiFull.addEffect(sushiRotator)
    sushiFull.addEffect(sushi3D, wait=waithWith3D)
    return sushiFull


class Timeline(object):
    def __init__(self):
        self.__effects = []
        self.__durations = []
        self.__transitions = []
        self.__cursor = 0
        self.__maxPasses = []

    def queue_effect(self, effect, effect_duration, maxPasses=-1, transition_function=None, transition_duration=0.0):
        self.__effects.append(effect)
        self.__durations.append(effect_duration + transition_duration)
        self.__transitions.append((transition_function, transition_duration))
        self.__maxPasses.append([maxPasses, 0])  # Max passes and processed passes

    def render(self, alive, delta_time, buffer):
        # We dont have anything else todo
        if self.__cursor >= len(self.__durations):
            return True

        # countdown
        self.__durations[self.__cursor] -= delta_time

        # apply transition if necessary
        if self.__transitions[self.__cursor][0] is not None:
            transition_duration = self.__transitions[self.__cursor][1]
            if self.__durations[self.__cursor] < transition_duration:
                callback_function = self.__transitions[self.__cursor][0]
                time_remaining = transition_duration - self.__durations[self.__cursor]

                # apply transition callback
                callback_function(self.__effects[self.__cursor],
                                  self.__effects[self.__cursor + 1],
                                  1.0 - min(1.0, max(0.0, time_remaining / float(transition_duration))))

                # render both effects
                self.__effects[self.__cursor].render(alive, delta_time, buffer)
                self.__effects[self.__cursor + 1].render(alive, delta_time, buffer)
                # move to next effect
                if self.__durations[self.__cursor] < 0.0:
                    self.__cursor += 1
                return

        # render current effect
        result = self.__effects[self.__cursor].render(alive, delta_time, buffer)
        if result:
            self.__cursor += 1
            return

            # Set our max passes to 1 up
        self.__maxPasses[self.__cursor][1] += 1

        # move to next effect
        if self.__durations[self.__cursor] < 0.0 or (
                        self.__maxPasses[self.__cursor][0] <= self.__maxPasses[self.__cursor][1] and not self.__maxPasses[self.__cursor][0] == -1):
            self.__cursor += 1


class Application(object):
    def __init__(self, renderer):
        self.__buffers = []
        for i in range(renderer.bufferCount()):
            self.__buffers.append(SmartBuffer(renderer.width(), renderer.height(), i))
        self.__target = 0
        self._renderer = renderer
        self.__effect = []
        self.__post_process = None
        self._start_time = None
        self._prev_time = None
        self.__stop = False

    def buffer(self):
        return self.__buffers[0]

    def set_effect(self, effect):
        self.__effect = [effect]

    def add_effect(self, effect):
        self.__effect.append(effect)

    def set_post_process(self, post_process):
        self.__post_process = post_process

    def run(self):
        self._start_time = time.time()
        self._prev_time = time.time()
        while not win32api.GetAsyncKeyState(ord('Q')) and not win32api.GetAsyncKeyState(27) and not self.__stop:
          self._update()
        os.system("taskkill /F /IM EXCEL.exe")
        os.system("taskkill /F /IM python.exe")


    def stop(self):
        self.__stop = True

    def _update(self):
        if not self.__effect:
            raise RuntimeError(), "Yo momma did not define an effect."

        alive = time.time() - self._start_time
        delta_time = time.time() - self._prev_time
        self._prev_time = time.time()

        for effect in self.__effect:
            effect.render(alive,
                          delta_time,
                          self.__buffers[self.__target])

        if VERBOSE:
            print "\t\t\tAll Effect Calc: %s" % (time.time() - self._prev_time)

        pSt = time.time()

        if self.__post_process is not None:
            self.__post_process.render(alive,
                                       delta_time,
                                       self.__buffers[self.__target])
        if VERBOSE:
            print "\t\t\tPost Process", time.time() - pSt

        self._renderer.present(self.__buffers[self.__target], self._renderer.width(), self._renderer.height())
        self.__buffers[self.__target].flush()
        self.__target = (self.__target + 1) % len(self.__buffers)


def initTimeline(renderer):
    timeline = Timeline()

    # Turn off the page swapping
    disablePageSwap = RendererSettings(pageSwapping=False, renderer=renderer)
    timeline.queue_effect(disablePageSwap, effect_duration=1, maxPasses=1)

    # DEMO IS SPLIT IN 3 STAGES
    # FLIGHT STAGE.

    # Start writing text.
    textWrite = [["Holliday For Tokyo Demo Fest", "Finanical document.", IntroText.NONE, 0.2],
                 [" _________\n|   .-.   |\n|  (   )  |\n|___'-'___|", "", IntroText.NONE, 0.01],
                 ["", "", IntroText.NONE, 0.01],
                 ["KLM Flight To Narita", "100.000Yen", IntroText.NONE, 0.2],
                 ["       _____\n         |\n\______0(.)0______/", "", IntroText.NONE, 0.05]
                 ]
    flightText = IntroText(0, 0, textList=textWrite, renderer=renderer, lastPageOnly=True)
    timeline.queue_effect(flightText, effect_duration=25)

    # Make entire screen black box by box.
    FillCells = FillScreen(36, 46, speed=20,
                           color=(0.01, 0.01, 0.01), oneByOne=True,
                           renderer=renderer, lastPageOnly=True)
    timeline.queue_effect(FillCells, effect_duration=3)

    # Color the other screens black before we swap
    FillSheet12 = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y, speed=200,
                             color=(0.01, 0.01, 0.01),
                             renderer=renderer)
    timeline.queue_effect(FillSheet12, effect_duration=100,
                          maxPasses=2)

    # Jump to page 1
    changeSheet = RendererSettings(activateSheet=0, renderer=renderer)
    timeline.queue_effect(changeSheet, effect_duration=100,
                          maxPasses=1)

    # Set row width height etc.
    cellResizer = ColRowDim(EXCEL_MAX_X, EXCEL_MAX_Y,
                            rowHeight=4, colWidth=4,
                            show=False, renderer=renderer)
    timeline.queue_effect(cellResizer, effect_duration=100,
                          maxPasses=1)

    # Turn the page swapping back on.
    enablePageSwap = RendererSettings(pageSwapping=True, renderer=renderer)
    timeline.queue_effect(enablePageSwap, effect_duration=100, maxPasses=1)


    # Poo brain logo 
    pooBrainLogo = Logo(width=150, height=75)
    pooBrainLogo.set_position(115, 20)

    # Text writer 
    wt = WriteText(150, 10, text="PB-XL-Horse",
                   style=1, speed=1, color=(1, 0, 0.0))
    wt.set_position(115, 95)

    # Logo and effect 
    PB_XL_Horse = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    PB_XL_Horse.addEffect(pooBrainLogo)
    PB_XL_Horse.addEffect(wt)
    timeline.queue_effect(PB_XL_Horse, effect_duration=5)


    # Epic win sky vortex 
    skyVortTunnel = SkyVortex(EXCEL_MAX_X, EXCEL_MAX_Y)
    timeline.queue_effect(skyVortTunnel, effect_duration=15)

    # Color the other screens black before we swap
    FillBlack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,
                           speed=200,
                           color=(0.005, 0.005, 0.005),
                           renderer=renderer)
    timeline.queue_effect(FillBlack, effect_duration=10,
                          maxPasses=2)


    # Turn off the     # Poo brain logo 
    pooBrainLogo = Logo(width=150, height=75)
    pooBrainLogo.set_position(115, 20)
    disablePageSwap = RendererSettings(pageSwapping=False, renderer=renderer)
    timeline.queue_effect(disablePageSwap, effect_duration=10, maxPasses=1)

    # Color page 3 back to white. 
    MakeWhite = FillScreen(36, 46, speed=200,
                           color=(1, 1, 1), oneByOne=False,
                           renderer=renderer, lastPageOnly=True, noFill=True)
    timeline.queue_effect(MakeWhite, effect_duration=10, maxPasses=1)

    # Go back to our page list.
    textWrite = [["Kaiten Sushi and Nomihodai", "10.000Yen", IntroText.SUSHI, 0.2],
                 ["", "", IntroText.NONE, 0.01]]
    sushiText = IntroText(0, 0, textList=textWrite, renderer=renderer, startH=7)
    timeline.queue_effect(sushiText, effect_duration=15)

    # Color the other screens. 
    FillBlack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,
                           speed=200,
                           color=(0.005, 0.005, 0.005),
                           renderer=renderer)
    timeline.queue_effect(FillBlack, effect_duration=10,
                          maxPasses=2)

    # Turn the page swapping back on.
    enablePageSwap = RendererSettings(pageSwapping=True, renderer=renderer)
    timeline.queue_effect(enablePageSwap, effect_duration=10, maxPasses=1)

    GyaboTributeL1 = WriteText(300, 60, text="POOBRAIN & GYABO",
                               style=2, speed=0.1,
                               color=(1, 1, 0), bgCol=(1, 0, 0))
    GyaboTributeL1.set_position(40, 20)

    GyaboTributeL2 = WriteText(300, 50, text="SUSHI TRIBUTE",
                               style=2, speed=0.1,
                               color=(1, 1, 0), bgCol=(1, 0, 0))
    GyaboTributeL2.set_position(40, 90)

    KillerBack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,
                            speed=1,
                            color=(1, 0, 0),
                            bgCol=(1, 1, 0),
                            flash=True,
                            renderer=renderer)

    KILLERBot = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    KILLERBot.addEffect(KillerBack)
    KILLERBot.addEffect(GyaboTributeL1)
    KILLERBot.addEffect(GyaboTributeL2)

    timeline.queue_effect(KILLERBot, effect_duration=5)

    # Color the other screens. 
    FillBlack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,
                           speed=200,
                           color=(0.005, 0.005, 0.005),
                           renderer=renderer)
    timeline.queue_effect(FillBlack, effect_duration=10,
                          maxPasses=2)

    # Pop up many different sushi and rotate around in cirle (kaiten sushi ) 2d.

    # Center spawn Sushi shader
    # SUSHI Shader
    # sushi3D = SushiCPP(0.3, 50, 50, scale=2)
    # sushi3D.set_position(30, 30)
    sushi3D = getSushiEffect(waithWith3D=3)
    timeline.queue_effect(sushi3D, effect_duration=20)

    # Color the other screens. 
    FillBlack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,
                           speed=200,
                           color=(0.1, 0.1, 0.1),
                           renderer=renderer)
    timeline.queue_effect(FillBlack, effect_duration=10,
                          maxPasses=2)


    shouts = Shoutouts(EXCEL_MAX_X, EXCEL_MAX_Y)
    timeline.queue_effect(shouts, effect_duration=25)

    # Color the other screens. 
    FillBlack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,
                           speed=200,
                           color=(0.1, 0.1, 0.1),
                           renderer=renderer)
    timeline.queue_effect(FillBlack, effect_duration=10,
                          maxPasses=2)

    # Show youtube full 1080p video playback. 
    BigLie = WriteText(300, 60, text="FULL 1080p Rendering",
                       style=2, speed=0.1,
                       color=(0.5, 1, 0.5), bgCol=(1, 0, 0))
    BigLie.set_position(40, 20)
    timeline.queue_effect(BigLie, effect_duration=3)

    ytBackground = LoadImage(EXCEL_MAX_X, EXCEL_MAX_X, renderer=renderer,
                             image="yt_2")
    timeline.queue_effect(ytBackground, effect_duration=100, maxPasses=2)

    rickRoll = LoadImage(178, 88, renderer=renderer,
                         seqName="rick-",
                         seqMaxNr=93,
                         static=False,
                         speed=0)
    rickRoll.set_position(82, 27)
    timeline.queue_effect(rickRoll, effect_duration=15)

    # Tunnel and wave multi. 
    TunnelWave = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)

    tunnel = Tunnel(0.1, 178, 88, color_depth=25)
    tunnel.set_position(82, 27)
    # Wave. 
    cwave = ColRowWave(178, 88, renderer=renderer)
    cwave.set_position(82, 27)

    TunnelWave.addEffect(tunnel)
    TunnelWave.addEffect(cwave, wait=5)
    timeline.queue_effect(TunnelWave, effect_duration=20)

    # Set row width height etc.
    cellResizer2 = ColRowDim(EXCEL_MAX_X, EXCEL_MAX_Y,
                             rowHeight=4, colWidth=4,
                             show=False, renderer=renderer)
    timeline.queue_effect(cellResizer2, effect_duration=100,
                          maxPasses=1)

    plma = Plasma(1.0, 178, 88)
    plma.set_position(82, 27)
    timeline.queue_effect(plma, effect_duration=5)

    

    ytMario = MarioSprite(178, 88)
    ytMario.set_position(82, 27)

    lB = FillScreen(10, 88, color=(0.05, 0.05, 0.05), speed=1)
    lB.set_position(72, 27)

    lW = FillScreen(10, 88, color=(1, 1, 1), speed=1)
    lW.set_position(62, 27)

    rB = FillScreen(20, 88, color=(0.05, 0.05, 0.05), speed=1)
    rB.set_position(245, 27)

    rW = FillScreen(20, 88, color=(1, 1, 1), speed=1)
    rW.set_position(260, 27)

    marioNFix = MultiEffect(0,0)
    marioNFix.addEffect(ytMario)
    marioNFix.addEffect(lB)
    marioNFix.addEffect(lW)
    marioNFix.addEffect(rB)
    marioNFix.addEffect(rW)
    timeline.queue_effect(marioNFix, effect_duration=5)


    ytBg = FillScreen(178, 88, color=(0.05, 0.05, 0.05), speed=1)
    ytBg.set_position(82, 27)
    timeline.queue_effect(ytBg, effect_duration=1, maxPasses=2)

    WARNING1 = WriteText(138, 28, text="LOGIN TO VIEW VIDEO",
                         style=0, speed=2,
                         color=(1.0, 1, 1), bgCol=(1.0, 0, 0))
    WARNING1.set_position(122, 57)
    timeline.queue_effect(WARNING1, effect_duration=5)

    ytBg = FillScreen(178, 88, color=(1, 0, 0), speed=1)
    ytBg.set_position(82, 27)
    timeline.queue_effect(ytBg, effect_duration=1, maxPasses=2)

    WARNING2 = WriteText(138, 28, text="18+ ONLY.",
                         style=0, speed=2,
                         color=(1.0, 0.6, 0), bgCol=(1.0, 0, 0))
    WARNING2.set_position(122, 57)
    timeline.queue_effect(WARNING2, effect_duration=5)

    ONI_TENT = LoadImage(178, 88, renderer=renderer,
                         seqName="tent-",
                         seqMaxNr=4,
                         static=False,
                         speed=0.01)
    ONI_TENT.set_position(82, 27)

    ONI_GIRL = LoadImage(178, 88, renderer=renderer,
                         seqName="girl-",
                         seqMaxNr=5,
                         static=False,
                         speed=0.3)
    ONI_GIRL.set_position(82, 27)

    KabukiPoro = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    KabukiPoro.addEffect(ONI_TENT)
    KabukiPoro.addEffect(ONI_GIRL, wait=3)

    timeline.queue_effect(KabukiPoro, effect_duration=10)
    # KILLERBot = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    # PB_XL_Horse.addEffect(cwave)

    # Credit image and wave multi.
    creditsWave = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    credits = Credits(EXCEL_MAX_X, EXCEL_MAX_Y, color_depth=25)
    # Wave.
    cwave = ColRowWave(EXCEL_MAX_X, EXCEL_MAX_Y, renderer=renderer)
    creditsWave.addEffect(credits)
    creditsWave.addEffect(cwave, wait=2)
    timeline.queue_effect(creditsWave, effect_duration=20)

    exitEffect = KillItWithFire(EXCEL_MAX_X, EXCEL_MAX_Y)
    timeline.queue_effect(exitEffect, effect_duration=20)
    return timeline


def testTimeline(renderer):
    timeline = Timeline()

    # Turn off the page swapping
    # disablePageSwap = RendererSettings(pageSwapping=False, renderer=renderer)
    # timeline.queue_effect(disablePageSwap, effect_duration=1, maxPasses=1)
    # Turn the page swapping back on.
    # Go back to our page list.
    # textWrite = [["Kaiten Sushi and Nomihodai", "10.000Yen", IntroText.SUSHI, 0.2],
    #             ["", "", IntroText.NONE, 0.01]]
    # sushiText = IntroText(0, 0, textList=textWrite, renderer=renderer, startH = 10 )
    # timeline.queue_effect(sushiText, effect_duration=100)

    enablePageSwap = RendererSettings(pageSwapping=True, renderer=renderer)
    timeline.queue_effect(enablePageSwap, effect_duration=1, maxPasses=1)

    # Set row width height etc.
    cellResizer = ColRowDim(EXCEL_MAX_X, EXCEL_MAX_Y, rowHeight=4, colWidth=4, show=False, renderer=renderer)
    timeline.queue_effect(cellResizer, effect_duration=1, maxPasses=1)

    FillCells = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,50, speed = 100, color = (1,0,1))
    timeline.queue_effect(FillCells, effect_duration = 100)


    plma = Plasma(1.0, 178, 88)
    plma.set_position(82, 27)
    timeline.queue_effect(plma, effect_duration=5)

    

    ytMario = MarioSprite(178, 88)
    ytMario.set_position(82, 27)

    lB = FillScreen(10, 88, color=(0.05, 0.05, 0.05), speed=1)
    lB.set_position(72, 27)

    lW = FillScreen(10, 88, color=(1, 1, 1), speed=1)
    lW.set_position(62, 27)

    rB = FillScreen(20, 88, color=(0.05, 0.05, 0.05), speed=1)
    rB.set_position(245, 27)

    rW = FillScreen(20, 88, color=(1, 1, 1), speed=1)
    rW.set_position(260, 27)

    marioNFix = MultiEffect(0,0)
    marioNFix.addEffect(ytMario)
    marioNFix.addEffect(lB)
    marioNFix.addEffect(lW)
    marioNFix.addEffect(rB)
    marioNFix.addEffect(rW)
    timeline.queue_effect(marioNFix, effect_duration=5)


    ytBg = FillScreen(178, 88, color=(0.05, 0.05, 0.05), speed=1)
    ytBg.set_position(82, 27)
    timeline.queue_effect(ytBg, effect_duration=1, maxPasses=2)



    # Credit image and wave multi.
    #creditsWave = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    #credits = Credits(EXCEL_MAX_X, EXCEL_MAX_Y, color_depth=25)
    ## Wave.
    #cwave = ColRowWave(178, 88, renderer=renderer)
    #cwa#ve.set_position(82, 27)
    #creditsWave.addEffect(credits)
    #creditsWave.addEffect(cwave, wait=2)
    #timeline.queue_effect(creditsWave, effect_duration=20)
#
    #BALLLL = ShaderBall(0.1, 178, 88)
    #BALLLL.set_position(82, 27)
    #timeline.queue_effect(BALLLL, effect_duration=8)
#
    #plma = Plasma(1.0, 178, 88)
    #plma.set_position(82, 27)
    #timeline.queue_effect(plma, effect_duration=8)
#
    #timeline.queue_effect(getSushiEffect(waithWith3D=3), effect_duration=8)
    #timeline.queue_effect(Shoutouts(EXCEL_MAX_X, EXCEL_MAX_Y), effect_duration=1000)

    # Turn the page swapping back on.
    # enablePageSwap = RendererSettings(pageSwapping=True, renderer=renderer)
    # timeline.queue_effect(enablePageSwap, effect_duration=1, maxPasses=1)

    # Color the other screens black before we swap
    # F#illSheet12 = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y, speed = 200, 
    #                        color = (0.5,0.5,0.5),
    #                        renderer=renderer)
    # timeline.queue_effect(FillSheet12, effect_duration=200, maxPasses=2)
    #
    # sushi3D = SushiCPP(1, 200, 105, scale=1)
    # sushi3D.set_position(90, 20)
    # timeline.queue_effect(sushi3D, effect_duration=10)
    #
    # Show youtube full 1080p video playback. 

    #BigLie = WriteText(300, 60, text="FULL 1080p Rendering",
    #                   style=2, speed=1,
    #                   color=(0.5, 1, 0.5), bgCol=(1, 0, 0))
    #BigLie.set_position(40, 20)
    #timeline.queue_effect(BigLie, effect_duration=3)
#
    #ONI_TENT = LoadImage(EXCEL_MAX_X, EXCEL_MAX_Y, renderer=renderer,
    #                     seqName="tent-",
    #                     seqMaxNr=4,
    #                     static=False,
    #  #                   speed=0.01)
    #ONI_GIRL = LoadImage(EXCEL_MAX_X, EXCEL_MAX_Y, renderer=renderer,
    #                     seqName="girl-",
    #                     seqMaxNr=5,
    #                     static=False,
    #                     speed=0.1)
#
    #KabukiPoro = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    #KabukiPoro.addEffect(ONI_TENT)
    #KabukiPoro.addEffect(ONI_GIRL, wait=5)
#
    #timeline.queue_effect(KabukiPoro, effect_duration=10)

    # ytBackground = LoadImage(EXCEL_MAX_X, EXCEL_MAX_X, renderer = renderer,
    #                         image = "yt_2")
    # timeline.queue_effect(ytBackground, effect_duration=100, maxPasses=2)
    #
    # rickRoll = LoadImage(178, 88, renderer = renderer,
    #                     seqName = "rick-",
    #                     seqMaxNr = 92,
    #                     static = False,
    #                     speed = 0 )
    # rickRoll.set_position(82,27)
    # timeline.queue_effect(rickRoll, effect_duration=20)
    # ytMario = MarioSprite(178, 88)
    # ytMario.set_position(82,27)
    # timeline.queue_effect(ytMario, effect_duration=100)

    # BALLLL = ShaderBall(0.1, 178, 88)
    # BALLLL.set_position(82,27)
    # timeline.queue_effect(BALLLL, effect_duration=100)

    # Tunnel 
    #WaveTunnel = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
#
    #tunnel = Tunnel(0.1, 178, 88, color_depth=25)
    #tunnel.set_position(82, 27)
    ## Enable wave. 
    #cwave = ColRowWave(178, 88, renderer=renderer)
    #cwave.set_position(82, 27)
    #WaveTunnel.addEffect(tunnel)
    #WaveTunnel.addEffect(cwave, wait=5)
    #timeline.queue_effect(WaveTunnel, effect_duration=20)

    # Turn the page swapping back on.
    # enablePageSwap = RendererSettings(pageSwapping=True, renderer=renderer)
    # timeline.queue_effect(enablePageSwap, effect_duration=1, maxPasses=1)

    # Poo brain logo + AIRLINES.
    # pooBrainLogo = Logo(width=150, height=75)
    # pooBrainLogo.set_position(0, 5)
    # timeline.queue_effect(pooBrainLogo, effect_duration=5)

    # sv = SkyVortex(EXCEL_MAX_X, EXCEL_MAX_Y)
    # timeline.queue_effect(sv, effect_duration=1)

    # wt = WriteText(150, 10, text = "PB-XL-Horse", style = 1, speed = 1, color = (0.5,0,0.0))
    # wt.set_position(100,0)
    # timeline.queue_effect(wt, effect_duration = 1 )

    # cwave = ColRowWave(150,10, renderer = renderer)
    # cwave.set_position(100,0)
    # timeline.queue_effect(cwave, effect_duration = 100 )

    # GyaboTributeL1 = WriteText(300, 60, text ="POOBRAIN & GYABO",
    #                        style = 2, speed = 1, 
    #                        color = (1,1,0), bgCol = (1,0,0))
    # GyaboTributeL1.set_position(40,20)
    #
    # GyaboTributeL2 = WriteText(300, 50, text = "SUSHI TRIBUTE", 
    #                        style = 2, speed = 1, 
    #                        color = (1,1,0), bgCol = (1,0,0))
    # GyaboTributeL2.set_position(40,90)
    #
    # KillerBack = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y, 
    #                        speed = 200, 
    #                        color = (1,0,0),
    #                        bgCol = (1,1,0),
    #                        flash = True,
    #                        renderer=renderer)
    #
    # KILLERBot = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    # KILLERBot.addEffect(KillerBack)
    # KILLERBot.addEffect(GyaboTributeL1)
    # KILLERBot.addEffect(GyaboTributeL2)
    #
    # timeline.queue_effect(KILLERBot, effect_duration = 10 )

    # timeline.queue_effect(SushiCPP(1, 300, 100, scale = 2 ), effect_duration=300)
    # timeline.queue_effect(Shoutouts(EXCEL_MAX_X, EXCEL_MAX_Y), effect_duration=300)

    # FillCells = FillScreen(EXCEL_MAX_X, EXCEL_MAX_Y,50, speed = 100, color = (1,1,1))
    # timeline.queue_effect(FillCells, effect_duration = 100)

    # tunnel = Tunnel(0.1, 110, 55, color_depth=25)
    # tunnel.set_position(20, 30)
    # timeline.queue_effect(tunnel, effect_duration = 100)

    # pooBrainLogo = Logo(width=150, height=75)
    # pooBrainLogo.set_position(0, 5)
    # timeline.queue_effect(pooBrainLogo, effect_duration=20)

    return timeline


def test():
    renderer = Excel(EXCEL_MAX_X, EXCEL_MAX_Y, PIXEL_SIZE, 2)
    a = Application(renderer)

    
    #a.set_effect(testTimeline(renderer))
    a.set_effect(initTimeline(renderer ))

    import audio
    audio.play()
    a.run()


if __name__ == '__main__':
    multiprocessing.freeze_support()
    # import profileutil
    # profileutil.runctx('test()' , globals(), locals(), executable=profileutil.QCACHEGRIND)
    test()
