from math import sin, cos

from PB_XLPaard import Application, Timeline
import time

from effects.shader_ball import ShaderBallPython
from effects.shader_base import Shader
from globals import EXCEL_MAX_X, EXCEL_MAX_Y, PIXEL_SIZE
from PyQt4.QtCore import Qt, QTimer
from PyQt4.QtGui import QWidget, QApplication, QPainter, QColor
from effects import *


class QtRenderer(QWidget):
    def __init__(self, width, height, pixel_size, buffer_count):
        super(QtRenderer, self).__init__()
        self.__width = width
        self.__height = height
        self.__pixel_size = pixel_size
        self.__buffer_count = buffer_count
        self.__buffer = None
        self.__activeBuffer = 0
        self.show()

    def bufferCount(self):
        return self.__buffer_count

    def present(self, buffer, width, height):
        self.resize(width * self.__pixel_size, height * self.__pixel_size)
        self.__buffer = (buffer, width, height)
        self.repaint()
        self.__activeBuffer = (self.__activeBuffer + 1) % self.__buffer_count

    def keyPressEvent(self, event):
        if event.key() == Qt.Key_Q:
            self.close()

    def paintEvent(self, event):
        if self.__buffer is None:
            return
        painter = QPainter(self)
        painter.setPen(Qt.NoPen)
        pixels = self.__buffer[0].pixels()
        dirties = self.__buffer[0].dirties()
        for y in range(self.__buffer[2]):
            for x in range(self.__buffer[1]):
                index = x + y * self.__buffer[1]
                # if not dirties[index]:
                #    continue
                cl = QColor(pixels[index])
                blue = cl.red()
                cl.setRed(cl.blue())
                cl.setBlue(blue)
                painter.setBrush(cl)
                painter.drawRect(x * self.__pixel_size,
                                 y * self.__pixel_size,
                                 self.__pixel_size,
                                 self.__pixel_size)

    def target(self):
        return self.__activeBuffer

    def width(self):
        return self.__width

    def height(self):
        return self.__height


class Grid(Shader):
    def pre_sample(self, alive):
        return (float(self._width) / float(self._height), cos(alive), sin(alive))

    def sample(self, alive, u, v, *args):
        aspect, t0, t1 = args
        u, v = (u * 2.0 - 1.0) * aspect, v * 2.0 - 1.0
        u, v = u * t0 - v * t1, v * t0 + u * t1
        u, v = u * 5 % 2 - 1, v * 5 % 2 - 1
        opacity = max(0, 1 - min(abs(u * 10), abs(v * 10)))
        return opacity, opacity, opacity


class QtApplication(Application):
    def run(self):
        self._start_time = time.time()
        self._prev_time = time.time()
        self.timer = QTimer()
        self.timer.timeout.connect(self._update)
        self.timer.start(16)

    def stop(self):
        self.timer.stop()


if __name__ == '__main__':
    app = QApplication([])
    width, height = EXCEL_MAX_X, EXCEL_MAX_Y
    renderer = QtRenderer(width, height, PIXEL_SIZE, 1)
    a = QtApplication(renderer)

    timeline = Timeline()

    BALLLL = ShaderBall(0.1, 178, 88)
    BALLLL.set_position(82, 27)
    timeline.queue_effect(BALLLL, effect_duration=10)

    BALLLL = ShaderBallPython(0.1, 178, 88)
    BALLLL.set_position(82, 27)
    timeline.queue_effect(BALLLL, effect_duration=10)

    plasm = Plasma(1.0, EXCEL_MAX_X / 4, EXCEL_MAX_Y / 4, 2)
    plasm.set_position(EXCEL_MAX_X / 4, EXCEL_MAX_Y / 4)
    timeline.queue_effect(plasm, effect_duration=1000)

    ## Poo brain logo
    # PBIntroLogo = Logo(width=200, height=128)
    # timeline.queue_effect(PBIntroLogo, effect_duration=1000)

    ## Shoutouts
    # timeline.queue_effect(Grid(0.16, width, height), effect_duration=1000)

    ## Rotating sushi
    sushiRotator = SushiRotator(EXCEL_MAX_X, EXCEL_MAX_Y)
    SUSHI_WIDTH, SUSHI_HEIGHT = 80, 50
    sushi3D = SushiCPP(0.3, SUSHI_WIDTH, SUSHI_HEIGHT, scale=2)
    sushi3D.set_position(int((EXCEL_MAX_X - SUSHI_WIDTH) * 0.5),
                         int((EXCEL_MAX_Y - SUSHI_HEIGHT) * 0.5))
    sushiFull = MultiEffect(EXCEL_MAX_X, EXCEL_MAX_Y)
    sushiFull.addEffect(sushiRotator)
    sushiFull.addEffect(sushi3D, wait=0)
    # timeline.queue_effect(sushiFull, effect_duration=1000)

    timeline.queue_effect(Shoutouts(width, height), effect_duration=1000)
    # timeline.queue_effect(Sushi(1.0, 50, 30), effect_duration=1000)
    # timeline.queue_effect(SushiCPP(1.0, 50, 30), effect_duration=1000)
    # timeline.queue_effect(ShaderBall(1.0, 50, 30), effect_duration=1000)
    # timeline.queue_effect(SkyVortex(width, height), effect_duration=1000)

    a.set_effect(timeline)

    a.run()
    app.exec_()
