###
# Multithreaded excel device, we can't use methods here because multiprocessing only understands module level functions
# in order to share memory.
###

import os
import multiprocessing
import time
import subprocess
from globals import *
import random
import sys
import time
import datetime
import traceback
import struct
from effects import effectUtils
import tempfile
win32BOOL = True
if win32BOOL:
    # you can grab win32 here http://sourceforge.net/projects/pywin32/
    import win32com
    from win32com.client.gencache import EnsureDispatch
    from win32com.client import Dispatch, VARIANT, DispatchEx
    sys.coinit_flags = 0
else:
    import comtypes  ## pip install comtypes
    from comtypes.client import GetActiveObject as EnsureDispatch

    sys.coinit_flags = comtypes.COINIT_MULTITHREADED


def binary(num):
    return ''.join(bin(ord(c)).replace('0b', '').rjust(8, '0') for c in struct.pack('!f', num))


def ints(num):
    packed = struct.pack('!f', num)
    return [ord(c) for c in packed]


def excel_sheets(count, fast=False, path=None):
    # connect to excel
    #excel = EnsureDispatch("Excel.Application")
    excel = Dispatch("Excel.Application")
    #excel = DispatchEx("Excel.Application")
    if not fast:
        excel.Visible = True
        #excel.DisplayFullScreen = True #.WindowState = excel.XlWindowState.xlMaximized
        excel.WindowState = -4137#win32com.client.constants.xlMaximized 
        excel.DisplayAlerts = False
        if path:
            # excel.Workbooks.Close()
            workbook = excel.Workbooks.Add(path)


    # make sure we have a workbook
    workbook = None
    for wb in excel.Workbooks:
        workbook = wb
    if not workbook:
        workbook = excel.Workbooks.Add()

    # make sure we have all the desired sheets
    sheets = []
    for sh in workbook.Sheets:
        sheets.append(sh)


    for i in range(len(sheets), count):
        if sheets:
            sh = workbook.Sheets.Add(After =sheets[-1] )
        else:
            sh = workbook.Sheets.Add()
        sheets.append(sh)

    bla = [1,1,1]
    for sh in sheets:
        if sh.Name == "Sheet1":
            bla[0] = sh
        if sh.Name == "Sheet2":
            bla[1] = sh
        if sh.Name == "Sheet3":
            bla[2] = sh
    bla[0].Move(Before=bla[1])
    bla[1].Move(Before=bla[2])

    return sheets, excel


#def excel_resize_cells(sheets, width, height, pixel_size):
#    # resize the sheets to the pixel size
#    state = int(width >= 26)
#    s = ''
#    while width > 26:
#        s = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'[width % 26] + s
#        width /= 26
#    s = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'[width - state] + s
#    for sh in sheets:
#        sh.Columns('A:%s' % s).ColumnWidth = pixel_size / float(EXCEL_CHAR_WIDTH)
#        sh.Rows('1:%s' % height).RowHeight = pixel_size
#        sh.Activate()
#
#    # show the first sheet
#    sheets[1].Activate()
#    return "%s%s" % (s, height + 1)


def start_process(signalQueue, page_count=2):
    # This is the first process that is called by the thread.
    # So we are reimporting the excel hook and using that.
    global BUFFER
    global sq
    global Excel
    global Sheets
    sq = signalQueue
    BUFFER = []

    ## Sleep zodat de picle niet op zn bek gaat. 
    time.sleep(multiprocessing.current_process()._identity[0] * 0.1)
    Sheets, Excel = excel_sheets(page_count, fast=True)

    # excel_cache_cells(Sheets, width, height)
    sq.put(1)  ## inform the queue that we are done.


def checkCell(args):
    x, y, color, sheet = args
    cell = y * EXCEL_MAX_X + x
    global BUFFER

    if len(BUFFER) < sheet + 1:
        for newBuff in xrange(sheet + 1 - len(BUFFER)):
            BUFFER.append([])

    if len(BUFFER[sheet]) < cell + 1:
        for newCell in xrange(cell + 1 - len(BUFFER[sheet])):
            BUFFER[sheet].append(None)

    if not BUFFER[sheet][cell]:
        global Sheets

        excelLetters = effectUtils.excel_style(y + 1, x + 1)
        ## turns out the range function is faster then the Cells Function. 
        BUFFER[sheet][cell] = Sheets[sheet].Range("%s" % (excelLetters)).Interior

        # BUFFER[sheet][cell] = Sheets[sheet].Cells(y+1, x+1).Interior
    return BUFFER[sheet][cell]


def calculateColor(args):
    x, y, color, sheet = args
    checkCell(args).Color = color
    sq.put(1)


###################
## Macro solution 
###################
def start_process_macro(signalQueue, width, height, startRange, endRange):
    # This is the first process that is called by the thread.
    # So we are reimporting the excel hook and using that.
    global sq
    global Excel
    sq = signalQueue

    Sheets, Excel = excel_sheets(2, fast=True)

    sq.put(1)  ## inform the queue that we are done.


def set_color_macro(args):
    global Excel
    global sq

    sheet, colList = args
    ## we can also try ExecuteExcel4macro
    Excel.Application.Run("set_color_range", sheet, colList)
    # Excel.ExecuteExcel4Macro("set_color(%s,%s)"%(sheet, colList) )

    sq.put(1)


class Excel(object):
    def __init__(self, width, height, pixel_size, buffer_count):
        self.__width = width
        self.__height = height
        self._startRange = effectUtils.excel_style(1, 1)
        self._endRange = effectUtils.excel_style(width, height)

        self._excelMacro = True

        self.__pixel_size = pixel_size
        self.__buffer_count = buffer_count
        self._activeBuffer = 0
        self._startFrame = 0
        self._printInterval = 0
        self._fps = 0
        self._userViewingBuffer = 0
        self._first = True

        self._pageSwapping = True  ## Turn page swapping on or off

        if self._excelMacro:
            # macroPath = os.path.normpath(os.path.join(os.path.dirname(__file__) , "AutoColorMacro/ColorOnHex.xlsm"))
            # macroPath = os.path.normpath(os.path.join(os.path.dirname(__file__) , "AutoColorMacro/ColorOnHex.xls"))
            macroPath = os.path.abspath( "AutoColorMacro/ColorOnHexMacro.xla")
            self.sheets, self._excel = excel_sheets(buffer_count+1, path=macroPath)
        else:
            self.sheets, self._excel = excel_sheets(buffer_count+1)

        # lastCell = excel_resize_cells(self.sheets, width, height, pixel_size)

        ## Activate the previous window.
        ## WARNING TEST THIS ON A EMPTY DESKTOP ! 
        self._excel.ActiveWindow.ActivatePrevious()
        self._excel.Range("A1").Select()


        #self._excel.EnableEvents = False ## TEST 
        # for sh in self.sheets:
        #   sh.Activate()
        #    self._excel.ActiveWindow.DisplayGridlines = False
        #    self._excel.ActiveWindow.DisplayHeadings = False
        #    #self._excel.ScreenUpdating = True 
        #    #sh.PageSetup.Zoom = True
        #    #sh.PageSetup.Zoom = 50
        #    #self._excel.Range(effectUtils.excel_style(1,width+1)).Select()

        # sh.Range("A1","D10").Value = ['FF0000']*40

        if self._excelMacro:
            self._excel.Application.Run("cache_cells", width, height, self._startRange, self._endRange)

            ## We only need one thread really but we need to initialise it with a start process 
            self._signalQueue = multiprocessing.Queue()
            self.__cpu_count = 1
            self.pool = multiprocessing.Pool(processes=self.__cpu_count,
                                             initializer=start_process_macro,
                                             initargs=(self._signalQueue, width, height, self._startRange, self._endRange))

            threadsDone = 0
            while threadsDone < self.__cpu_count:
                self._signalQueue.get()
                threadsDone += 1

            print "Done Init"

        else:
            self.__cpu_count = multiprocessing.cpu_count() - 2
            self._chunkSize = self.__width

            st = time.time()
            self._signalQueue = multiprocessing.Queue()
            self.pool = multiprocessing.Pool(processes=self.__cpu_count,
                                             initializer=start_process,
                                             initargs=(self._signalQueue,))

            # Count the number of threads that are done.
            self._lastSize = self.__cpu_count

            self.bla = True
            threadsDone = 0
            while threadsDone < self.__cpu_count:
                self._signalQueue.get()
                threadsDone += 1

            print "Done Init", time.time() - st

    def bufferCount(self):
        return self.__buffer_count

    def present(self, buffer, width, height, renderer=0):

        preArgStart = time.time()

        pixels = buffer.pixels()
        dirties = buffer.dirties()

        self._userViewingBuffer = (buffer.index()+ 1) % 2

        if self._pageSwapping:
            self._activeBuffer = buffer.index()

        if self._excelMacro:

            colList = []
            for x in xrange(height * width):
                if dirties[x]:
                    colList.append(int(pixels[x]))
                else:
                    colList.append(0)
            t_argCreation = time.time() - preArgStart

            ###################
            ## Wait for old frame to finish 
            ###################
            t_swapDuration = 0
            t_renderWait = 0
            if self._first == False:
                preRenderWait = time.time()

                self._signalQueue.get()  ## only one thread for now anyway

                t_renderWait = time.time() - preRenderWait

                ######################
                ## Page Swap
                ######################
                preSwap = time.time()
                if self._pageSwapping: self.sheets[self._userViewingBuffer].Activate()
                t_swapDuration = time.time() - preSwap

            self._first = False
            #################
            ## Render next  frame 
            #################
            preRenderWait = time.time()
            t_asyncCall = 0
            asT = time.time()
            self.pool.map_async(set_color_macro, [[buffer.index() + 1, colList]])
            t_asyncCall = time.time() - asT
            # self._excel.ExecuteExcel4Macro("set_color(%s,%s)"%(self._activeBuffer+1, d) )

        ## Timings
        totalTime = time.time() - self._startFrame  ## Get total time passed since last frame
        self._startFrame = time.time()  ## Reset timing
        self._printInterval += totalTime  ## Increment printing interval.
        self._fps += 1  ## Not accurate but gets the idea give or take
        if self._printInterval > 1 and DEBUG:
            self._printInterval = 0
            print "Total Run time: ", totalTime
            print "Total PresentF time: ", time.time() - preArgStart
            print "\tFPS:", self._fps
            if VERBOSE: print "\t", "CreateRenderArg: ", t_argCreation  ## How long did it take to create the render arguments
            if VERBOSE: print "\t", "Excel Wait Time: ", t_renderWait  ## How long did we wait for our threads to finish
            if VERBOSE: print "\t", "Excel Swap Time: ", t_swapDuration  ## Hpow long did we wait for our threads to swap.
            if VERBOSE: print "\t", "Threadcall Time: ", t_asyncCall  ## Hpow long did we wait for our threads to swap.
            print "\t", "Other Cal  Time:", totalTime - t_argCreation - t_renderWait - t_swapDuration - t_asyncCall  ## How long everything else took. (shader calc etc. )
            print
            self._fps = 0
            ## / Timings

    def target(self):
        return self._activeBuffer

    def width(self):
        return self.__width

    def height(self):
        return self.__height
