from globals import *
from math import sin
from effect_base import Effect
import time

class ColRowWave( Effect ):
    def __init__(self, *args,**kwargs):
        super(ColRowWave, self).__init__(*args, **kwargs)
        self._sheets = self._renderer.sheets
        self._cacheColums()

    def _cacheColums( self ):
        self._columns = [[] for x in xrange(len(self._sheets))]
        self._rows = [[] for x in xrange(len(self._sheets))]

        #for i, sh in enumerate(self._sheets):
        #    for x in xrange(1,self._width):
        #        self._columns[i].append( sh.Columns(x) )
        #    for y in xrange(1,self._height):
        #        self._rows[i].append( sh.Rows(y) )


    def render(self, alive, delta_time, buffer ):
        # poo-brain!
        #image, img_width, img_height = get_image('poo_brain_%.2i'%(self.__state + 1))
        #self.__state = (self.__state + 1) % 9
        #buffer.DrawImage(0, 0, img_width, img_height, 0, image)

        xStep = 3.14159265359 / float(self._width*0.5)
        yStep = 3.14159265359 / float(self._height*0.5)
        pxSizeX = (PIXEL_SIZE*0.8)
        pxSizeY = (PIXEL_SIZE*0.2)

        sheetIndex = (buffer.index()+1)%2
        cLen = len( self._columns[sheetIndex] )
        rLen = len( self._rows[sheetIndex] )

        ## Some list index mumbo jumbo just so we have enough entries in the list. 
        if cLen < self._offset[0] + self._width-1:
            self._columns[sheetIndex].extend( [None for x in xrange(self._offset[0] + self._width-1-cLen)])   

        if rLen < self._offset[1] + self._height-1:
            self._rows[sheetIndex].extend( [None for x in xrange(self._offset[1] + self._height-1-rLen)])   

        #self._renderer._excel.ScreenUpdating = False
        ## Start moving the columns 
        for x in xrange(self._offset[0]+1, self._offset[0] + self._width-1):
            if not self._columns[sheetIndex][x]:
                self._columns[sheetIndex][x] = self._sheets[sheetIndex].Columns(x) 
            self._columns[sheetIndex][x].ColumnWidth = (PIXEL_SIZE + sin(xStep * x + alive) * pxSizeX ) / float(EXCEL_CHAR_WIDTH)

        ## Start moving the rows.
        for y in xrange(self._offset[1]+1, self._offset[1] + self._height-1):
            if not self._rows[sheetIndex][y]:
                self._rows[sheetIndex][y] = self._sheets[sheetIndex].Rows(y) 
            self._rows[sheetIndex][y].RowHeight = (PIXEL_SIZE + sin(yStep * y + alive) * pxSizeY)
        #self._renderer._excel.ScreenUpdating = True 


