## Slow init effect.
from globals import *
import time
from effect_base import Effect
from math import sin


class SlowInit(Effect):
    def __init__(self, *args, **kwargs):
        super(SlowInit, self).__init__(*args, **kwargs)
        self._preList = []
        for y in xrange(0, self._height):
            for x in xrange(0, self._width):
                r = sin(x) + 0.1
                g = sin(y) + 0.1
                self._preList.append([self._offset[0] + x, self._offset[1] + y, (x * y + self._passes) % 1000])

    def render(self, alive, delta_time, buffer):
        # poo-brain!
        # maxX = self._passes if self._passes < self._width else self._width
        # maxY = self._passes if self._passes < self._hebight else self._height

        # offsetCol = 0
        # for y in xrange(0, self._height):
        #    for x in xrange(0, self._width):
        #        r = sin(x+alive)+0.1
        #        g = sin(y+alive)+0.1
        #        buffer.setPixel(self._offset[0]+x,self._offset[1]+y,Application
        #                        x+y+self._passes)

        aT = 0
        bT = 0
        tT = 0
        tSt = time.time()
        for xy in xrange(self._height * self._width):
            a, b, c = self._preList[xy]
            aSt = time.time()
            q = sin(alive) * 100  # np.random.randint(0,1000)
            aT += time.time() - aSt

            bSt = time.time()
            buffer.setPixel(a, b, q)
            bT += time.time() - bSt

        if VERBOSE: print "\t\tTot Effect Init"
        if VERBOSE: print "\t\t\tRand Time: ", aT
        if VERBOSE: print "\t\t\tBuff Time: ", bT
        if VERBOSE: print "\t\t\tTot  Time: ", time.time() - tSt
        # if delta_time >1:
        # x,y = [int((sin(self.__passes)+1)*50), int((cos(self.__passes)+1)*50)]
        # self.set_position(x,y)
        self._passes += 1

    def set_position(self, x, y):
        self._offset = x, y
