from effect_base import Effect
from effectUtils import stringToBinArray
from drawingutils import rgb2packedInt
import ctypes 
import random 

class WriteText(Effect):
    def __init__(self, *args, **kwargs):
        super(WriteText, self).__init__(*args, **kwargs)
        self._color = rgb2packedInt(*kwargs.get("color", (0.1,0.1,0.1)))
        self._black = rgb2packedInt(*kwargs.get("bgCol", (0.05,0.05,0.05)))
        self._speed = kwargs.get("speed", 1 )
        self._oneByOne = kwargs.get("oneByOne", False)
        txt = kwargs.get("text", "No Text Set") 
        self._text = stringToBinArray( txt )
        self._tw = len(self._text) * 10 
        self._th = 10 
        self._yStepSize = self._th / float( self._height )
        self._xStepSize = self._tw / float( self._width ) 
        self._lH = self._height 
        self._lW = int( self._width / float(len(self._text)))## letter width 
        self._letterIndex = 0 
        self._style = kwargs.get("style", 0)
        self._chance = 0 
        self._blinker = True 
        self._timePassed = 0

    def render( self, alive, delta_time, buffer):
        for i, letter in enumerate( self._text ):
            if self._style == 0:
                colBuff = self._replaceColor(letter, self._lW,  self._lH)
            elif self._style == 1:
                if random.random() > self._chance: 
                    colBuff = self._replaceColor(letter, self._lW,  self._lH)
                else:
                    colBuff = [self._black for x in xrange(self._lW *  self._lH)]
                    self._chance += delta_time*0.1
                if self._chance == 1:
                    self._chance = 0


            elif self._style == 2: 
                if self._blinker: 
                    colBuff = self._replaceColor(letter, self._lW,  self._lH)
                else:
                    colBuff = self._replaceColor(letter, self._lW,  self._lH, self._black)

            buffer.drawImage(self._offset[0] + self._lW * i, self._offset[1], 
                                self._lW , self._lH, 0, 
                                (ctypes.c_int * (self._lW * self._lH))(*colBuff))
        if self._timePassed > self._speed:
            self._timePassed = 0
            self._blinker = not self._blinker
        self._timePassed += delta_time

    def _replaceColor( self, letter, w, h , color = None ):
        if not color:
            color = self._color 
        lw = 10.0/float(w)
        lh = 10.0/float(h)
        newArr = []
        for y in xrange(int(h)):
            posY = int( lh * y) 
            for x in xrange(int(w)): 
                posX = int( lw * x )
                if letter[posY][posX]:
                    newArr.append(color)
                else:
                    newArr.append(0)

        return newArr